/* goats main.c 
   setup & initialization functions */

#include "main.h"
#include "goat.h"
#include "button.h"
#include "about.h"
#include "menu.h"
#include "preferences.h"
#include "summary.h"
#include <malloc.h>
#include <signal.h>

GtkWidget *file_selector, *about, *cross_icon, *hide_icon,
          *delete_icon, *button_menu, *apple, *button;
GtkWidget *menu, *sticky_item, *floating_item, *shaded_item;
GtkWidget *set_alarm_dialog, *notify_menu, *date_menu, *ok_button,
          *cancel_button, *alarm_checkbutton, *message_entry,
          *sound_checkbutton, *date_edit, *sound_file_select, *sound_entry,
          *label3, *alarm_pixmap;
GtkWidget *global_options, *size_options, *colour_options, *raise_options,
          *popup_options, *default_sound_checkbutton, *default_sound_entry,
          *fontpicker, *default_sound_file_select, *ampm_toggle, *autosave_toggle,
          *print_entry, *mail_entry, *default_sticky_checkbutton,
          *default_floating_checkbutton, *scan_toggle,
          *sizespin, *delete_options, *default_fg_button;
GtkWidget *mail_dialog, *address_entry, *subject_entry; 
GtkWidget *ipmsg_dialog, *ip_entry;
GdkCursor *cursor;
GdkPixmap *bg_swatch[3];
GdkGC *global_gc;
GdkColor *default_fg,*default_bg[3];
Goat *current_goat, *alarm_active_goat;
gchar *default_font_name,  *pixmapdir, *default_sound_file,
      *print_command, *mail_command;
gint ox,oy, size_default, last_dispx, last_dispy, colour_default, num_goats, num_saved,
     one=1,two=2,three=3, panel_size;
guint8 red[3],green[3],blue[3], red_fg, green_fg, blue_fg;
gboolean fall_on_release, popup_stay, drag_button, resize_button,
         default_sound, ampm, default_sticky, default_floating, 
         delete_button, autosave, scan;
GList *goats=NULL;
GnomeHelpMenuEntry help = {"goats","help.html"};

int
main (int argc, char *argv[])
{
  gint i,j;
  gboolean without_panel;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

#ifdef PANEL
  without_panel = FALSE;
#else
  without_panel = TRUE;
#endif 

  for (i=1; i<argc; i++) {
    if (strcmp(argv[i],"--without-panel") == 0) {
      g_message("Starting without the Gnome Panel");
      without_panel = TRUE;
      for (j=i; j<argc-1;j++) {
        argv[j] = argv[j+1];
      }
      argc--;
      i--;
    }
  }

  pixmapdir = main_get_pixmap_dir();

  if (without_panel) main_create_button_window(argc,argv);
  else main_create_applet(argc,argv);

  return 1;
}

void
main_create_applet(gint argc, gchar *argv[])
{
#ifdef PANEL
  GnomeClient *client;
  GtkWidget *applet;
  gchar *fname;

  applet_widget_init("goats", VERSION, argc, argv,
                     NULL,0,NULL);

  client = gnome_client_new();
  if (!client) g_message("oops no client");
  gtk_object_ref(GTK_OBJECT(client));
  gtk_object_sink(GTK_OBJECT(client));
  
  gnome_client_set_restart_style(client,GNOME_RESTART_IF_RUNNING);

  applet = applet_widget_new("goats");
  button = gtk_event_box_new();
/*   gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);  */
/*   GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_DEFAULT); */
/*   GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS); */
#endif

#ifdef PANEL_SIZE
  panel_size = applet_widget_get_panel_pixel_size(APPLET_WIDGET(applet));
  gtk_signal_connect(GTK_OBJECT(applet), "change_pixel_size",
                     GTK_SIGNAL_FUNC(main_panel_resize), NULL);
#else
  panel_size = 48;
#endif

#ifdef PANEL
  fname = g_strdup_printf("%s%s",pixmapdir,"goats.png");
  apple = gnome_pixmap_new_from_file_at_size(fname,panel_size-6,panel_size-6);
  g_free(fname);
  gtk_widget_show(apple);
  gtk_container_add(GTK_CONTAINER(button), apple);
  gtk_widget_show(button);

  gtk_signal_connect(GTK_OBJECT(button),"button_press_event",
                     GTK_SIGNAL_FUNC(applet_pressed),
                     NULL);

  gtk_signal_connect(GTK_OBJECT(button),"enter_notify_event",
                     GTK_SIGNAL_FUNC(applet_entered),
                     NULL);

  gtk_signal_connect(GTK_OBJECT(button),"leave_notify_event",
                     GTK_SIGNAL_FUNC(applet_left),
                     NULL);

  gtk_signal_connect(GTK_OBJECT(applet),"destroy",
                     GTK_SIGNAL_FUNC(main_destroyed), NULL); 

  signal(3,main_sigterm_handler); 
  signal(15,main_sigterm_handler); 

  gtk_signal_connect(GTK_OBJECT(applet),"save-session",
                     GTK_SIGNAL_FUNC(main_save_session), NULL); 

  applet_widget_add(APPLET_WIDGET(applet), button);
  gtk_widget_show(applet);

  applet_widget_register_stock_callback_dir(APPLET_WIDGET(applet), "all",
                         GNOME_STOCK_PIXMAP_INDEX, _("My goats...")); 

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/summary",
                         GNOME_STOCK_PIXMAP_ABOUT,
			 _("Show summary"), 
                         GTK_SIGNAL_FUNC(show_summary), NULL);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/raise",
                         GNOME_STOCK_PIXMAP_UP,
			 _("Raise all"), 
                         GTK_SIGNAL_FUNC(my_goats), &goat_raise);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/lower",
                         GNOME_STOCK_PIXMAP_DOWN,
			 _("Lower all"), 
                         GTK_SIGNAL_FUNC(my_goats), &goat_lower);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/hide",
                         GNOME_STOCK_PIXMAP_ADD,
			 _("Hide all"), 
                         GTK_SIGNAL_FUNC(my_goats), &goat_hide);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/show",
                         GNOME_STOCK_PIXMAP_REMOVE,
			 _("Show all"), 
                         GTK_SIGNAL_FUNC(my_goats), &goat_show);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/shade",
                         GNOME_STOCK_PIXMAP_UNDO,
			 _("Shade all"), 
                         GTK_SIGNAL_FUNC(my_goats), &goat_shade_note);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/unshade",
                         GNOME_STOCK_PIXMAP_REDO,
			 _("Unshade all"), 
                         GTK_SIGNAL_FUNC(my_goats), &goat_unshade_note);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "all/delete",
                         GNOME_STOCK_PIXMAP_TRASH,
			 _("Delete all"), 
                         GTK_SIGNAL_FUNC(my_goats), &goat_delete);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "preferences",
                         GNOME_STOCK_PIXMAP_PREFERENCES,
			 _("Preferences"), 
                         GTK_SIGNAL_FUNC(preferences_show), NULL);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "help",
                         GNOME_STOCK_PIXMAP_HELP,
			 _("Help"), 
                         GTK_SIGNAL_FUNC(gnome_help_display), &help);

  applet_widget_register_stock_callback(APPLET_WIDGET(applet), "about",
                         GNOME_STOCK_PIXMAP_ABOUT,
			 _("About"), 
                         GTK_SIGNAL_FUNC(about_show), NULL);

  main_setup_global_stuff();
  applet_widget_gtk_main(); 

#endif
}

#ifdef PANEL_SIZE
void main_panel_resize(GtkWidget *widget, gint size)
{
  panel_size = size;
  applet_left(widget, NULL);
}
#endif

void
main_create_button_window(gint argc, gchar *argv[])
{
  GnomeClient *client;
  GtkWidget *window, *eventbox, *icon;
  gchar *fname;

  gnome_init("goats", VERSION, argc, argv);
  client = gnome_client_new();
  gnome_client_set_restart_style(client,GNOME_RESTART_IF_RUNNING);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "Goats");
  gtk_widget_set_events(window, GDK_BUTTON_PRESS_MASK);

  gtk_widget_show(window);

  eventbox = gtk_event_box_new();
  gtk_widget_show(eventbox);

  fname = g_strdup_printf("%s%s",pixmapdir,"goats.png");
  icon = gnome_pixmap_new_from_file(fname);
  g_free(fname);
  gtk_widget_show(icon);

  gtk_container_add(GTK_CONTAINER(eventbox), icon);
  gtk_container_add(GTK_CONTAINER(window), eventbox);
  gdk_window_resize(window->window,120,50);

  gtk_signal_connect(GTK_OBJECT(eventbox),"button_press_event",
                     GTK_SIGNAL_FUNC(icon_pressed),
                     NULL);

  create_button_menu();
  main_setup_global_stuff();
  gtk_main();

}

void 
main_setup_global_stuff()
{
  /* initialise */

  current_goat = NULL;
  alarm_active_goat = NULL;

  drag_button = FALSE;
  resize_button = FALSE;
  srand((unsigned int)time((time_t *)NULL));

  main_load_defaults(); 
  main_setup_graphics();
  popup_menu_create();
  main_load_goats();
  main_load_new_goats();

  /* make the popup menu */

  gnome_win_hints_init();

  /* set up the timeout every minute */

  gtk_timeout_add(60000,main_timeout, NULL);
}

void
main_load_defaults()
{
  num_goats = 0;
  num_saved = main_get_int("/goats/goats/num_goats",0);
  size_default = main_get_int("/goats/options/size_default",150);
  colour_default = main_get_int("/goats/options/colour_default",1);
  fall_on_release = main_get_bool("/goats/options/fall_on_release", FALSE);
  popup_stay = main_get_bool("/goats/options/popup_stay", TRUE);
  ampm = main_get_bool("/goats/options/ampm", TRUE);
  default_font_name = main_get_string("/goats/options/default_font_name",
				      "-misc-fixed-medium-r-*-*-*-*-*-*-*-*-*-*,*");
  print_command = main_get_string("/goats/options/print_command", 
				  "a2ps --center-title=\"%s\"");
  mail_command = main_get_string("/goats/options/mail_command",
                                 "mail -s \"%s\" %s"); 
  default_sound_file = main_get_string("/goats/options/default_sound_file", 
				       "/usr/share/sounds/goat_bleat.au"); 
  default_sound = main_get_bool("/goats/options/default_sound", FALSE);
  default_sticky = main_get_bool("/goats/options/default_sticky", FALSE);
  default_floating = main_get_bool("/goats/options/default_floating", FALSE);
  delete_button = main_get_bool("/goats/options/delete_button", TRUE);
  autosave = main_get_bool("/goats/options/autosave", FALSE);
  scan = main_get_bool("/goats/options/scan", TRUE);
  red[0] = main_get_int("/goats/options/red1", 255);
  red[1] = main_get_int("/goats/options/red2", 102);
  red[2] = main_get_int("/goats/options/red3", 255);
  blue[0] = main_get_int("/goats/options/blue1", 0);
  blue[1] = main_get_int("/goats/options/blue2", 0);
  blue[2] = main_get_int("/goats/options/blue3", 255);
  green[0] = main_get_int("/goats/options/green1", 255);
  green[1] = main_get_int("/goats/options/green2", 255);
  green[2] = main_get_int("/goats/options/green3", 117);
  red_fg = main_get_int("/goats/options/red_fg", 0);
  blue_fg = main_get_int("/goats/options/blue_fg", 0);
  green_fg = main_get_int("/goats/options/green_fg", 0);
}

void 
main_load_goats()
{
  gint i;
  gchar *section, *version;

  /* create all the goats we have saved */

  version = main_get_string("/goats/options/version", "new");
  if (strcmp(version, VERSION) != 0) main_first_time(); 

  if (num_saved != 0) {
    for (i=0;i<num_saved;i++) {
      section = g_strdup_printf("/goats/goat%i/",i+1);
      main_load_goat(section);
      g_free(section);
    }
  }
}

void main_load_goat(gchar *section)
{
  gint x, y, height, width, colour, alarm_repeat;
  gboolean alarm,notify_message,play_sound, lowered, 
           sticky, floating, shaded, hidden;
  gchar *message,*sound_filename,*text, *font_name, *title_text,
        *key;
  time_t alarm_time;

  key = g_strdup_printf("%s%s",section,"x");
  x = main_get_int(key,0);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"y");
  y = main_get_int(key,0);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"height");
  height = main_get_int(key,size_default);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"width");
  width = main_get_int(key,size_default);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"message");
  message = main_get_string(key,_("Alarm Triggered!"));
  g_free(key);
  key = g_strdup_printf("%s%s",section,"alarm");
  alarm = main_get_bool(key,FALSE);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"alarm_time");
  alarm_time = main_get_int(key,0);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"notify_message");
  notify_message = main_get_bool(key,TRUE);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"play_sound");
  play_sound = main_get_bool(key,FALSE);
  g_free(key);
  key = g_strdup_printf("%s%s",section,"sound_filename");
  sound_filename = main_get_string(key,"");  
  g_free(key);
  key = g_strdup_printf("%s%s",section,"colour");
  colour = main_get_int(key,colour_default);   
  g_free(key);
  key = g_strdup_printf("%s%s",section,"font_name");
  font_name = main_get_string(key,default_font_name);   
  g_free(key);
  key = g_strdup_printf("%s%s",section,"lowered");
  lowered = main_get_bool(key,FALSE);   
  g_free(key);
  key = g_strdup_printf("%s%s",section,"text");
  text = main_get_string(key,NULL); 
  g_free(key);
  key = g_strdup_printf("%s%s",section,"sticky");
  sticky = main_get_bool(key,FALSE); 
  g_free(key);
  key = g_strdup_printf("%s%s",section,"floating");
  floating = main_get_bool(key,FALSE); 
  g_free(key);
  key = g_strdup_printf("%s%s",section,"shaded");
  shaded = main_get_bool(key,FALSE); 
  g_free(key);
  key = g_strdup_printf("%s%s",section,"alarm_repeat");
  alarm_repeat = main_get_int(key,0); 
  g_free(key);
  key = g_strdup_printf("%s%s",section,"hidden");
  hidden = main_get_bool(key,FALSE); 
  g_free(key);
  key = g_strdup_printf("%s%s",section,"title");
  title_text = main_get_string(key,""); 
  g_free(key);

  goat_create(x,y,height,width,message,alarm,alarm_time,
              notify_message, play_sound, 
              sound_filename, text, colour,
              font_name, lowered, sticky, floating, shaded, alarm_repeat,
              title_text, hidden);
}

gboolean main_get_bool(gchar *section, gboolean def)
{
  gboolean value;
  gint flag;
  
  value = gnome_config_get_bool_with_default(section, &flag);
  if (flag) value = def;
  return value;
}

gint main_get_int(gchar *section, gint def)
{
  gint value;
  gint flag;
  
  value = gnome_config_get_int_with_default(section, &flag);
  if (flag) value = def;
  return value;
}

gchar *main_get_string(gchar *section, gchar *def)
{
  gchar *value;
  gint flag;
  
  value = gnome_config_get_string_with_default(section, &flag);
  if (flag) value = def;
  return value;
}

void
main_sigterm_handler(gint anint)
{
  g_message(_("sigterm caught - saving"));
  main_destroyed(NULL);
  gtk_main_quit();
}

gchar *
main_get_pixmap_dir()
{
  gchar *dir;
  dir = g_strdup_printf("%s%s",PACKAGE_PIXMAPS_DIR,"/");
  return dir;
}

void 
main_save_session(GtkWidget *widget)
{
  main_destroyed(NULL);
}

void
main_first_time()
{
  gchar *text;

  text="\nWelcome to Goats 0.6!\n\n\nWhat makes you think\ngraduate school is\nsupposed to be satisfying?\n\n              -- Erica Jong\n";

  goat_create(239,133,200,200,NULL,FALSE,0,TRUE, FALSE,"",
              text,
              1,"-adobe-helvetica-bold-o-normal-*-14-*-*-*-p-*-iso8859-1",
              FALSE,FALSE,FALSE,FALSE,0,"", FALSE);
}

void 
main_setup_graphics()
{
  GtkWidget *temp;
  gchar *fname;
  gint depth,x,y,w,h;

  temp = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_realize(temp);

  fname = g_strdup_printf("%s%s",pixmapdir,"cross.png");
  cross_icon = gnome_pixmap_new_from_file(fname);
  g_free(fname);
  fname = g_strdup_printf("%s%s",pixmapdir,"hide.png");
  hide_icon = gnome_pixmap_new_from_file(fname);
  g_free(fname);

  global_gc = gdk_gc_new(temp->window);
  default_bg[0] = (GdkColor *)g_malloc(sizeof(GdkColor));
  default_bg[1] = (GdkColor *)g_malloc(sizeof(GdkColor));
  default_bg[2] = (GdkColor *)g_malloc(sizeof(GdkColor));

  default_fg = (GdkColor *)g_malloc(sizeof(GdkColor));
  gdk_window_get_geometry(temp->window, &x, &y, &w, &h, &depth);

  bg_swatch[0] = gdk_pixmap_new(NULL,20,20,depth);
  bg_swatch[1] = gdk_pixmap_new(NULL,20,20,depth);
  bg_swatch[2] = gdk_pixmap_new(NULL,20,20,depth);
  preferences_set_default_colours();

  if (delete_button) delete_icon = cross_icon;
  else delete_icon = hide_icon;

  gtk_widget_destroy(temp); 
}

void 
main_exit_program(GtkWidget *widget) 
{
  main_destroyed(NULL);
  gtk_main_quit();
}

gint
main_timeout(gpointer data)
{
  Goat *current;
  gint i;

  /* check the alarms on all the goats */

  for (i=0; i < g_list_length(goats); i++) {
    current = g_list_nth_data(goats,i);
    if (current != alarm_active_goat) goat_check_alarm(current);
  }

  /* Scan for new goats created by other programs */

  if(scan) {
    main_load_new_goats();
  }

  return TRUE;
}

void main_load_new_goats()
{
  gint i, num_new;
  gchar *section;
  gboolean lock;
  time_t thetime;
  GtkWidget *message_box;

  lock = TRUE;
  thetime = time(NULL);
  while(lock) {
    lock = gnome_config_get_bool("/goats_new/goats/lock");
    gtk_main_iteration_do(FALSE);
    if (time(NULL) - thetime > 5) {
      lock = FALSE;
      message_box = gnome_message_box_new(_("File containing new goats is locked!\n\nI have ignored it, but there may be a problem\nwith another program"),
                                        GNOME_MESSAGE_BOX_WARNING,
                                        GNOME_STOCK_BUTTON_OK,
                                        NULL);
      gtk_widget_show(message_box);
      gnome_dialog_run_and_close(GNOME_DIALOG(message_box));
    }
  }
  gnome_config_set_bool("/goats_new/goats/lock",TRUE);
  num_new = main_get_int("/goats_new/goats/num_goats",0);
  if (num_new > 0) {
    for (i=0; i<num_new; i++) {
      section = g_strdup_printf("/goats_new/goat%i/",i+1);
      main_load_goat(section);
      gnome_config_clean_section(section); 
      g_free(section);
    }
    gnome_config_set_int("/goats_new/goats/num_goats",0);
  }
  gnome_config_set_bool("/goats_new/goats/lock",FALSE); 
  gnome_config_sync();
}

gint
main_destroyed(GtkWidget *widget)
{
  Goat *current;
  gchar *section;
  gint i;

  /* save everything for next time */

  gnome_config_set_int("/goats/goats/num_goats",num_goats);

  gnome_config_set_int("/goats/options/size_default",size_default);
  gnome_config_set_int("/goats/options/colour_default",colour_default);
  gnome_config_set_bool("/goats/options/fall_on_release",fall_on_release);
  gnome_config_set_bool("/goats/options/popup_stay",popup_stay);
  gnome_config_set_bool("/goats/options/ampm",ampm);
  gnome_config_set_string("/goats/options/default_font_name",default_font_name);
  gnome_config_set_string("/goats/options/mail_command",mail_command);
  gnome_config_set_string("/goats/options/print_command",print_command);
  gnome_config_set_string("/goats/options/default_sound_file",default_sound_file);
  gnome_config_set_bool("/goats/options/default_sound",default_sound);
  gnome_config_set_bool("/goats/options/default_sticky",default_sticky);
  gnome_config_set_bool("/goats/options/default_floating",default_floating);
  gnome_config_set_string("/goats/options/version",VERSION);
  gnome_config_set_bool("/goats/options/delete_button",delete_button);
  gnome_config_set_bool("/goats/options/autosave",autosave);
  gnome_config_set_bool("/goats/options/scan",scan);
  gnome_config_set_int("/goats/options/red1",red[0]);
  gnome_config_set_int("/goats/options/red2",red[1]);
  gnome_config_set_int("/goats/options/red3",red[2]);
  gnome_config_set_int("/goats/options/green1",green[0]);
  gnome_config_set_int("/goats/options/green2",green[1]);
  gnome_config_set_int("/goats/options/green3",green[2]);
  gnome_config_set_int("/goats/options/blue1",blue[0]);
  gnome_config_set_int("/goats/options/blue2",blue[1]);
  gnome_config_set_int("/goats/options/blue3",blue[2]);
  gnome_config_set_int("/goats/options/red_fg",red_fg);
  gnome_config_set_int("/goats/options/green_fg",green_fg);
  gnome_config_set_int("/goats/options/blue_fg",blue_fg);

  /* now save the goats */

  for (i=0; i < g_list_length(goats); i++) {
    current = g_list_nth_data(goats,i);
    section = g_strdup_printf("/goats/goat%i/",i+1);
    goat_save(current,section);
    g_free(section);
  }

  /* free any unused sections */

  if(num_saved > num_goats) {
    for (i=num_goats; i < num_saved; i++) {
      section = g_strdup_printf("/goats/goat%i/",i+1);
      gnome_config_clean_section(section);
      g_free(section);
    }
  }

  /* and write it all to disk */

  gnome_config_sync();
  return FALSE;

}

void
main_update_delete_icon()
{
  Goat *current;
  gint i;


  if (delete_button) delete_icon = cross_icon;
  else delete_icon = hide_icon;

  for (i=0; i < g_list_length(goats); i++) {
    current = g_list_nth_data(goats,i);
    gtk_widget_destroy(current->cross);
    current->cross = gnome_pixmap_new_from_gnome_pixmap(GNOME_PIXMAP(delete_icon));
    gtk_widget_show(current->cross);
    gtk_container_add(GTK_CONTAINER(current->eventbox3),current->cross);
  }
}

void
main_create_file_selector(GtkWidget *destination)
{
  file_selector = gtk_file_selection_new(_("Select a sound file"));
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(file_selector),
                              "/usr/share/sounds/");

  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button),
                     "clicked", GTK_SIGNAL_FUNC (main_get_filename), destination);
  gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
                     "clicked", GTK_SIGNAL_FUNC (main_file_selector_cancel),NULL);

  gtk_widget_show(file_selector);
}

void
main_get_filename(GtkWidget *widget, GtkWidget *destination)
{
  gchar *filename;

  /* get the filename we selected for the sound & display it */

  filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector));
  gtk_entry_set_text(GTK_ENTRY(destination),filename);
  
  gtk_widget_destroy(file_selector);
}

void
main_file_selector_cancel(GtkWidget *widget)
{
  gtk_widget_destroy(file_selector);
}

void show_summary(GtkWidget *widget)
{
  summary_show();
}

void main_new_goat()
{
    goat_create(-1,-1,size_default,size_default,_("Alarm Triggered!"),FALSE,0,
                    TRUE, default_sound, default_sound_file,NULL,colour_default,default_font_name,
                    FALSE,default_sticky, default_floating, FALSE,0,"", FALSE);
}

