;;; bounce.scm: Bounce the messages to other buddies in the list too
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; bounce.scm will be automatically loaded thru init.scm
;;; (define bounce '((rms . (gnuindian nagappanal kvisu2000 bala))
;;; 		 (gopal . (mehta))))

(if (defined? 'bounce)
    '()
    (begin
      (define bounce '())))
 
(define (bounce-buddy from msg)
  "bounce the messages sent to buddy"
  (and (list? (assq-ref bounce (string->symbol from)))
       (send-message-to-group (assq-ref bounce (string->symbol from))
			      (string-append "Bounce:" from " " msg))))

(add-hook! gy-message-receive-hook bounce-buddy)

;;; Dynamic command support
(gy-register-command! '("?bounce" "?bounce buddy-name bounce-list\n\t- bounce message of a buddy to a bounce-list"))

(define (?bounce args-list)
  (if (> (length args-list) 1)
      (set! bounce (assoc-set! bounce (car args-list) (cdr args-list)))
      (begin (display "?bounce: wrong number of arguments") (newline) (display "usage: ?bounce buddy-name bounce-list") (newline))))
