/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef GNUT_H
#define GNUT_H

#include "qry.h"
#include "protocol.h"

#ifdef __cplusplus
extern "C" {
#endif

  /* 0.4.28.c01 Moved all mutexes to gnut.c */
  extern pthread_mutex_t ctfu_mutex;
  extern pthread_mutex_t gc_list_mutex;
  extern pthread_mutex_t host_mutex;
  extern pthread_mutex_t lruh_mutex;
  extern pthread_mutex_t make_conn_mutex;
  extern pthread_mutex_t monitor_mutex;
  extern pthread_mutex_t push_crc_mutex;
  extern pthread_mutex_t push_mutex;
  extern pthread_mutex_t qrepl_mutex;
  extern pthread_mutex_t query_mutex;
  extern pthread_mutex_t query_packet_mutex;
  extern pthread_mutex_t route_mutex;
  extern pthread_mutex_t send_mutex;
  extern pthread_mutex_t share_hash_mutex;
  extern pthread_mutex_t share_mutex;
  extern pthread_mutex_t transfer_mutex;

  extern int gh_error;
  extern uint32 gnut_heartbeat;
  extern int trigger_bug1;

  void gnut_mutexes_init(void); /* 0.4.28.c01 */

  int gnut_init();
  int gnut_outgoing_new(char *host);
  int gnut_push_new(gnutella_push_a *gp);
  int gnut_start_main_loop();
  int gnut_xfer_start(query_resp *qr);
  int gnut_global_rate();
  int get_rate_limit(int download);

#ifdef __cplusplus
}
#endif

#endif
