#include <config.h>

#include "filter.h"
#include "sample.h"
#include <samplerate.h>

struct resample_filter {
    struct filter filter;
    SRC_STATE *src;
};

struct filter *
filter_resample_new(struct filter *src,
                    size_t sz,
                    int converter_type) {
    int error;
    struct filter *f = filter_new(src, sz);

    if(!f) 
        return NULL;

    ((struct resample_filter *)f)->src = 
        src_new(converter_type, src->get_channels(src), &error);

    f->read = filter_resample_read;
    f->write = filter_resample_write;
    f->seek = filter_resample_seek;
    f->destroy = filter_resample_destroy;
    f->get_format = filter_resample_get_format;
    f->get_channels = src->get_channels;

    return f;
}

long long
filter_resample_read(struct filter *f, 
                     void *buf, 
                     long long *count) {
}


long long
filter_resample_write(struct filter *f, 
                      void *buf, 
                      long long *count) {
}


long long
filter_resample_seek(struct filter *f, 
                     long long *count,
                     int whence) {
}

enum sample_type
filter_resample_get_format(struct filter *f) {
    return f->src->get_format(f->src);
}


#ifndef FILTER_H
#define FILTER_H

struct filter {
    struct filter *src;
    long long src_pos;

    long long (*read)(struct filter *f, void *buf, long long *count);

    long long (*write)(struct filter *f, void *buf, long long *count);

    long long (*seek)(struct filter *f, long long *count, int whence);
    
    void (*destroy)(struct filter *f);
};

struct filter *
filter_new(struct filter *src,
           size_t sz);

void
filter_destroy(struct filter *f);

long long 
filter_read(struct filter *f, 
            void *buf, 
            long long *count);

long long 
filter_write(struct filter *f, 
             void *buf, 
             long long *count);

long long 
filter_seek(struct filter *f, 
            long long *count,
            int whence);

int 
filter_get_output_channels(struct filter *f);

int 
filter_get_input_channels(struct filter *f);

#endif /* ! FILTER_H */
