/*
 * Copyright (C) 2002,2003 Pascal Haakmat.
 */

#include "../modutils.h"

module modinfo;

module *
module_new() {
    MODULE_INIT(&modinfo,
		"Declip",
		"Pascal Haakmat",
		"Copyright (C) 2002,2003");
    return &modinfo;
}

void
declip(shell *shl,
       track *tr,
       AFframecount start_offset,
       AFframecount end_offset,
       int32_t upper_trsh,
       int32_t lower_trsh) {
    int i;
    int32_t prev_sample = 0;
    ITERATOR_INIT(start_offset, end_offset - start_offset);
    ITERATOR(shl, tr, 
             for(i = 0; i < iter_read; i++) {
                 if(prev_sample > upper_trsh && 
                    int32_frame_bits[i] < lower_trsh) {
                     DEBUG("declip: clip at sample %ld\n", iter_frame_offset);
                     int32_frame_bits[i] = prev_sample;
                 }
                 prev_sample = int32_frame_bits[i];
             }
             track_int32_frames_replace(tr,
                                        int32_frame_bits,
                                        iter_frame_offset,
                                        iter_read));
    ITERATOR_EXIT();
    return;
}

action_group *
module_execute(shell *shl, 
               int undo) {
    int upper_tresh = INT_MIN + 5000;
    int lower_tresh = INT_MIN + 400;
    int t, map = shl->select_channel_map;
    AFframecount start = shl->select_start, end = shl->select_end;
    action_group *undo_ag = NULL;

    rwlock_rlock(&shl->sr->rwl);
    
    if(undo) 
        undo_ag = action_group_undo_create(shl,
                                           map, 
                                           start,
                                           end - start,
                                           start,
                                           end - start);
    
    for(t = 0; t < snd_track_count(shl->sr); t++) 
        if((1 << t) & map) 
            declip(shl,
                   shl->sr->tracks[t],
                   start,
                   end,
                   upper_tresh,
                   lower_tresh);
    rwlock_runlock(&shl->sr->rwl);
    
    return undo_ag;
}
