/*
**  Group.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "Group.h"

#import "Address.h"
#import "GNUMailConstants.h"

@implementation Group

//
//
//

- (id) init
{
  self = [super init];

  addresses = [[NSMutableArray alloc] init];
  
  return self;
}

- (id) initWithName: (NSString *) theName
{
  self = [self init];

  [self setName: theName];

  return self;
}

- (void) dealloc
{
  RELEASE(name);
  RELEASE(addresses);

  [super dealloc];
}

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: [self name] ];
  [theCoder encodeObject: [self addresses]];
}

- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];
  
  addresses = [[NSMutableArray alloc] init];

  [self setName: [theCoder decodeObject]];
  [self setAddresses: [theCoder decodeObject] ];

  return self;
}


//
// access/mutation methods
//
- (NSString *) name
{
  return name;
}

- (void) setName: (NSString *) theName
{
  RETAIN(theName);
  RELEASE(name);
  name = theName;
}

- (Address *) addressAtIndex: (int) theIndex
{
  return [addresses objectAtIndex: theIndex];
}


- (NSArray *) addresses
{
  return [NSArray arrayWithArray: addresses];
}

- (void) setAddresses: (NSArray *) theAddresses
{
  [addresses addObjectsFromArray: theAddresses]; 
}


//
// This method will verify if an address is already in the
// group before adding it.
//
- (void) addAddress: (Address *) theAddress
{
  if ( theAddress )
    {
      int i;
      
      for (i = 0; i < [addresses count]; i++)
	{
	  Address *anAddress;

	  anAddress = [addresses objectAtIndex: i];
	  
	  if ( [[anAddress description] caseInsensitiveCompare: [theAddress description]] == NSOrderedSame)
	    {
	      return;
	    }
	}
      
      [addresses addObject: theAddress];
    }
  else
    {
      NSLog(@"Tried to add a nil object to the group %@", [self name]);
    }
}

- (void) removeAddress: (Address *) theAddress
{
  if ( theAddress )
    {
      [addresses removeObject: theAddress];
    }
  else
    {
      NSLog(@"Tried to remove a nil object from the group %@", [self name]);
    }
}

- (void) removeAllAddresses
{
  [addresses removeAllObjects];
}

- (int) compareAccordingToName: (Group *) aGroup
{
  return [name compare: [aGroup name]];
}

- (void) sort
{
  [addresses sortUsingSelector: @selector(compareAccordingToName:)];
}

@end
