/*
**  FilteringView.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "FilteringView.h"

#import "GNUMailConstants.h"

#import "ExtendedTableView.h"
#import "ExtendedTableColumn.h"

@implementation FilteringView

//
//
//
- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;
  
  return self;
}


//
//
//
- (void) dealloc
{
  RELEASE(rulesColumn);
  RELEASE(activeColumn);

  RELEASE(tableView);
  
  [super dealloc];
}


//
//
//
- (void) layoutView
{
  NSButtonCell *cell;

  rulesColumn = [[ExtendedTableColumn alloc] initWithIdentifier: FilteringViewRulesColumnIdentifier];
  [rulesColumn setEditable: NO];
  [[rulesColumn headerCell] setStringValue: _(@"Rules")];
  [rulesColumn setMinWidth: 275];

  activeColumn = [[ExtendedTableColumn alloc] initWithIdentifier: FilteringViewRulesColumnIdentifier];
  [activeColumn setEditable: NO];
  
  // We set our custom cell for the active column
  cell = [[NSButtonCell alloc] init];
  [cell setButtonType: NSSwitchButton];
  [cell setImagePosition: NSImageOnly];
  [activeColumn setDataCell: cell];
  RELEASE(cell);
  [activeColumn setShouldUseAndSetState: YES];
  [activeColumn setShouldUseMouse: YES];
  
  [[activeColumn headerCell] setStringValue: _(@"Active")];
  [activeColumn setMinWidth: 50];
  
  tableView = [[ExtendedTableView alloc] initWithFrame: NSMakeRect(5,40,430,300)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: NO];
  [tableView addTableColumn: rulesColumn];
  [tableView addTableColumn: activeColumn];
  [tableView setDataSource: parent];
  [tableView setDelegate: parent];
  [tableView setTarget: parent];
  [tableView setDoubleAction: @selector(edit:)];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,40,430,300)];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setDocumentView: tableView];
  [self addSubview: scrollView];
  RELEASE(scrollView);
  
  add = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,75,ButtonHeight)];
  [add setTitle: _(@"Add...")];
  [add setTarget: parent];
  [add setAction: @selector(add:)];
  [self addSubview: add];
  RELEASE(add);
  
  delete = [[NSButton alloc] initWithFrame: NSMakeRect(85,5,75,ButtonHeight)];
  [delete setTitle: _(@"Delete")];
  [delete setTarget: parent];
  [delete setAction: @selector(delete:)];
  [self addSubview: delete];
  RELEASE(delete);
  
  edit = [[NSButton alloc] initWithFrame: NSMakeRect(165,5,75,ButtonHeight)];
  [edit setTitle: _(@"Edit...")];
  [edit setTarget: parent];
  [edit setAction: @selector(edit:)];
  [self addSubview: edit];
  RELEASE(edit);

  duplicate = [[NSButton alloc] initWithFrame: NSMakeRect(245,5,75,ButtonHeight)];
  [duplicate setTitle: _(@"Duplicate")];
  [duplicate setTarget: parent];
  [duplicate setAction: @selector(duplicate:)];
  [self addSubview: duplicate];
  RELEASE(duplicate);

  moveUp = [[NSButton alloc] initWithFrame: NSMakeRect(330,5,50,ButtonHeight)];
  [moveUp setTitle: @""];
  [moveUp setImagePosition: NSImageOnly];
  [moveUp setImage: [NSImage imageNamed: @"up.tiff"]];
  [moveUp setTarget: parent];
  [moveUp setAction: @selector(moveUp:)];
  [self addSubview: moveUp];
  RELEASE(moveUp);
  
  moveDown = [[NSButton alloc] initWithFrame: NSMakeRect(385,5,50,ButtonHeight)];
  [moveDown setTitle: @""];
  [moveDown setImagePosition: NSImageOnly];
  [moveDown setImage: [NSImage imageNamed: @"down.tiff"]];
  [moveDown setTarget: parent];
  [moveDown setAction: @selector(moveDown:)];
  [self addSubview: moveDown];
  RELEASE(moveDown);
}


//
// access methods
//
- (NSTableView *) tableView
{
  return tableView;
}

- (NSTableColumn *) rulesColumn
{
  return rulesColumn;
}

- (NSTableColumn *) activeColumn
{
  return activeColumn;
}

- (NSButton *) add
{
  return add;
}

- (NSButton *) delete
{
  return delete;
}

- (NSButton *) edit
{
  return edit;
}

- (NSButton *) duplicate
{
  return duplicate;
}

- (NSScrollView *) scrollView
{
  return scrollView;
}

@end

