/*
**  AddressBookController.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Jonathan B. Leffert <jonathan@leffert.net>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class Address;
@class AddressBook;
@class Group;

@interface AddressBookController: NSWindowController
{
  // Outlets
  IBOutlet NSBrowser *browser;
  IBOutlet NSTextField *nameTextField;
  IBOutlet NSButton *add;
  IBOutlet NSButton *delete;
  IBOutlet NSButton *modify;
  IBOutlet NSPopUpButton *popup;

  // Other ivar
  AddressBook *addressBook;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

- (void) addToAddressBook: (Address *) theAddress;

//
// action methods
//

- (IBAction) addAddress: (id) sender;
- (IBAction) addGroup: (id) sender;

- (IBAction) deleteAddress: (id) sender;
- (IBAction) deleteGroup: (id) sender;

- (IBAction) doubleClicked: (id) sender;
- (IBAction) toClicked: (id) sender;
- (IBAction) ccClicked: (id) sender;
- (IBAction) bccClicked: (id) sender;

- (IBAction) modifyAddress: (id) sender;
- (IBAction) modifyGroup: (id) sender;

- (IBAction) importClicked: (id) sender;

- (IBAction) selectionInPopUpHasChanged: (id) sender;

#ifdef MACOSX
- (IBAction) selectionInBrowserHasChanged: (id) sender;
#endif

//
// delegate methods
//
- (void) windowDidLoad;

- (int)       browser: (NSBrowser *) sender
 numberOfRowsInColumn: (int) column;

- (void) browser: (NSBrowser *) sender
 willDisplayCell: (id) cell
	   atRow: (int) row
          column: (int) column;

- (BOOL) browser: (NSBrowser *) sender
       selectRow: (int) row
        inColumn: (int) column;

- (NSString *) browser: (NSBrowser *) sender
         titleOfColumn: (int) column;

//
// access/mutation methods
//
- (AddressBook *) addressBook;
- (void) setAddressBook: (AddressBook *) theBook;

//
// class methods
//

+ (id) singleInstance;

@end


//
// Private methods
//
@interface AddressBookController (Private)

- (void) _loadItemsInMoveToPopUpButton;

@end

