/* GnoSamba 0.3.3
 * copyright 1998-9 Perry Piplani
 * redistributable under the terms of the GPL:
 * http://www.gnu.org/copyleft/gpl.html
 */



#ifndef GTKSAMBA_H
#define GTKSAMBA_H

#include <gnome.h>
#include "mguru.h"
#include "choicebox.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

/* gtksamba.c */

GtkWidget *smbwin_new(char *file);
void smbwin_open(GtkWidget *window, char *file);
gint sw_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);
void c_smbwin_new(GtkWidget *button, gpointer nulldata);
void c_smbwin_close(GtkWidget *button, gpointer nulldata);
void c_smbwin_destroy(GtkWidget *widget, gpointer window);
void c_alt_open(GtkWidget *button, gpointer window);
void c_conf_open(GtkWidget *button, gpointer window);
void c_write_conf(GtkWidget *widget, gpointer window);
void c_write_alt(GtkWidget *widget, gpointer window);

void c_edit_param(GtkWidget *menu_item, gpointer window);
void c_delete_param(GtkWidget *menu_item, gpointer window);
void c_insert_service(GtkWidget *menu_item, gpointer window);
void c_delete_service(GtkWidget *menu_item, gpointer window);
void c_help_about(GtkWidget *widget, gpointer data);
void c_help_sel_param(GtkWidget *widget, gpointer data);

void sw_error(char *message);
void cw_make_sensitive(GtkWidget *widget);

void c_param_diag_cancel(GtkWidget *button, gpointer data);
void c_param_diag_delete(GtkWidget *button, GdkEvent *event, 
			  gpointer data);
void c_make_exit_dialog(GtkWidget *widget, gpointer data);

void desensitize_sw(GtkWidget *window);
void resensitize_sw(GtkWidget *window);

/* diagmenu.c */

void sw_main_menu(GtkWidget *window);
void sw_toolbars(GtkWidget *window);
void make_del_dialog(GtkWidget *window);
void make_del_service_dialog(GtkWidget *window);
void make_insert_service_dialog(GtkWidget *window);
void make_user_mesg(char *message, char *title);

/* conflists.c */

void smbwin_open_lists(GtkWidget *window, char *file);
void smbwin_clear_lists(GtkWidget *window);
void write_smb_file(GtkWidget *servicelist,char *filepath);
void smbwin_update(GtkWidget *window, int row, char *text);

void smbwin_delete_service(GtkWidget *window);
void smbwin_insert_service(char *service, GtkWidget *window);

void c_select_service(GtkWidget *widget,
		    gint row,
		    gint column,
		    GdkEventButton *event,
		    gpointer data);

void c_select_param(GtkWidget *widget,
		    gint row,
		    gint column,
		    GdkEventButton *event,
		    gpointer data);

void make_param_help(char *param);
void c_make_overview(GtkWidget *widget, gpointer data);
void c_man_testparm(GtkWidget *widget, gpointer data);
void c_man_smbstatus(GtkWidget *widget, gpointer data);
void c_make_param_lookup(GtkWidget *widget, gpointer data);
void c_run_testparm(GtkWidget *menu_item, gpointer window);
void c_run_smbstatus(GtkWidget *widget, gpointer data);
void c_restart_samba(GtkWidget *widget, gpointer data);

/* parmstruc.c */

int is_oct(int c);
void make_edit_dialog(GtkWidget *window);
void c_make_inserter(GtkWidget *widget, gpointer  data);

/* prefs.c */

void check_prefs();
void c_make_pref_box(GtkWidget *widget, gpointer  data);
char *get_config_val(char *sect, char *name);

#endif 

