/* mguru.h - Multiway guru widget.

   Copyright (C) 1999 Perry Piplani. Idea inspired by Havoc
   Pennington's gnome-guru widget, but is a re-implemention
   from scratch.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License
   as published by the Free Software Foundation; either version 2, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef __GNOME_CHOICE_BOX_H__
#define __GNOME_CHOICE_BOX_H__

#include <gnome.h>

BEGIN_GNOME_DECLS

#define GNOME_CHOICE_BOX(Obj)         GTK_CHECK_CAST (Obj, gnome_choice_box_get_type (), GnomeChoiceBox)
#define GNOME_CHOICE_BOX_CLASS(Klass) GTK_CHECK_CLASS_CAST (Klass, gnome_choice_box_get_type (), GnomeChoiceBoxClass)
#define GNOME_IS_CHOICE_BOX(Obj)      GTK_CHECK_TYPE (Obj, gnome_choice_box_get_type ())

typedef enum
{
  CHOICE_BOX_VV,
  CHOICE_BOX_VH,
  CHOICE_BOX_HV,
  CHOICE_BOX_HH
} ChoiceBoxLayout;



typedef struct _GnomeChoiceBox GnomeChoiceBox;
typedef struct _GnomeChoiceBoxClass GnomeChoiceBoxClass;

struct _GnomeChoiceBox
{
  GtkVBox vbox;
  GSList *group;
  gint choices;
};

struct _GnomeChoiceBoxClass
{
  GtkVBoxClass parent_class;
  
  void (* choice_made) (GnomeChoiceBox *choicebox);

};

guint gnome_choice_box_get_type (void);


GtkWidget *gnome_choice_box_new (ChoiceBoxLayout layout,
				 gchar *question,...);

GtkWidget *gnome_choice_box_newv (ChoiceBoxLayout layout,
				  gchar *question,
				  gchar **options);

gchar *gnome_choice_box_get_choice(GnomeChoiceBox *choicebox);

gint gnome_choice_box_get_index(GnomeChoiceBox *choicebox);

gint gnome_choice_box_set_choice(GnomeChoiceBox *choicebox, gchar *choice);

gint gnome_choice_box_set_index(GnomeChoiceBox *choicebox, gint index);

END_GNOME_DECLS

#endif /* __GNOME_CHOICE_BOX_H___ */
