/*  GnomeKiss - A KiSS viewer for the GNOME desktop
    Copyright (C) 2000-2001  Nick Lamb <njl195@zepler.org.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "kiss.h"

/* Central error logging service */

static guint line_no= 0;

static void log_line(char *file, char *line, char *message) {
  gchar *text[3];

  if (prefs.error_list) {
    gtk_widget_show(error_list);
  }
  text[0]= file;
  text[1]= line;
  text[2]= message;
  gtk_clist_append(GTK_CLIST(error_clist), text);
}

#if 0
static void log_stderr(char *file, char *line, char *message) {

  fprintf(stderr, "%s:%s %s\n", file, line, message);
}
#endif

void log_error(char *format, ...) {
  gchar line[6], *message;
  va_list args;

  va_start(args, format);
  message= g_strdup_vprintf(format, args);
  if (config.filename != NULL) {
    if (line_no > 0)
      snprintf(line, 7, "%u", line_no);
    else
      strcpy(line, "N/A");
    log_line(config.filename, line, message);
  } else {
    log_line("(none)", "N/A", message);
  }
  g_free(message);
  va_end(args);
}

void log_warning(char *format, ...) {
  gchar line[7], *message;
  va_list args;

  if (!prefs.warnings) {
    return;
  }

  va_start(args, format);
  message= g_strdup_vprintf(format, args);
  if (config.filename != NULL) {
    if (line_no > 0)
      snprintf(line, 7, "%u*", line_no);
    else
      strcpy(line, "N/A");
    log_line(config.filename, line, message);
  } else {
    log_line("(none)", "N/A", message);
  }
  g_free(message);
  va_end(args);
}

void set_line(guint line) {
  line_no= line;
}
