/****************************
  Basic code for ICQ v6-7 protocol (Oscar)
  Olivier Crete (c) 2001
  GnomeICU
*****************************/

#include "common.h"
#include "util.h"
#include "v7snac13.h"
#include "gnomeicu.h"

#define REG_COL       "\x1B[0m"


V7Connection *mainconnection = NULL;
GSList       *requests       = NULL;
GSList       *otherconnections = NULL;

gboolean flap_send(V7Connection *conn, BYTE flap_channel, gchar *data,
                   WORD len)
{
  guchar buffer[6];
  guint nw;

#ifdef TRACE_FUNCTION
  g_print( "flap_send\n" );
#endif

  if (!conn || conn->status == NOT_CONNECTED || conn->status==BROKEN)
    return FALSE;

  buffer[0] = 0x2a;
  buffer[1] = flap_channel;
  Word_2_CharsBE(buffer+2, conn->sequence++);
  Word_2_CharsBE(buffer+4, len);


  if (gnet_io_channel_writen(conn->iochannel, buffer, 6, &nw) !=
      G_IO_ERROR_NONE)
    return FALSE;

  if (toggles->packet_udp)
    print_data(data, len);

  if (len)
    if (gnet_io_channel_writen(conn->iochannel, data, len, &nw) !=
        G_IO_ERROR_NONE)
      return FALSE;
  
  return TRUE;
}

DWORD snac_send(V7Connection *conn, gchar *data, WORD len, 
                   WORD family, WORD subtype, BYTE flags[2], DWORD reqid)
{
  gchar *buffer;

#ifdef TRACE_FUNCTION
  g_print( "snac_send\n" );
#endif

  if (!conn || conn->status == NOT_CONNECTED || conn->status==BROKEN)
    return 0;

  if (reqid == ANY_ID)
    reqid = conn->last_reqid++;

  buffer = g_malloc0(len+10);

  Word_2_CharsBE(buffer, family);
  Word_2_CharsBE(buffer+2, subtype);
  if (flags) {
    buffer[4] = flags[0];
    buffer[5] = flags[1];
  } else 
    buffer[4] = buffer[5] = 0;
  DW_2_CharsBE(buffer+6, reqid);
  
  g_memmove(buffer+10, data, len);

  if (! flap_send(conn, CHANNEL_SNAC, buffer, len+10)) {
    g_free(buffer);
    return 0;
  }
  
  g_free(buffer);
  return reqid;
}


V7Packet *read_flap( V7Connection *conn)
{
  guint nr;

#ifdef TRACE_FUNCTION
  g_print( "read_flap\n" );
#endif

  if (!conn)
    return NULL;



  if (conn->latest_packet == NULL) {
    
    if (gnet_io_channel_readn(conn->iochannel,
                              conn->latest_head + conn->bytes_read_in_latest,
                              6-conn->bytes_read_in_latest, &nr) !=
        G_IO_ERROR_NONE) {
      return NULL;
    }

    conn->bytes_read_in_latest += nr;
    conn->total_read +=nr;

    /* If we have the whole header */
    if (conn->bytes_read_in_latest == 6) {
      conn->latest_packet = g_malloc0( sizeof(V7Packet));
      conn->latest_packet->channel = conn->latest_head[1];
      /* sequence number not read */
      conn->latest_packet->len = CharsBE_2_Word (conn->latest_head+4);
      
      conn->latest_packet->data = g_malloc(conn->latest_packet->len);
      
      conn->latest_head[0] = '\0';
      conn->bytes_read_in_latest = 0;
    } else {
      return NULL;
    }
  }

  if (gnet_io_channel_readn(conn->iochannel,
                            conn->latest_packet->data + 
                                             conn->bytes_read_in_latest,
                            conn->latest_packet->len -
                                             conn->bytes_read_in_latest,
                            &nr) != G_IO_ERROR_NONE )
    return NULL;
  
  
  conn->bytes_read_in_latest += nr;
  conn->total_read +=nr;
  
  if (conn->bytes_read_in_latest == conn->latest_packet->len) {
    V7Packet *packet;
    packet = conn->latest_packet;
    conn->latest_packet = NULL;
    conn->bytes_read_in_latest = 0;
    if (toggles->packet_udp)
      packet_print_v7(packet);
    return packet;
  }
  
  return NULL;
  
}

Snac *read_snac(V7Packet *packet)
{
  Snac *snac;

  snac = g_malloc0(sizeof(Snac));

  snac->family = CharsBE_2_Word(packet->data);
  snac->type   = CharsBE_2_Word(packet->data+2);
  snac->flags[0] = packet->data[4];
  snac->flags[1] = packet->data[5];
  snac->reqid  = CharsBE_2_DW(packet->data+6);
  snac->datalen= packet->len - 10;
  snac->data = g_malloc0 (snac->datalen);
  g_memmove (snac->data, packet->data + 10, snac->datalen);

  return snac;
}

TLV *new_tlv(BYTE *place)
{
  TLV *tlv;

  tlv = g_malloc0(sizeof (TLV));
  
  tlv->type = CharsBE_2_Word(place);
  tlv->len = CharsBE_2_Word(place+2);

  tlv->value = g_malloc0(tlv->len + 1);

  /* Make sure its null terminated */
  tlv->value[tlv->len] = '\0';

  g_memmove(tlv->value, place+4, tlv->len);

  if (toggles->packet_udp)
    g_print("newtlv type:%x len: %d\n", tlv->type, tlv->len);

  return tlv;
}

void delete_tlv (TLV *tlv) 
{
  g_free(tlv->value);
  g_free(tlv);
}



void add_tlv_w_be(TLVstack *tlvs, WORD type, WORD data)
{
  gchar buffer[2];
  
#ifdef TRACE_FUNCTION
  g_print( "add_tlv_w_be\n" );
#endif

  Word_2_CharsBE(buffer, data);
  add_tlv (tlvs, type, buffer, 2);
}

void add_tlv_w_le(TLVstack *tlvs, WORD type, WORD data)
{
  gchar buffer[2];
  
#ifdef TRACE_FUNCTION
  g_print( "add_tlv_w_le\n" );
#endif

  Word_2_Chars(buffer, data);
  add_tlv (tlvs, type, buffer, 2);
}

void add_tlv_dw_be(TLVstack *tlvs, WORD type, DWORD data)
{
  gchar buffer[4];

#ifdef TRACE_FUNCTION
  g_print( "add_tlv_dw_be\n" );
#endif
  
  DW_2_CharsBE(buffer, data);
  add_tlv (tlvs, type, buffer, 4);
}


void add_tlv_dw_le(TLVstack *tlvs, WORD type, DWORD data)
{
  gchar buffer[4];

#ifdef TRACE_FUNCTION
  g_print( "add_tlv_dw_le\n" );
#endif
  
  DW_2_Chars(buffer, data);
  add_tlv (tlvs, type, buffer, 4);
}


void add_tlv (TLVstack *tlvs, WORD type, const gchar *data, WORD len)
{

#ifdef TRACE_FUNCTION
  g_print( "add_tlv\n" );
#endif

  if(tlvs->beg == NULL)
    tlvs->beg = g_malloc0(len + 4);
  else
    tlvs->beg = g_realloc(tlvs->beg, tlvs->len + len + 4);
  tlvs->end = tlvs->beg + tlvs->len;

  Word_2_CharsBE(tlvs->end, type);
  Word_2_CharsBE(tlvs->end+2, len);
  g_memmove(tlvs->end+4, data, len);

  tlvs->len += len + 4;
  tlvs->end = tlvs->beg + tlvs->len;
}

void add_nontlv_w_be(TLVstack *tlvs, WORD data)
{
  gchar buffer[2];
  
#ifdef TRACE_FUNCTION
  g_print( "add_nontlv_w\n" );
#endif

  Word_2_CharsBE(buffer, data);
  add_nontlv (tlvs, buffer, 2);
}

void add_nontlv_w_le(TLVstack *tlvs, WORD data)
{
  gchar buffer[2];
  
#ifdef TRACE_FUNCTION
  g_print( "add_nontlv_w\n" );
#endif

  Word_2_Chars(buffer, data);
  add_nontlv (tlvs, buffer, 2);
}

void add_nontlv_dw_be(TLVstack *tlvs, DWORD data)
{
  gchar buffer[4];

#ifdef TRACE_FUNCTION
  g_print( "add_nontlv_dw_be\n" );
#endif
  
  DW_2_CharsBE(buffer, data);
  add_nontlv (tlvs, buffer, 4);
}

void add_nontlv_dw_le(TLVstack *tlvs, DWORD data)
{
  gchar buffer[4];

#ifdef TRACE_FUNCTION
  g_print( "add_nontlv_dw_le\n" );
#endif
  
  DW_2_Chars(buffer, data);
  add_nontlv (tlvs, buffer, 4);
}

/* add LNTS type (little endian) string to tlvs, null terminated */
void add_nontlv_lnts (TLVstack *tlvs, const gchar *string)
{

#ifdef TRACE_FUNCTION
  g_print( "add_nontlv_lnts\n" );
#endif

  if (string) {
    add_nontlv_w_le (tlvs, strlen(string)+1);
    add_nontlv (tlvs, string, strlen(string)+1);
  } else
    add_nontlv_w_le (tlvs, 0);
}

/* add BWS type (big endian) string to tlvs, excluding null */
void add_nontlv_bws (TLVstack *tlvs, const gchar *string)
{

#ifdef TRACE_FUNCTION
  g_print( "add_nontlv_bws\n" );
#endif

  if (string) {
    add_nontlv_w_be (tlvs, strlen(string));
    add_nontlv (tlvs, string, strlen(string));
  } else
    add_nontlv_w_be (tlvs, 0);
}


void add_nontlv (TLVstack *tlvs, const gchar *data, WORD len)
{

#ifdef TRACE_FUNCTION
  g_print( "add_nontlv\n" );
#endif

  if(tlvs->beg == NULL)
    tlvs->beg = g_malloc0(len);
  else
    tlvs->beg = g_realloc(tlvs->beg, tlvs->len + len);
  tlvs->end = tlvs->beg + tlvs->len;

  g_memmove(tlvs->end, data, len);
  
  tlvs->len += len;
  tlvs->end = tlvs->beg + tlvs->len;
  
}



TLVstack *new_tlvstack (const gchar *initdata, guint init_len)
{
  
  TLVstack *tlvs;

#ifdef TRACE_FUNCTION
  g_print( "new_tlvstack\n" );
#endif

  tlvs = g_malloc0(sizeof (TLVstack));
  
  if (initdata) {
    tlvs->len = init_len;
    tlvs->beg = g_malloc(init_len);
    g_memmove(tlvs->beg, initdata, init_len);
    tlvs->end = tlvs->beg + init_len;
  } 

  return tlvs;
}


void free_tlvstack (TLVstack *tlvs)
{

#ifdef TRACE_FUNCTION
  g_print( "free_tlvstack\n" );
#endif
  
  g_free(tlvs->beg);
  g_free(tlvs);

}

void display_tlv(TLV *tlv)
{

#ifdef TRACE_FUNCTION
  g_print( "display_tlv\n" );
#endif

  g_print ("T: %d L: %d V(w:%d dw:%d): %s\n",
             tlv->type, tlv->len,
             (tlv->len==2) ? CharsBE_2_Word(tlv->value) : 0,
             (tlv->len==4) ? CharsBE_2_DW(tlv->value)   : 0,
             tlv->value);

}

void packet_print_v7 (V7Packet *packet)
{
 
#ifdef TRACE_FUNCTION
  g_print( "packet_print_v7\n" );
#endif

  g_print("Channel: %d Length: %d\n", packet->channel, packet->len);
  if (packet->channel == 2) {
    Snac *snac;

    snac = read_snac(packet);

    packet_print_v7_snac(snac);

    g_free(snac);
  }  else
    print_data(packet->data, packet->len);

}

void packet_print_v7_snac (Snac *snac) 
{

#ifdef TRACE_FUNCTION
  g_print( "packet_print_v7_snac\n" );
#endif

  g_print("Fam:%x Type:%x Flags:%x%x ReqID:%x\n", snac->family, snac->type,
          snac->flags[0], snac->flags[1], snac->reqid);
  
  print_data(snac->data, snac->datalen);

}

void print_data(BYTE *data, guint len)
{
  int cx;
  gchar condensed[17];
  condensed[0] = condensed[16] = 0x00;

  /*  return; */

  g_print("Length: %d\n", len);

  for( cx = 0; cx < len + (cx%16); cx ++ ) {
    if (cx < len) {
      if( isprint( data[cx] ) )
        strncat( condensed, &data[cx], 1 );
      else
        strcat( condensed, "." );
    } else
      strcat (condensed, " ");

    if (cx < len) {
      if( cx % 16 == 4 || cx % 16 == 8 || cx % 16 == 12 )
        g_print( "- " );
      g_print("%02x ", data[cx]);
    } else {
      if( cx % 16 == 4 || cx % 16 == 8 || cx % 16 == 12 )
        g_print( "  " );
      g_print("   ");
    }
    
    if( cx % 16 == 15 ) {
      g_print( "    %s\n", condensed );
      condensed[0] = '\x0';
    }
  }

  g_print("\n"); 
}


gint v7_reqs_compare_func(Request *req, DWORD *reqid)
{

  if (req->reqid == *reqid)
    return 0;
  else
    return 1;
}


