/**********************************
 Handle new account creation
 (c) 1999 Jeremy Wise
 GnomeICU
***********************************/ 

#include "common.h"
#include "gnomeicu.h"
#include "newsignup.h"

/*** Local function declarations ***/
static void NewUserFinish( GtkWidget *widget, gpointer data );
static void NewUserCancel( GtkWidget *widget, gpointer data );
static void NewUser2( GtkWidget *widget, GtkRadioButton *radiobutton );
static void get_password( const gchar *string, gpointer data );
static void get_uin( const gchar *string, gpointer data );

/*** Global functions ***/
void NewUserSignup( void )
{
	GtkWidget *window;
	GtkWidget *mainbox;
	GtkWidget *label;
	GtkWidget *radiobutton;
	GtkWidget *next_button;
	GtkWidget *button;

#ifdef TRACE_FUNCTION
	g_print( "NewUserSignup\n" );
#endif

	window = gnome_dialog_new (_("GnomeICU: New User"),
	                           GNOME_STOCK_BUTTON_NEXT,
				   GNOME_STOCK_BUTTON_CANCEL,
				   NULL);
	gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

	mainbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( GNOME_DIALOG (window)->vbox ), mainbox );
	gtk_widget_show( mainbox );
	
	label = gtk_label_new(_("Welcome to GnomeICU"));
	gtk_box_pack_start( GTK_BOX( mainbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	label = gtk_label_new (_("Before you can use this program, you must\n"
				 "provide some information. You will not need\n"
				 "to do this again, unless you remove your\n"
				 "~/.gnome/GnomeICU file."));
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start (GTK_BOX (mainbox), label, FALSE, FALSE, GNOME_PAD);
	gtk_widget_show (label);

	radiobutton = gtk_radio_button_new (NULL);
	label = gtk_label_new (_("New ICQ # - Select this if you've never used\n"
	                         "ICQ before, or if you don't remember your\n"
	                         "UIN or password."));
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_container_add (GTK_CONTAINER (radiobutton), label);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (mainbox), radiobutton, FALSE, FALSE, 0);
	gtk_widget_show (radiobutton);

	radiobutton = gtk_radio_button_new (gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton)));
	label = gtk_label_new (_("Existing ICQ # - Select this if you already\n"
	                         "have an account which you'd like to use with\n"
	                         "GnomeICU."));
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_container_add (GTK_CONTAINER (radiobutton), label);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (mainbox), radiobutton, FALSE, FALSE, 0);
	gtk_widget_show (radiobutton);

	next_button = g_list_first (GNOME_DIALOG (window)->buttons)->data;
	button = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	
{
	gtk_signal_connect (GTK_OBJECT (next_button), "clicked",
			    GTK_SIGNAL_FUNC (NewUser2), radiobutton);

	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (NewUserCancel), NULL);

	gtk_widget_show (window);

	gtk_main ();
}
}

/*** Local functions ***/
void NewUserFinish( GtkWidget *widget, gpointer data )
{
	static gboolean been_called = FALSE;

#ifdef TRACE_FUNCTION
	g_print( "NewUserFinish\n" );
#endif
	
	if( !been_called )
	  {
		gtk_main_quit();
		been_called = TRUE;
	  }
}

void NewUserCancel( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "NewUserCancel\n" );
#endif

	gtk_main_quit();
	exit(1);
}

void NewUser2( GtkWidget *widget, GtkRadioButton *radiobutton )
{
	GtkWidget *pwdlg;

	gboolean selected;

#ifdef TRACE_FUNCTION
	g_print( "NewUser2\n" );
#endif

	selected = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radiobutton));

	if (selected)
		pwdlg = gnome_request_dialog (FALSE, _("Please enter your UIN"), "",
		                              0, (GnomeStringCallback) get_uin,
		                              NULL, NULL);
	else
		pwdlg = gnome_request_dialog (TRUE, _("Please enter a password\nfor your new account"), "",
		                              8, (GnomeStringCallback) get_password,
		                              NULL, NULL);
	gtk_widget_show (pwdlg);

	if( !selected )
	{
		is_new_user = TRUE;
	}
}

void get_password( const gchar *string, gpointer data )
{
	if( string != NULL && strlen( string ) )
	  passwd = g_strdup( string );
	else
	{
		gtk_main_quit();
		exit(1);
	}

	NewUserFinish(NULL, NULL);
}

void get_uin( const gchar *string, gpointer data )
{
	GtkWidget *pwdlg;

	if( string != NULL && strlen( string ) )
		our_info->uin = atoi( string );
	else
	{
		gtk_main_quit();
		exit(1);
	}

	pwdlg = gnome_request_dialog (TRUE, _("Please enter your password"), "",
	                              8, (GnomeStringCallback)get_password,
	                              NULL, NULL);
}
