import gtk, pango, gobject
from simple_debug import simple_debug

fontsize_to_pixels = {}

w = None
e = None

def get_font_window_and_entry ():
    global w,e
    w = gtk.Window()
    e = gtk.Entry()
    w.add(e)
    e.show()

def get_font_height (font,size=None):
    return int(pango.PIXELS(size) * 1.7)

def get_fontsize_for_y (y,font):
    size = int((y/1.8))*pango.SCALE
    fpixels = get_font_height(font,int(size))
    last = size
    while fpixels < y:
        last = size
        size += 0.5 * pango.SCALE
        fpixels = get_font_height(font,int(size))
    return int(last)


class SuperEntry (gtk.Fixed):

    main_size = 9
    
    def __init__ (self, size=48):
        #gtk.AspectFrame.__init__(self,ratio=1,obey_child=False)
        self.size = size
        gtk.Fixed.__init__(self)
        self.setup_main_entry()
        self.sub_entry = gtk.Entry()
        self.top_entry = gtk.Entry()
        #self.top_entry.set_width_chars(5)
        #self.sub_entry.set_width_chars(5)
        self.main_font = pango.FontDescription()
        self.sub_font = pango.FontDescription()
        self.main_font.set_size(pango.SCALE * self.main_size)
        self.main_entry.modify_font(self.main_font)
        self.sub_font.set_size(int(pango.SCALE * self.main_size*(9.0/16)))
        self.sub_entry.modify_font(self.sub_font)
        self.top_entry.modify_font(self.sub_font)
        self.put(self.top_entry,0,0)
        self.put(self.main_entry,0,0)
        self.put(self.sub_entry,0,0)
        self.set_entry_sizes(size)
        self.main_entry.show(); self.sub_entry.show(); self.top_entry.show()
        #self.vb.pack_start(self.top_entry,expand=False,fill=False); self.top_entry.show()        
        #self.vb.pack_start(self.main_entry,expand=False,fill=False); self.main_entry.show()
        #self.vb.pack_start(self.sub_entry,expand=False,fill=False); self.sub_entry.show()        
        color = gtk.gdk.color_parse('white')
        for e in ['main_entry','sub_entry','top_entry']:
            e = getattr(self,e)
            e.set_has_frame(False)
        #self.connect('size-allocate',self.allocate_cb)

    def set_entry_sizes (self, size):
        self.size = size
        quarter = size / 4
        self.move(self.top_entry,0,0)
        self.move(self.main_entry,0,quarter)
        self.move(self.sub_entry,0,quarter*3)
        self.top_entry.set_property('width-request',size)
        self.sub_entry.set_property('width-request',size)
        self.main_entry.set_property('width-request',size)
        self.top_entry.set_property('height-request',quarter)
        self.sub_entry.set_property('height-request',quarter)
        self.main_entry.set_property('height-request',quarter*2)

    @simple_debug
    def allocate_cb (self, w, allocation):
        side = (allocation.width > allocation.height and allocation.width or allocation.height)
        if hasattr(self,'side') and self.side == side:
            return
        else:
            try:
                self.change_square_size(side=side)
            except AttributeError:
                pass
            else:
                self.side = side

    @simple_debug
    def change_square_size (self, side=48,
                            big_font_size=None,
                            small_font_size=None):
        if not big_font_size:
            big_font_size = get_fontsize_for_y(side/2,self.main_font)
        if not small_font_size:
            small_font_size = get_fontsize_for_y(side/4,self.sub_font)
        self.change_font_size(big_font_size,small_font_size)
        self.set_entry_sizes(side)

    @simple_debug
    def change_font_size (self, big_font_size, small_font_size):
        if big_font_size > 100000: raise "WTF->big font"
        self.sub_font.set_size(small_font_size)
        self.main_font.set_size(big_font_size)
        self.main_entry.modify_font(self.main_font)
        self.sub_entry.modify_font(self.sub_font)
        self.top_entry.modify_font(self.sub_font)

    def do_it_for_all (f):
        name = f.__name__
        def foo (self,*args,**kwargs):
            getattr(self.sub_entry,
                    name)(*args,**kwargs)
            getattr(self.top_entry,
                    name)(*args,**kwargs)
            return getattr(self.main_entry,
                    name)(*args,**kwargs)
        return foo
    
    @do_it_for_all
    def modify_bg (self,*args,**kwargs): pass

    @do_it_for_all
    def modify_fg (self,*args,**kwargs): pass

    @do_it_for_all
    def modify_base (self,*args,**kwargs): pass

    @do_it_for_all
    def set_editable (self,*args,**kwargs): pass

    def modify_font (self, newfont):
        #rect = self.vb.get_allocation()
        if newfont.get_size():
            self.main_font = newfont
            self.sub_font = newfont.copy()
            self.sub_font.set_size(
                int(self.main_font.get_size()*(9.0/16))
                )
            self.sub_entry.modify_font(self.sub_font)
            self.top_entry.modify_font(self.sub_font)
            self.main_entry.modify_font(self.main_font)
        else:
            doer = self.do_it_for_all(self.modify_font)
            return doer(newfont)
        #rect = self.vb.get_allocation()
        #self.vb.set_property('width-request',rect.height)
        #rect = self.vb.get_allocation()
        
    def get_note_text (self):
        return self.top_entry.get_text(),self.sub_entry.get_text()

    def set_note_text (self, top=None, bottom=None):
        if top is not None:
            self.top_entry.set_text(top)
        if bottom is not None:
            self.sub_entry.set_text(bottom)
    
    def setup_main_entry (self):
        self.main_entry = gtk.Entry()
        #self.main_entry.set_width_chars(5)
        self.main_entry.set_alignment(0.5)
        self.main_entry.set_max_length(1)

    def __getattr__ (self, attname):
        # This should raise an attribute error if it fails, which will
        # automatically get us normal behavior
        try:
            return getattr(self,attname)
        except:
            return getattr(self.main_entry,attname)
        #except:
        #    raise

if __name__ == '__main__':
    win = gtk.Window()
    b = gtk.Button('Test Font Size')
    def test_me (*args):
        import time
        fd = pango.FontDescription()
        t = time.time()
        heights = []
        for n in range(9*pango.SCALE,40*pango.SCALE,10):
            heights.append((n,get_font_height(fd,n)))
        print 'Got heights for 30 font sizes in ',time.time()-t,'seconds'
        print
        for s,h in heights: print s,h
        win.hide()
        gtk.main_quit()
    b.connect('clicked',test_me)
    win.add(b)
    win.show_all()
    gtk.main()

elif False:
    w = gtk.Window()
    w.connect('delete-event',lambda *args: gtk.main_quit())
    vb = gtk.VBox()
    l = gtk.Label('Super Entry: '); l.show()
    vb.pack_start(l)
    tb = gtk.Table()
    tb.set_row_spacings(6)
    tb.set_col_spacings(6)
    def foo (*args):
        print args
    for x in range(5):
        for y in range(5):
            se = SuperEntry(); se.show()
            #al = gtk.Alignment()
            #af = gtk.AspectFrame(None,0.5,0.5,1,False)
            se.set_text('4')
            #al.add(se)
            #af.add(al)
            #af.show_all()
            #al.set_property('xscale',0.5); al.set_property('xalign',0.5)
            #al.set_property('yscale',0.5); al.set_property('yalign',0.5)
            #se.connect('changed',foo)
            tb.attach(se,x,x+1,y,y+1)
            if y/3 == 2:
                se.modify_base(gtk.STATE_NORMAL,
                               gtk.gdk.color_parse('#f00')
                               )
                se.modify_fg(gtk.STATE_NORMAL,
                               gtk.gdk.color_parse('#f00')
                               )
                se.modify_bg(gtk.STATE_NORMAL,
                               gtk.gdk.color_parse('#f00')
                               )                
    vb.pack_start(tb); tb.show()
    w.add(vb)
    vb.show()
    w.present()
    gtk.main()
