const Gio = imports.gi.Gio;
const GLib = imports.gi.GLib;
var NautilusFileOperationsProxy;
var FreeDesktopFileManagerProxy;
var GnomeNautilusPreviewerProxy;

const NautilusFileOperationsInterface = `<node>
<interface name='org.gnome.Nautilus.FileOperations'>
    <method name='CopyURIs'>
        <arg name='URIs' type='as' direction='in'/>
        <arg name='Destination' type='s' direction='in'/>
    </method>
    <method name='MoveURIs'>
        <arg name='URIs' type='as' direction='in'/>
        <arg name='Destination' type='s' direction='in'/>
    </method>
    <method name='EmptyTrash'>
    </method>
    <method name='TrashFiles'>
        <arg name='URIs' type='as' direction='in'/>
    </method>
    <method name='CreateFolder'>
        <arg name='URI' type='s' direction='in'/>
    </method>
    <method name='RenameFile'>
        <arg name='URI' type='s' direction='in'/>
        <arg name='NewName' type='s' direction='in'/>
    </method>
    <method name='Undo'>
    </method>
    <method name='Redo'>
    </method>
    <property name='UndoStatus' type='i' access='read'/>
</interface>
</node>`;

const NautilusFileOperationsProxyInterface = Gio.DBusProxy.makeProxyWrapper(NautilusFileOperationsInterface);

const FreeDesktopFileManagerInterface = `<node>
<interface name='org.freedesktop.FileManager1'>
    <method name='ShowItems'>
        <arg name='URIs' type='as' direction='in'/>
        <arg name='StartupId' type='s' direction='in'/>
    </method>
    <method name='ShowItemProperties'>
        <arg name='URIs' type='as' direction='in'/>
        <arg name='StartupId' type='s' direction='in'/>
    </method>
</interface>
</node>`;

const FreeDesktopFileManagerProxyInterface = Gio.DBusProxy.makeProxyWrapper(FreeDesktopFileManagerInterface);

const GnomeNautilusPreviewerInterface = `<node>
<interface name='org.gnome.NautilusPreviewer'>
    <method name='ShowFile'>
        <arg name='FileUri' type='s' direction='in'/>
        <arg name='ParentXid' type='i' direction='in'/>
        <arg name='CloseIfShown' type='b' direction='in'/>
    </method>
</interface>
</node>`;

const GnomeNautilusPreviewerProxyInterface = Gio.DBusProxy.makeProxyWrapper(GnomeNautilusPreviewerInterface);

function init() {
    NautilusFileOperationsProxy = new NautilusFileOperationsProxyInterface(
        Gio.DBus.session,
        'org.gnome.Nautilus',
        '/org/gnome/Nautilus',
        (proxy, error) => {
            if (error) {
                log('Error connecting to Nautilus');
            }
        }
    );

    FreeDesktopFileManagerProxy = new FreeDesktopFileManagerProxyInterface(
        Gio.DBus.session,
        'org.freedesktop.FileManager1',
        '/org/freedesktop/FileManager1',
        (proxy, error) => {
            if (error) {
                log('Error connecting to Nautilus');
            }
        }
    );

    GnomeNautilusPreviewerProxy = new GnomeNautilusPreviewerProxyInterface(
        Gio.DBus.session,
        'org.gnome.NautilusPreviewer',
        '/org/gnome/NautilusPreviewer',
        (proxy, error) => {
            if (error) {
                log('Error connecting to Nautilus Previewer');
            }
        }
    );
}

function openFileWithOtherApplication(filePath) {
    let fdList = new Gio.UnixFDList();
    let channel = GLib.IOChannel.new_file(filePath, "r");
    fdList.append(channel.unix_get_fd());
    channel.set_close_on_unref(true);
    let builder = GLib.VariantBuilder.new(GLib.VariantType.new("a{sv}"));
    let options = builder.end();
    let parameters = GLib.Variant.new_tuple([GLib.Variant.new_string("0"),
                                             GLib.Variant.new_handle(0),
                                             options]);
    Gio.bus_get(Gio.BusType.SESSION, null,
        (source, result) => {
            let dbus_connection = Gio.bus_get_finish(result);
            dbus_connection.call_with_unix_fd_list("org.freedesktop.portal.Desktop",
                                                   "/org/freedesktop/portal/desktop",
                                                   "org.freedesktop.portal.OpenURI",
                                                   "OpenFile",
                                                   parameters,
                                                   GLib.VariantType.new("o"),
                                                   Gio.DBusCallFlags.NONE,
                                                   -1,
                                                   fdList,
                                                   null,
                                                   null);
        }
    );
}
