/* -*- c-file-style: "ruby" -*- */
/************************************************

  rbgtkmain.c -

  $Author: igarashi $
  $Date: 2001/03/02 23:13:34 $

  Copyright (C) 1998-2000 Yukihiro Matsumoto,
                          Daisuke Kanda,
                          Hiroshi Igarashi
************************************************/

#include "global.h"

static VALUE
gtk_m_events_pending(self)
    VALUE self;
{
    return gtk_events_pending() ? Qtrue : Qfalse;
}

static VALUE
gtk_m_main(self)
    VALUE self;
{
    gtk_main();
    return Qnil;
}

static VALUE
gtk_m_main_level(self)
    VALUE self;
{
    return INT2FIX(gtk_main_level());
}

static VALUE
gtk_m_main_quit(self)
    VALUE self;
{
    gtk_main_quit();
    return Qnil;
}

static VALUE
gtk_m_main_iteration(self)
    VALUE self;
{
    return gtk_main_iteration() ? Qtrue : Qfalse;
}

static gboolean
exec_interval(proc)
    VALUE proc;
{
    VALUE ret = rb_funcall(proc, id_call, 0);
    return RGTEST(ret);
}

static VALUE
timeout_add(self, interval)
    VALUE self, interval;
{
    int id;
    VALUE func;

    func = rb_f_lambda();
    add_relative(self, func);
    id = gtk_timeout_add(NUM2INT(interval), (GtkFunction)exec_interval,
			 (gpointer)func);
    return INT2FIX(id);
}

static VALUE
timeout_remove(self, id)
    VALUE self, id;
{
    gtk_timeout_remove(NUM2INT(id));
    return Qnil;
}

static VALUE
idle_add(self)
    VALUE self;
{
    int id;
    VALUE func;

    func = rb_f_lambda();
    add_relative(self, func);
    id = gtk_idle_add((GtkFunction)exec_interval, (gpointer)func);
    return INT2FIX(id);
}

static VALUE
idle_remove(self, id)
    VALUE self, id;
{
    gtk_idle_remove(NUM2INT(id));
    return Qnil;
}

static VALUE
gtk_m_get_current_event(self)
    VALUE self;
{
    return make_gdkevent(gtk_get_current_event());
}

static void
gtkwarn(mesg)
    char *mesg;
{
    rb_funcall(warn_handler, id_call, 1, rb_str_new2(mesg));
}

static void
gtkmesg(mesg)
    char *mesg;
{
    rb_funcall(mesg_handler, id_call, 1, rb_str_new2(mesg));
}

static void
gtkprint(mesg)
    char *mesg;
{
    rb_funcall(print_handler, id_call, 1, rb_str_new2(mesg));
}


static VALUE
set_warning_handler(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE handler;

    rb_scan_args(argc, argv, "01", &handler);
    if (NIL_P(handler)) {
	handler = rb_f_lambda();
    }
    g_set_warning_handler(gtkwarn);
    return handler;
}

static VALUE
set_message_handler(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE handler;

    rb_scan_args(argc, argv, "01", &handler);
    if (NIL_P(handler)) {
	handler = rb_f_lambda();
    }
    g_set_message_handler(gtkmesg);
    return handler;
}

static VALUE
set_print_handler(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE handler;

    rb_scan_args(argc, argv, "01", &handler);
    if (NIL_P(handler)) {
	handler = rb_f_lambda();
    }
    g_set_print_handler(gtkprint);
    return handler;
}

void Init_gtk_main()
{
    rb_define_module_function(mGtk, "events_pending", gtk_m_events_pending, 0);
    rb_define_module_function(mGtk, "main", gtk_m_main, 0);
    rb_define_module_function(mGtk, "main_level", gtk_m_main_level, 0);
    rb_define_module_function(mGtk, "main_quit", gtk_m_main_quit, 0);
    rb_define_module_function(mGtk, "main_iteration", gtk_m_main_iteration, 0);
    rb_define_module_function(mGtk, "timeout_add", timeout_add, 1);
    rb_define_module_function(mGtk, "timeout_remove", timeout_remove, 1);
    rb_define_module_function(mGtk, "idle_add", idle_add, 0);
    rb_define_module_function(mGtk, "idle_remove", idle_remove, 1);
    rb_define_module_function(mGtk, "get_current_event", gtk_m_get_current_event, 0);

    /* currently not work
    rb_define_module_function(mGtk, "set_warning_handler",
			      set_warning_handler, -1);
    rb_define_module_function(mGtk, "set_message_handler",
			      set_message_handler, -1);
    rb_define_module_function(mGtk, "set_print_handler",
			      set_print_handler, -1);
    */
}
