%define ver 1.0.6
%define rel 1

Summary: A tool for determining versions of installed GNOME packages.
Name: gnome-pkgview
Version: %{ver}
Release: %{rel}
License: GPL
Group: Applications/System
Source: http://www.greatnorthern.demon.co.uk/packages/pkgview/gnome-pkgview-%{ver}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
Vendor: Principia Systems
Packager: Mike Newman <mikegtn@gnome.org>

%define prefix /usr
%define sysconfdir /etc

%description
Displays version information for desktop components, and determines the
overall desktop version from the gnome-version.xml file.

%prep
%setup

%build
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} install

%post
GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source` gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/gnome-pkgview.schemas

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS TODO README NEWS ChangeLog
%{prefix}/bin/*
%{_sysconfdir}/gconf/schemas/*
%{prefix}/share/pixmaps/gnome-pkgview/*
%{prefix}/share/applications/*
%{prefix}/share/locale/*/LC_MESSAGES/*.mo
