#include "maillist.h"
#include <stdio.h>
#include <stdlib.h>

@interface Majordomo : MailList
@end

@implementation Majordomo
- (BOOL) sendControlMessage:(id) persona
			   :(const char *) ctlmsg
			   :(const char *) data
{
  FILE *mailout;
  char subj[256];

  g_snprintf(subj, sizeof(subj),
	     "From GNOME mailman for %s <%s>.\n",
	     [persona getFullName],
	     [persona getEmailAddress]);
  mailout = [self sendMail:persona
		  :[self getControlAddress]
		  :subj];
  if(mailout) {
    fprintf(mailout, "%s %s %s\n", ctlmsg,
	    [self getName],
	    data?data:NULL);
    pclose(mailout);
    return TRUE;
  } else
    return FALSE;
}

@end
