/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-info-provider.c
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <config.h>
#include <glib/gi18n.h>
#include <dbus/dbus-glib-lowlevel.h>
#include "gdm-info-provider.h"


static GSList *providers = NULL;

/* Yeah, these are really fugly but they get the job done.... */

#define _CALL(NAME, TYPE)                                                             \
do {                                                                                  \
        GSList *i;                                                                    \
        for (i = providers; i != NULL; i = i->next) {                                 \
                GdmInfoProviderIface *provider = i->data;                             \
                if (provider->get_provider_matches != NULL) {                         \
                        if (provider->get_provider_matches (device)) {                \
                                if (provider->NAME != NULL) {                         \
                                        TYPE val;                                     \
                                        if ((val = provider->NAME (device)) != NULL)  \
                                                return val;                           \
                                }                                                     \
                        }                                                             \
                }                                                                     \
        }                                                                             \
} while (FALSE)

#define _CALL_LIST(NAME, LIST)                                                        \
do {                                                                                  \
        GSList *i;                                                                    \
        for (i = providers; i != NULL; i = i->next) {                                 \
                GdmInfoProviderIface *provider = i->data;                             \
                if (provider->get_provider_matches != NULL) {                         \
                        if (provider->get_provider_matches (device)) {                \
                                if (provider->NAME != NULL) {                         \
                                        GSList *val;                                  \
                                        if ((val = provider->NAME (device)) != NULL)  \
                                                LIST = g_slist_concat (LIST, val);    \
                                }                                                     \
                        }                                                             \
                }                                                                     \
        }                                                                             \
} while (FALSE)

char *
gdm_info_provider_get_icon_name (GdmDevice *device)
{
        _CALL (get_icon_name, char*);
        /* fallback */
        return g_strdup ("stock_unknown");
}

char *
gdm_info_provider_get_short_name (GdmDevice *device)
{
        char *vendor;
        char *product;
        char *name;

        _CALL (get_short_name, char*);

        /* fallback to info.vendor and info.product */
        vendor = gdm_info_provider_get_vendor (device);
        product = gdm_info_provider_get_product (device);
        name = g_strdup_printf ("%s%s%s", 
                                vendor != NULL ? vendor : "",
                                vendor != NULL && product != NULL ? " " : "",
                                product != NULL ? product : "");
        g_free (vendor);
        g_free (product);
        return name;
}

char *
gdm_info_provider_get_long_name (GdmDevice *device)
{
        char *vendor;
        char *product;
        char *name;

        _CALL (get_long_name, char*);

        /* fallback to info.vendor and info.product */
        vendor = gdm_info_provider_get_vendor (device);
        product = gdm_info_provider_get_product (device);
        name = g_strdup_printf ("%s%s%s", 
                                vendor != NULL ? vendor : "",
                                vendor != NULL && product != NULL ? " " : "",
                                product != NULL ? product : "");
        g_free (vendor);
        g_free (product);
        return name;
}

char *
gdm_info_provider_get_vendor (GdmDevice *device)
{
        _CALL (get_vendor, char*);
        /* fallback to info.vendor */
        return g_strdup (gdm_device_get_property_string (device, "info.vendor"));
}

char *
gdm_info_provider_get_product (GdmDevice *device)
{
        _CALL (get_product, char*);
        /* fallback to info.product */
        return g_strdup (gdm_device_get_property_string (device, "info.product"));
}


#define ADD_SUM(p, key, value)                                                       \
        do {                                                                         \
                if (value != NULL) {                                                 \
                        p = g_slist_append (p, g_strdup (key));                      \
                        p = g_slist_append (p, value);                               \
                }                                                                    \
        } while (FALSE)

GSList *
gdm_info_provider_get_summary (GdmDevice *device)
{
        GSList *ret = NULL;

        /* merge from all providers */
        _CALL_LIST (get_summary, ret);

        /* fallback to showing vendor, product, subsystem */
        if (ret == NULL || g_slist_length (ret) == 0) {
                ADD_SUM (ret, _("Model"), gdm_info_provider_get_product (device));
                ADD_SUM (ret, _("Vendor"), gdm_info_provider_get_vendor (device));
                ADD_SUM (ret, _("Subsystem"), g_strdup (gdm_device_get_property_string (device, "info.subsystem")));
        }
        return ret;
}

GSList *
gdm_info_provider_get_errors (GdmDevice *device)
{ 
        GSList *ret = NULL;
        /* merge from all providers */
        _CALL_LIST (get_errors, ret);
        return ret;
}

GSList *
gdm_info_provider_get_warnings (GdmDevice *device)
{
        GSList *ret = NULL;
        /* merge from all providers */
        _CALL_LIST (get_warnings, ret);
        return ret;
}


GSList *
gdm_info_provider_get_notices (GdmDevice *device)
{
        GSList *ret = NULL;
        /* merge from all providers */
        _CALL_LIST (get_notices, ret);
        return ret;
}

void
gdm_info_provider_register_iface (GdmInfoProviderIface *provider)
{
        /* last registered provider "wins" (although for some methods
         * we merge information from all providers) 
         */
        providers = g_slist_prepend (providers, provider);
}


extern GdmInfoProviderIface gdm_info_provider_computer;
extern GdmInfoProviderIface gdm_info_provider_ac_adapter;
extern GdmInfoProviderIface gdm_info_provider_battery;
extern GdmInfoProviderIface gdm_info_provider_pci;
extern GdmInfoProviderIface gdm_info_provider_usb;
extern GdmInfoProviderIface gdm_info_provider_usb_if;
extern GdmInfoProviderIface gdm_info_provider_usb_raw;
extern GdmInfoProviderIface gdm_info_provider_firewire;
extern GdmInfoProviderIface gdm_info_provider_firewire_unit;
extern GdmInfoProviderIface gdm_info_provider_storage;
extern GdmInfoProviderIface gdm_info_provider_volume;
extern GdmInfoProviderIface gdm_info_provider_input;
extern GdmInfoProviderIface gdm_info_provider_button;
extern GdmInfoProviderIface gdm_info_provider_sound;
extern GdmInfoProviderIface gdm_info_provider_pnp;
extern GdmInfoProviderIface gdm_info_provider_platform;

void
gdm_info_provider_register_builtin (void)
{
        gdm_info_provider_register_iface (&gdm_info_provider_computer);
        gdm_info_provider_register_iface (&gdm_info_provider_ac_adapter);
        gdm_info_provider_register_iface (&gdm_info_provider_battery);
        gdm_info_provider_register_iface (&gdm_info_provider_pci);
        gdm_info_provider_register_iface (&gdm_info_provider_usb);
        gdm_info_provider_register_iface (&gdm_info_provider_usb_if);
        gdm_info_provider_register_iface (&gdm_info_provider_usb_raw);
        gdm_info_provider_register_iface (&gdm_info_provider_firewire);
        gdm_info_provider_register_iface (&gdm_info_provider_firewire_unit);
        gdm_info_provider_register_iface (&gdm_info_provider_storage);
        gdm_info_provider_register_iface (&gdm_info_provider_volume);
        gdm_info_provider_register_iface (&gdm_info_provider_input);
        gdm_info_provider_register_iface (&gdm_info_provider_button);
        gdm_info_provider_register_iface (&gdm_info_provider_sound);
        gdm_info_provider_register_iface (&gdm_info_provider_pnp);
        gdm_info_provider_register_iface (&gdm_info_provider_platform);
}


