/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 

#ifdef HAVE_LIBGML
#include <GML.h>
#endif

#include <config.h>
#include <locale.h>
#include "gnome-cmd-includes.h"
#include "gnome-cmd-main-win-funcs.h"
#include "gnome-cmd-data.h"
#include "owner.h"
#include "gnome-cmd-style.h"
#include "gnome-cmd-fam.h"
#include "gnome-cmd-connection-funcs.h"
#include "utils.h"
#include "dir_pool.h"
#include "ls_colors.h"

GnomeCmdMainWin *main_win;
gchar *start_dir;
gchar *debug_flags;

#ifdef HAVE_LOCALE_H
struct lconv *locale_information;
#endif

extern int file_counter;
extern int dir_counter;

static void
my_gnome_init (int argc, char *argv[])
{
	struct poptOption popt_table[] = {
		{"debug", 'd', POPT_ARG_STRING, &debug_flags, 0, _("Specify debug flags to use"), NULL},
		{"startdir", 's', POPT_ARG_STRING, &start_dir, 0, _("Specify the directory to start in"), NULL},
		{NULL, 0, 0, NULL, 0, NULL, NULL}
	};

    gnome_init_with_popt_table ("gnome-commander", VERSION, argc, argv, popt_table, 0, NULL);
}


int
main (int argc, char *argv[])
{
	g_thread_init (NULL);

#ifdef HAVE_LIBGML
	GML_init(9,PACKAGE,FALSE);
#endif
	
#ifdef ENABLE_NLS
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (PACKAGE);
#endif
	
#ifdef HAVE_LOCALE_H
	if(setlocale(LC_ALL, "") == NULL)
		g_warning("Error processing locales, call to setlocale failed.\n");
	locale_information = localeconv();
#endif

	ls_colors_init ();
	my_gnome_init (argc, argv);
	gdk_rgb_init ();
	gnome_vfs_init ();
	gnome_cmd_data_load ();
	IMAGE_init ();
	gnome_cmd_data_load_more ();
#ifdef HAVE_LIBFAM
	if (gnome_cmd_data_get_use_fam())
		fam_init ();
#endif
	
	gnome_cmd_style_create ();
	OWNER_init ();
	dir_pool_init ();

	main_win = GNOME_CMD_MAIN_WIN (gnome_cmd_main_win_new ());

	gtk_widget_show (GTK_WIDGET (main_win));
	
    gtk_main ();

	gnome_cmd_connection_free_all ();
	gnome_cmd_data_save ();
	gnome_vfs_shutdown ();
#ifdef HAVE_LIBFAM	
	fam_shutdown ();
#endif	
	OWNER_free ();
	IMAGE_free ();

	remove_temp_download_dir ();
	
	DEBUG ('c', "dir_counter: %d\n", dir_counter);
	DEBUG ('c', "file_counter: %d\n", file_counter);

#ifdef HAVE_LIBGML
	GML_end();
#endif
	
    return 0;
}

