/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2003 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_DIR_TYPES_H__
#define __GNOME_CMD_DIR_TYPES_H__

#ifdef HAVE_LIBFAM
#include <fam.h>
#endif

BEGIN_GNOME_DECLS

#define GNOME_CMD_DIR(obj) \
	GTK_CHECK_CAST (obj, gnome_cmd_dir_get_type (), GnomeCmdDir)
#define GNOME_CMD_DIR_CLASS(klass) \
	GTK_CHECK_CLASS_CAST (klass, gnome_cmd_dir_get_type (), GnomeCmdDirClass)
#define GNOME_CMD_IS_DIR(obj) \
    GTK_CHECK_TYPE (obj, gnome_cmd_dir_get_type ())


typedef struct _GnomeCmdDir		    GnomeCmdDir;
typedef struct _GnomeCmdDirPrivate	GnomeCmdDirPrivate;
typedef struct _GnomeCmdDirClass	GnomeCmdDirClass;

#include "gnome-cmd-file-types.h"

struct _GnomeCmdDir
{
	GtkObject parent;
	
	gint ref_cnt;
	GList *files;
	GnomeVFSURI *uri;
	gchar *uri_str;
	gchar *path;
	gboolean content_changed;
	gboolean prev_error;
	gboolean not_listed;
	gint voffset;
#ifdef HAVE_LIBFAM
	FAMRequest *request;
#endif
	GnomeCmdDirPrivate *priv;
};


struct _GnomeCmdDirClass
{
	GtkObjectClass parent_class;

	void (* file_created)       (GnomeCmdDir *dir,
								 GnomeCmdFile *file);
	void (* file_deleted)       (GnomeCmdDir *dir,
								 GnomeCmdFile *file);
	void (* file_changed)       (GnomeCmdDir *dir,
								 GnomeCmdFile *file);
	void (* list_updated)       (GnomeCmdDir *dir);
};


#endif // __GNOME_CMD_DIR_TYPES_H__
