/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include <stdio.h>
#include <string.h>
#include "gnome-cmd-includes.h"

#define BUF_SIZE 128


static GnomeDialogClass *parent_class = NULL;


static void
add_row (GnomeCmdCvsUpdateDialog *dialog, char *buf1, char *buf2)
{
	int row;
	char *text[4];
	GdkColor *c = NULL;
	GnomeCmdCvsUpdateColors *colors;

	colors = gnome_cmd_data_get_cvs_update_colors ();
		
	text[0] = buf1;
	text[1] = buf2;
	text[2] = NULL;
	text[3] = NULL;
		
	if (strlen (buf1) > 0)
	{
		switch (buf1[0])
		{
			case 'M':
				c = colors->modified;
				text[2] = "modified by you";
				break;
			case '?':
				c = colors->unknown;
				text[2] = "unknown (not part of the repository)";
				break;
			case 'U':
				c = colors->updated;
				text[2] = "updated";
				break;
			case 'C':
				c = colors->conflict;
				text[2] = "conflict";
				break;
			case 'A':
				c = colors->added;
				text[2] = "scheduled for adding";
				break;
			case 'R':
				c = colors->removed;
				text[2] = "scheduled for removal";
				break;
		}

		row = gtk_clist_append (GTK_CLIST (dialog->file_clist), text);

		if (c)
			gtk_clist_set_foreground (GTK_CLIST (dialog->file_clist), row, c);
	}
}


static void
on_close (GtkButton *button, GnomeCmdCvsUpdateDialog *dialog)
{
	gtk_widget_hide (GTK_WIDGET (dialog));
}


static void
on_update (GtkButton *button, GnomeCmdCvsUpdateDialog *dialog)
{
}


static void
on_add (GtkButton *button, GnomeCmdCvsUpdateDialog *dialog)
{
}


static void
on_commit (GtkButton *button, GnomeCmdCvsUpdateDialog *dialog)
{
}


static void
on_commit_all (GtkButton *button, GnomeCmdCvsUpdateDialog *dialog)
{
}


static void
on_diff (GtkButton *button, GnomeCmdCvsUpdateDialog *dialog)
{
}


static void
on_log (GtkButton *button, GnomeCmdCvsUpdateDialog *update_dialog)
{
}


static void
on_select_row (GtkCList *clist, gint row, gint column,
			   GdkEventButton *event, GnomeCmdCvsUpdateDialog *dialog)
{
	switch (event->type)
	{
		case GDK_BUTTON_RELEASE:
			gtk_clist_get_text (clist, row, 1, &dialog->filename);
			break;
		default:
			break;
	}
}



/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdCvsUpdateDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());
	object_class->destroy = destroy;
	widget_class->map = map;
}


static void
init (GnomeCmdCvsUpdateDialog *dialog_param)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *scrolledwindow1;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *close_button;
	GtkWidget *toolbar2;
	GtkWidget *update_button;
	GtkWidget *pixmap3;
	GtkWidget *add_button;
	GtkWidget *pixmap4;
	GtkWidget *commit_button;
	GtkWidget *pixmap5;
	GtkWidget *commit_all_button;
	GtkWidget *pixmap6;
	GtkWidget *diff_button;
	GtkWidget *pixmap7;
	GtkWidget *log_button;
	GtkWidget *pixmap8;

	dialog = GTK_WIDGET (dialog_param);
	gtk_widget_set_usize (dialog, 400, 400);

	dialog_vbox1 = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_vbox1",
						 dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	
	toolbar2 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_widget_ref (toolbar2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "toolbar2", toolbar2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (toolbar2);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), toolbar2, FALSE, FALSE, 0);

	update_button = gtk_button_new ();
	gtk_widget_ref (update_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "update_button", update_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (update_button);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), update_button, "update", NULL);

	pixmap3 = create_pixmap (dialog, "gnome-commander/menu_cvs_update.xpm", FALSE);
	gtk_widget_ref (pixmap3);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap3", pixmap3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap3);
	gtk_container_add (GTK_CONTAINER (update_button), pixmap3);

	add_button = gtk_button_new ();
	gtk_widget_ref (add_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "add_button", add_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (add_button);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), add_button, "add", NULL);

	pixmap4 = create_pixmap (dialog, "gnome-commander/menu_cvs_add.xpm", FALSE);
	gtk_widget_ref (pixmap4);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap4", pixmap4,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap4);
	gtk_container_add (GTK_CONTAINER (add_button), pixmap4);

	commit_button = gtk_button_new ();
	gtk_widget_ref (commit_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "commit_button", commit_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (commit_button);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), commit_button, "commit", NULL);

	pixmap5 = create_pixmap (dialog, "gnome-commander/menu_cvs_commit.xpm", FALSE);
	gtk_widget_ref (pixmap5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap5", pixmap5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap5);
	gtk_container_add (GTK_CONTAINER (commit_button), pixmap5);

	commit_all_button = gtk_button_new ();
	gtk_widget_ref (commit_all_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "commit_all_button", commit_all_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (commit_all_button);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), commit_all_button, "commit all", NULL);

	pixmap6 = create_pixmap (dialog, "gnome-commander/menu_cvs_commit_all.xpm", FALSE);
	gtk_widget_ref (pixmap6);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap6", pixmap6,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap6);
	gtk_container_add (GTK_CONTAINER (commit_all_button), pixmap6);


	diff_button = gtk_button_new ();
	gtk_widget_ref (diff_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "diff_button", diff_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (diff_button);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), diff_button, "diff", NULL);

	pixmap7 = create_pixmap (dialog, "gnome-commander/menu_cvs_diff.xpm", FALSE);
	gtk_widget_ref (pixmap7);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap7", pixmap7,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap7);
	gtk_container_add (GTK_CONTAINER (diff_button), pixmap7);

	
	log_button = gtk_button_new ();
	gtk_widget_ref (log_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "log_button", log_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (log_button);
	gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar2), log_button, "view log", NULL);

	pixmap8 = create_pixmap (dialog, "gnome-commander/menu_cvs_log.xpm", FALSE);
	gtk_widget_ref (pixmap8);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap8", pixmap8,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap8);
	gtk_container_add (GTK_CONTAINER (log_button), pixmap8);



	
	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "scrolledwindow1",
							  scrolledwindow1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), scrolledwindow1,
						TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
									GTK_POLICY_AUTOMATIC,
									GTK_POLICY_AUTOMATIC);

	dialog_param->file_clist = gtk_clist_new (3);
	gtk_widget_ref (dialog_param->file_clist);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "dialog_param->file_clist",
							  dialog_param->file_clist,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog_param->file_clist);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), dialog_param->file_clist);
	gtk_clist_set_column_width (GTK_CLIST (dialog_param->file_clist), 0, 19);
	gtk_clist_set_column_width (GTK_CLIST (dialog_param->file_clist), 1, 80);
	gtk_clist_column_titles_show (GTK_CLIST (dialog_param->file_clist));

	label1 = gtk_label_new (_("status"));
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label1", label1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_clist_set_column_widget (GTK_CLIST (dialog_param->file_clist), 0, label1);

	label2 = gtk_label_new (_("filename"));
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label2", label2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_clist_set_column_widget (GTK_CLIST (dialog_param->file_clist), 1, label2);

	label3 = gtk_label_new (_("status description"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label3", label3,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_clist_set_column_widget (GTK_CLIST (dialog_param->file_clist), 2, label3);
	
	gnome_dialog_append_button (GNOME_DIALOG (dialog),
								GNOME_STOCK_BUTTON_CLOSE);
	close_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (close_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "close_button",
							  close_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (close_button);
	GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
						GTK_SIGNAL_FUNC (on_close),
						dialog);

	gtk_signal_connect (GTK_OBJECT (update_button), "clicked",
						GTK_SIGNAL_FUNC (on_update),
						dialog);
	gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
						GTK_SIGNAL_FUNC (on_add),
						dialog);
	gtk_signal_connect (GTK_OBJECT (commit_button), "clicked",
						GTK_SIGNAL_FUNC (on_commit),
						dialog);

	gtk_signal_connect (GTK_OBJECT (commit_all_button), "clicked",
						GTK_SIGNAL_FUNC (on_commit_all),
						dialog);
	
	gtk_signal_connect (GTK_OBJECT (diff_button), "clicked",
						GTK_SIGNAL_FUNC (on_diff),
						dialog);
	
	gtk_signal_connect (GTK_OBJECT (log_button), "clicked",
						GTK_SIGNAL_FUNC (on_log),
						dialog);
	
	gtk_signal_connect (GTK_OBJECT (dialog_param->file_clist), "select-row",
						GTK_SIGNAL_FUNC (on_select_row), dialog);

}




/***********************************
 * Public functions
 ***********************************/

GtkType
gnome_cmd_cvs_update_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdCvsUpdateDialog",
			sizeof (GnomeCmdCvsUpdateDialog),
			sizeof (GnomeCmdCvsUpdateDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}


GtkWidget*
gnome_cmd_cvs_update_dialog_new (void)
{
	GnomeCmdCvsUpdateDialog *dialog = gtk_type_new (gnome_cmd_cvs_update_dialog_get_type ());

	return GTK_WIDGET (dialog);
}


void
gnome_cmd_cvs_update_dialog_update (GnomeCmdCvsUpdateDialog *dialog)
{
}


void
gnome_cmd_cvs_update_dialog_parse (GnomeCmdCvsUpdateDialog *dialog, gchar *text)
{
	/*
	gint ret;
	gchar buf[1024], buf2[1024];

	g_printerr ("parsing: %s\n", text);
	
	ret = sscanf (text, "%s %s", buf, buf2);
	if (ret == 2)
		add_row (dialog, buf, buf2);
		*/
}


