/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"



struct _GnomeCmdCvsServerPrivate {	
	gchar *alias;
	gchar *string;
	guint ref_count;
};


GnomeCmdCvsServer*
gnome_cmd_cvs_server_new ()
{
	GnomeCmdCvsServer *server = g_malloc (sizeof (GnomeCmdCvsServer));
	server->priv = g_malloc (sizeof (GnomeCmdCvsServerPrivate));
	server->priv->alias = g_strdup (" ");
	server->priv->string = g_strdup (" ");
	server->priv->ref_count = 0;
	
	return server;
}


GnomeCmdCvsServer*
gnome_cmd_cvs_server_new_with_values     (gchar *alias, gchar *string)
{
	GnomeCmdCvsServer *server = gnome_cmd_cvs_server_new ();

	gnome_cmd_cvs_server_set_alias (server, alias);
	gnome_cmd_cvs_server_set_string (server, string);

	return server;
}


void
gnome_cmd_cvs_server_free                (GnomeCmdCvsServer *server)
{
	if (!server)
	{
		g_warning ("GnomeCmdCvsServer: server != NULL test failed\n");
		return;
	}
	if (!server->priv)
	{
		g_warning ("GnomeCmdCvsServer: server->priv != NULL test failed\n");
		return;
	}

	if (server->priv->ref_count != 0)
		return;

	if (server->priv->alias)
		g_free (server->priv->alias);
	if (server->priv->string)
		g_free (server->priv->string);

	g_free (server);
}


void
gnome_cmd_cvs_server_ref                 (GnomeCmdCvsServer *server)
{
	if (!server)
	{
		g_warning ("GnomeCmdCvsServer: server != NULL test failed\n");
		return;
	}
	if (!server->priv)
	{
		g_warning ("GnomeCmdCvsServer: server->priv != NULL test failed\n");
		return;
	}

	server->priv->ref_count++;
}


void
gnome_cmd_cvs_server_unref               (GnomeCmdCvsServer *server)
{
	if (!server)
	{
		g_warning ("GnomeCmdCvsServer: server != NULL test failed\n");
		return;
	}
	if (!server->priv)
	{
		g_warning ("GnomeCmdCvsServer: server->priv != NULL test failed\n");
		return;
	}
	if (!server->priv->ref_count)
	{
		g_warning ("GnomeCmdCvsServer: Unref when ref-count was already 0");
		return;
	}

	server->priv->ref_count--;
}


void
gnome_cmd_cvs_server_set_alias           (GnomeCmdCvsServer *server,
										  gchar *alias)
{
	if (!server)
	{
		g_warning ("GnomeCmdCvsServer: server != NULL test failed\n");
		return;
	}
	if (!server->priv)
	{
		g_warning ("GnomeCmdCvsServer: server->priv != NULL test failed\n");
		return;
	}
	if (server->priv->ref_count != 0)
	{
		g_warning ("GnomeCmdCvsServer: ref_count == 0 test failed\n");
		return;
	}
	
	if (server->priv->alias)
		g_free (server->priv->alias);
	
	server->priv->alias = g_strdup (alias);
}


void
gnome_cmd_cvs_server_set_string       (GnomeCmdCvsServer *server,
									   gchar *string)
{
	if (!server)
	{
		g_warning ("GnomeCmdCvsServer: server != NULL test failed\n");
		return;
	}
	if (!server->priv)
	{
		g_warning ("GnomeCmdCvsServer: server->priv != NULL test failed\n");
		return;
	}
	if (server->priv->ref_count != 0)
	{
		g_warning ("GnomeCmdCvsServer: ref_count == 0 test failed\n");
		return;
	}
	
	if (server->priv->string)
		g_free (server->priv->string);
	
	server->priv->string = g_strdup (string);
}


gchar*
gnome_cmd_cvs_server_get_alias           (GnomeCmdCvsServer *server)
{
	if (!server)
	{
		g_warning ("GnomeCmdCvsServer: server != NULL test failed\n");
		return NULL;
	}
	if (!server->priv)
	{
		g_warning ("GnomeCmdCvsServer: server->priv != NULL test failed\n");
		return NULL;
	}

	return server->priv->alias;
}


gchar*
gnome_cmd_cvs_server_get_string       (GnomeCmdCvsServer *server)
{
	if (!server)
	{
		g_warning ("GnomeCmdCvsServer: server != NULL test failed\n");
		return NULL;
	}
	if (!server->priv)
	{
		g_warning ("GnomeCmdCvsServer: server->priv != NULL test failed\n");
		return NULL;
	}

	return server->priv->string;
}


