/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"
#include "gnome-cmd-cvs-log-dialog.h"

struct _GnomeCmdCvsLogDialogPrivate
{
	GtkWidget *text;
};


static GnomeDialogClass *parent_class = NULL;


static void
on_close (GtkButton *btn,
		  GtkWidget *dialog)
{
	gtk_widget_hide (dialog);
}


static void
add_text (GnomeCmdCvsLogDialog *dialog, gchar *text, int len, int *pos)
{
	gtk_editable_insert_text (GTK_EDITABLE (dialog->priv->text), text, len, pos);
}




/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	GnomeCmdCvsLogDialog *dialog = GNOME_CMD_CVS_LOG_DIALOG (object);

	g_free (dialog->priv);
	
	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}


static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdCvsLogDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());
	object_class->destroy = destroy;
	widget_class->map = map;
}


static void
init (GnomeCmdCvsLogDialog *log_dialog)
{
	GtkWidget *dialog = GTK_WIDGET (log_dialog);
	GtkWidget *dialog_vbox2;
	GtkWidget *scrolledwindow2;
	GtkWidget *dialog_action_area2;
	GtkWidget *close_button;

	log_dialog->priv = g_new (GnomeCmdCvsLogDialogPrivate, 1);

	gtk_window_set_policy (GTK_WINDOW (dialog),
						   TRUE, TRUE, FALSE);
	gtk_widget_set_usize (dialog, 400,400);

	dialog_vbox2 = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_vbox2",
						 dialog_vbox2);
	gtk_widget_show (dialog_vbox2);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "scrolledwindow2",
							  scrolledwindow2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow2);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), scrolledwindow2,
						TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2),
									GTK_POLICY_AUTOMATIC,
									GTK_POLICY_AUTOMATIC);

	log_dialog->priv->text = gtk_text_new (NULL, NULL);
	gtk_widget_ref (log_dialog->priv->text);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "text1", log_dialog->priv->text,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (log_dialog->priv->text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), log_dialog->priv->text);

	dialog_action_area2 = GNOME_DIALOG (dialog)->action_area;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_action_area2",
						 dialog_action_area2);
	gtk_widget_show (dialog_action_area2);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2),
							   GTK_BUTTONBOX_SPREAD);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area2), 8);

	gnome_dialog_append_button (GNOME_DIALOG (dialog),
								GNOME_STOCK_BUTTON_CLOSE);
	close_button = g_list_last (GNOME_DIALOG (dialog)->buttons)->data;
	gtk_widget_ref (close_button);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "close_button",
							  close_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (close_button);
	GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
						GTK_SIGNAL_FUNC (on_close),
						dialog);
}




/***********************************
 * Public functions
 ***********************************/

GtkWidget*
gnome_cmd_cvs_log_dialog_new (void)
{	
	GnomeCmdCvsLogDialog *dialog = gtk_type_new (gnome_cmd_cvs_log_dialog_get_type ());

	return GTK_WIDGET (dialog);
}



GtkType
gnome_cmd_cvs_log_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdCvsLogDialog",
			sizeof (GnomeCmdCvsLogDialog),
			sizeof (GnomeCmdCvsLogDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}


void
gnome_cmd_cvs_log_dialog_log_file (GnomeCmdCvsLogDialog *dialog, gchar *dir, gchar *filename)
{
	int pos = 0;
	int ret;
	char buf[128];
	FILE *fd;
	char cmd[1024];

	sprintf (cmd, "cvs log %s", filename);
	chdir (dir);
	fd = popen (cmd, "r");

	do
	{
		ret = fread (buf, 1, 128, fd);
		if (ret > 0)
			add_text (dialog, buf, ret, &pos);
	} while (ret > 0);

	pclose (fd);
}
