/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

static GnomeDialogClass *parent_class = NULL;



static void
append_file (GnomeCmdCvsCommitDialog *dialog, gchar *file)
{
	gchar *text[2];

	text[0] = file;
	text[1] = NULL;

	gtk_clist_append (GTK_CLIST (dialog->file_clist), text);
						  
}


static void
on_ok (GtkButton *button, GnomeCmdCvsCommitDialog *dialog)
{
	gchar *command;
		
	if (dialog->file)
		command = g_strdup_printf (
			"cvs commit -m \"%s\" %s ",
			gtk_editable_get_chars (GTK_EDITABLE (dialog->message), 0, -1),
			dialog->file);
	else
		command = g_strdup_printf (
			"cvs commit -m \"%s\"",
			gtk_editable_get_chars (GTK_EDITABLE (dialog->message), 0, -1));
				

	g_print ("system (\"%s\")", command);
	system (command);

	g_free (command);

	gnome_cmd_cvs_update_dialog_update (dialog->update_dialog);

	gtk_widget_hide (GTK_WIDGET (dialog));
}


static void
on_cancel (GtkButton *button, GtkWidget *dialog)
{
	gtk_widget_hide (dialog);
}





/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdCvsCommitDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());
	object_class->destroy = destroy;
	widget_class->map = map;
}


static void
init (GnomeCmdCvsCommitDialog *dialog_param)
{	
	GtkWidget *dialog;
	GtkWidget *dialog_vbox2;
	GtkWidget *hbox2;
	GtkWidget *pixmap2;
	GtkWidget *table1;
	GtkWidget *scrolledwindow1;
	GtkWidget *label5;
	GtkWidget *label6;
	GtkWidget *scrolledwindow2;
	GtkWidget *label7;
	GtkWidget *button7;
	GtkWidget *button9;

	dialog = GTK_WIDGET (dialog_param);

	dialog_vbox2 = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog), "dialog_vbox2", dialog_vbox2);
	gtk_widget_show (dialog_vbox2);

	hbox2 = gtk_hbox_new (FALSE, 8);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "hbox2", hbox2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (dialog_vbox2), hbox2, TRUE, TRUE, 0);

	pixmap2 = create_pixmap (dialog, "gnome-commander/cvs_fish.xpm", FALSE);
	gtk_widget_ref (pixmap2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "pixmap2", pixmap2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap2);
	gtk_box_pack_start (GTK_BOX (hbox2), pixmap2, TRUE, TRUE, 0);

	table1 = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "table1", table1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (hbox2), table1, TRUE, TRUE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "scrolledwindow1", scrolledwindow1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_table_attach (GTK_TABLE (table1), scrolledwindow1, 1, 2, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
									GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	dialog_param->message = gtk_text_new (NULL, NULL);
	gtk_widget_ref (dialog_param->message);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "dialog_param->message", dialog_param->message,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog_param->message);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), dialog_param->message);
	gtk_text_set_editable (GTK_TEXT (dialog_param->message), TRUE);

	label5 = gtk_label_new (_("message  "));
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label5", label5,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 1, 2,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.5);

	label6 = gtk_label_new (_("Files to commit "));
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label6", label6,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label6), 0, 0.5);

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow2);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "scrolledwindow2", scrolledwindow2,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow2);
	gtk_table_attach (GTK_TABLE (table1), scrolledwindow2, 1, 2, 0, 1,
					  (GtkAttachOptions) (GTK_FILL),
					  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2),
									GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	dialog_param->file_clist = gtk_clist_new (1);
	gtk_widget_ref (dialog_param->file_clist);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "dialog_param->file_clist", dialog_param->file_clist,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog_param->file_clist);
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), dialog_param->file_clist);
	gtk_clist_set_column_width (GTK_CLIST (dialog_param->file_clist), 0, 80);
	gtk_clist_column_titles_hide (GTK_CLIST (dialog_param->file_clist));

	label7 = gtk_label_new ("label7");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "label7", label7,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_clist_set_column_widget (GTK_CLIST (dialog_param->file_clist), 0, label7);

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_OK);
	button7 = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog)->buttons)->data);
	gtk_widget_ref (button7);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "button7", button7,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button7);
	GTK_WIDGET_SET_FLAGS (button7, GTK_CAN_DEFAULT);

	gnome_dialog_append_button (GNOME_DIALOG (dialog), GNOME_STOCK_BUTTON_CANCEL);
	button9 = GTK_WIDGET (g_list_last (GNOME_DIALOG (dialog)->buttons)->data);
	gtk_widget_ref (button9);
	gtk_object_set_data_full (GTK_OBJECT (dialog), "button9", button9,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button9);
	GTK_WIDGET_SET_FLAGS (button9, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (button7), "clicked",
						GTK_SIGNAL_FUNC (on_ok), dialog);
	gtk_signal_connect (GTK_OBJECT (button9), "clicked",
						GTK_SIGNAL_FUNC (on_cancel), dialog);
}




/***********************************
 * Public functions
 ***********************************/

GtkType
gnome_cmd_cvs_commit_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdCvsCommitDialog",
			sizeof (GnomeCmdCvsCommitDialog),
			sizeof (GnomeCmdCvsCommitDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}


GtkWidget*
gnome_cmd_cvs_commit_dialog_new (GnomeCmdCvsUpdateDialog *update_dialog, gchar *file)
{
	GnomeCmdCvsCommitDialog *dialog = gtk_type_new (gnome_cmd_cvs_commit_dialog_get_type ());

	if (file)
		append_file (dialog, file);
	else
		append_file (dialog, "all");

	dialog->file = file;
	dialog->update_dialog = update_dialog;
	
	return GTK_WIDGET (dialog);
}
