/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __CVS_SESSION_H__
#define __CVS_SESSION_H__

typedef void (* CvsOutputCallback) (gpointer data, gchar *text);

void
cvs_session_set_password (gchar *pw);

gchar *
cvs_session_get_password (void);

void cvs_session_setdir    (gchar *dir);
void cvs_session_setroot   (gchar *cvsroot);

void cvs_session_login     (void);
void cvs_session_logout    (void);
void cvs_session_log       (gchar *file, CvsOutputCallback func, gpointer data);
void cvs_session_diff      (gchar *file, CvsOutputCallback func, gpointer data);
void cvs_session_add       (GList *files);
void cvs_session_remove    (GList *files);
void cvs_session_commit    (GList *files, gchar *comment,
							CvsOutputCallback func, gpointer data);
void cvs_session_update    (GList *files, CvsOutputCallback func, gpointer data);
void cvs_session_import    (gchar *modulename, gchar *vendor, gchar *comment,
							CvsOutputCallback func, gpointer data);
void cvs_session_checkout  (gchar *modulename, CvsOutputCallback func, gpointer data);


#endif //__CVS_SESSION_H__
