/* 
 * Copyright (C) 2000 JP Rosevear
 * Copyright (C) 2001 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <gnome.h>
#include <glade/glade.h>
#include "dialogs.h"
#include "../pgn.h"

#define GLADE_FILE "pgn.glade"

static void
dialog_pgn_impl (GladeXML *gui, Pgn_Tag *tag)
{
	GtkWidget *dialog;
	GtkWidget *event,*site,*date,*round;
	GtkWidget *white,*black,*result;

	if (tag)
	  {
	    event = glade_xml_get_widget (gui, "event_entry");
	    site = glade_xml_get_widget (gui, "site_entry");
	    date = glade_xml_get_widget (gui, "date_entry");
	    round = glade_xml_get_widget (gui, "round_entry");
	    white = glade_xml_get_widget (gui, "white_entry");
	    black = glade_xml_get_widget (gui, "black_entry");
	    result = glade_xml_get_widget (gui, "result_entry");
	
	    gtk_entry_set_text(GTK_ENTRY(event), tag->event);
	    gtk_entry_set_text(GTK_ENTRY(site), tag->site);
	    gtk_entry_set_text(GTK_ENTRY(date), tag->date);
	    gtk_entry_set_text(GTK_ENTRY(round), tag->round);
	    gtk_entry_set_text(GTK_ENTRY(white), tag->white);
	    gtk_entry_set_text(GTK_ENTRY(black), tag->black);
	    gtk_entry_set_text(GTK_ENTRY(result), tag->result);
	  }

	dialog = glade_xml_get_widget (gui, "dialog");
		
	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);

	gtk_widget_show_all (GNOME_DIALOG (dialog)->vbox);

	gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

	return;
}

void
dialog_pgn( Pgn_Tag *tag  )
{
	GladeXML *gui;
	
	gui = glade_xml_new (GNOMECHESS_GLADEDIR "/" GLADE_FILE , NULL);
	if (!gui) {
		printf ("Could not find " GLADE_FILE "\n");
		return;
	}

	dialog_pgn_impl (gui, tag);
	gtk_object_unref (GTK_OBJECT (gui));

	return;
}

