/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt options dialog
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2002-2004 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#include "drawtree.h"
#include "pkgtree.h"
#include "preferences.h"

enum { C_ID, C_NAME, C_POS, N_COLS };

Preferences::Preferences (void) : pkglist_ (0), tree (0) { }
Preferences::~Preferences (void) { }

void
Preferences::go_up (void) {
	GtkTreeIter iter;
	GtkTreeSelection* sel = gtk_tree_view_get_selection (GTK_TREE_VIEW (tree));
	GtkTreeModel* cols = gtk_tree_view_get_model (GTK_TREE_VIEW (tree));
	if (!gtk_tree_selection_get_selected (sel, &cols, &iter)) {
		return;
	}

	apply();
	GtkTreePath* path = gtk_tree_model_get_path (cols, &iter);
	if (!gtk_tree_path_prev (path)) {
		return;
	}

	GtkTreeIter to;
	gtk_tree_model_get_iter (cols, &to, path);
	gtk_list_store_swap (GTK_LIST_STORE (cols), &iter, &to);
	apply();
}

void
Preferences::go_down (void) {
	GtkTreeIter iter;
	GtkTreeSelection* sel = gtk_tree_view_get_selection (GTK_TREE_VIEW (tree));
	GtkTreeModel* cols = gtk_tree_view_get_model (GTK_TREE_VIEW (tree));
	if (!gtk_tree_selection_get_selected (sel, &cols, &iter)) {
		return;
	}

	apply();
	GtkTreeIter to = iter;
	if (!gtk_tree_model_iter_next (cols, &to)) {
		return;
	}
	gtk_list_store_swap (GTK_LIST_STORE (cols), &iter, &to);
	apply();
}

static void
go_up_cb (GtkWidget* btn, gpointer data) {
	Preferences* p = static_cast<Preferences*> (data);
	p->go_up();
}

static void
go_down_cb (GtkWidget* btn, gpointer data) {
	Preferences* p = static_cast<Preferences*> (data);
	p->go_down();
}

void 
Preferences::edit()
{
  g_return_if_fail(pkglist_ != 0);

	GtkWidget* dlg = gtk_dialog_new_with_buttons (_("Software Manager Preferences"),
	      NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);
	gtk_dialog_set_has_separator (GTK_DIALOG (dlg), FALSE);
	gnome_apt_setup_dialog (dlg);
	g_signal_connect (G_OBJECT (dlg), "close", G_CALLBACK (close_cb), this);
	g_signal_connect (G_OBJECT (dlg), "response", G_CALLBACK (response_cb), this);

	GtkWidget* frame = gtk_frame_new (_("Column order"));
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);
	GtkWidget* vbox = gtk_vbox_new (FALSE, GAPT_PAD);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), GAPT_PAD);  
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  
	GtkListStore* cols = gtk_list_store_new (N_COLS, G_TYPE_INT, G_TYPE_STRING, G_TYPE_INT);
	GtkTreeIter it;
	for (int i = 0; i < DrawTree::ColumnTypeEnd; ++i) {
		DrawTree::ColumnType ct = static_cast<DrawTree::ColumnType> (i);
		gushort ord = pkglist_->getView()->type_column (ct);
		gtk_list_store_append (cols, &it);
		gtk_list_store_set (cols, &it, C_ID, i, C_NAME, DrawTree::get_column_name (ct, false), C_POS, ord, -1);
	}
	gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE (cols), C_POS, GTK_SORT_ASCENDING);
	GTK_LIST_STORE (cols)->sort_column_id = -2;

	tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (cols));
	gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (tree), FALSE);
	GtkTreeSelection* sel = gtk_tree_view_get_selection (GTK_TREE_VIEW (tree));
	gtk_tree_selection_set_mode (sel, GTK_SELECTION_SINGLE);

	GtkCellRenderer* cell = gtk_cell_renderer_text_new();
	GtkTreeViewColumn* col = gtk_tree_view_column_new_with_attributes ("Foo", cell, "text", C_NAME, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (tree), col);
	gtk_box_pack_start (GTK_BOX (vbox), tree, TRUE, TRUE, 0);

	GtkWidget* btn = gtk_button_new_from_stock (GTK_STOCK_GO_UP);
	gtk_box_pack_start (GTK_BOX (vbox), btn, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (btn), "clicked", G_CALLBACK (go_up_cb), this);

	btn = gtk_button_new_from_stock (GTK_STOCK_GO_DOWN);
	gtk_box_pack_start (GTK_BOX (vbox), btn, FALSE, FALSE, 0);
	g_signal_connect (G_OBJECT (btn), "clicked", G_CALLBACK (go_down_cb), this);

	vbox = gtk_vbox_new (FALSE, GAPT_PAD);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), GAPT_PAD);

	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dlg)->vbox), vbox);
	gtk_widget_show_all (dlg);
}

void
Preferences::response_cb (GtkWidget* wdg, gint response, gpointer data) {
	if (response == GTK_RESPONSE_CLOSE || response == GTK_RESPONSE_DELETE_EVENT) {
		gtk_widget_destroy (wdg);
	} else {
		g_warning ("Got response: %d", response);
	}
}

static void
get_order (GtkTreeModel* cols, vector<gint>& order) {
	GtkTreeIter iter;
	gboolean loop = gtk_tree_model_get_iter_first (cols, &iter);

	while (loop) {
		gint id, ord;
		gtk_tree_model_get (cols, &iter, C_ID, &id, -1);
		order.push_back (id);
		loop = gtk_tree_model_iter_next (cols, &iter);
	}
}

void
Preferences::apply (void) {
	vector<gint> order;
	get_order (gtk_tree_view_get_model (GTK_TREE_VIEW (tree)), order);

	int c = 0;
	vector<DrawTree::ColumnType> column_order (DrawTree::ColumnTypeEnd);
	vector<gint>::iterator i = order.begin();
	while (i != order.end()) {
		DrawTree::ColumnType ct = static_cast<DrawTree::ColumnType> (*i);
		column_order[c] = ct;
		++i; ++c;
	}

	pkglist_->getView()->set_column_order (column_order);
}

gint 
Preferences::close_cb (GtkWidget* w, gpointer data)
{
  Preferences* p = static_cast<Preferences*>(data);

  p->close();

  return FALSE;
}

void
Preferences::close (void) {
	if (tree) {
		gtk_widget_destroy (tree);
		tree = 0;
	}
}

static Preferences* preferences = 0;

Preferences*
gnome_apt_preferences()
{
  if (preferences == 0)
    preferences = new Preferences;

  return preferences;
}

void         
gnome_apt_preferences_shutdown()
{
  if (preferences != 0)
    delete preferences;

  preferences = 0;
}
