/*
 * dvdreview.c - gnews plugin for dvdreview.com
 * Copyright 2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include        <gmodule.h>
#include        "config.h"
#include        "../include/gnewslib.h"

#define NAME "dvdreview"
#define CATEGORY "news"
#define URL "http://www.dvdreview.com/rss/newschannel.rss"
#define TITLEBG 0x000000;
#define TITLEFG 0xFFFF83;
#define DESCBG 0x000000;
#define DESCFG 0xFFCEB4;

gchar *last_title = NULL;

G_MODULE_EXPORT gchar *
gnews_plugin_get_name (void)
{
  return (g_strdup (NAME));
}

G_MODULE_EXPORT gchar *
gnews_plugin_get_category (void)
{
  return (g_strdup (CATEGORY));
}

G_MODULE_EXPORT gchar *
gnews_plugin_get_url (void)
{
  return (g_strdup (URL));
}

static void
correct_fields (gpointer data, gpointer user_data)
{
  rdfitem *rdf;

  rdf = data;
  if (rdf->description != NULL) {
    g_free (rdf->description);
  }
  rdf->description = rdf->title;
  rdf->title = g_strdup (NAME);
}

G_MODULE_EXPORT sitedata *
gnews_plugin_get_headlines (void)
{
  sitedata *sd;
  GSList *last;
  rdfitem *lastitem;
  gchar *content;

  sd = g_malloc (sizeof (sitedata));
  content = http_get_url (URL);
  sd->headlines = gnews_parse_rss (content);
  g_free (content);
  sd->has_new = FALSE;
  if (sd->headlines != NULL) {
    last = g_slist_last (sd->headlines);
    lastitem = last->data;
    if (last_title != NULL) {
      if (strcmp (lastitem->title, last_title) != 0) {
	sd->has_new = TRUE;
	g_free (last_title);
	last_title = g_strdup (lastitem->title);
      }
    } else {
      last_title = g_strdup (lastitem->title);
    }
  }

  g_slist_foreach (sd->headlines, correct_fields, NULL);
  sd->name = g_strdup (NAME);
  sd->titlebg = TITLEBG;
  sd->titlefg = TITLEFG;
  sd->descriptionbg = DESCBG;
  sd->descriptionfg = DESCFG;

  return (sd);
}
