/*
 * html.c - libgnews html strip functions
 * Copyright 2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "../include/gnewslib.h"

gboolean hash_initialised = FALSE;
GHashTable *basehash;
GHashTable *accenthash;

void
init_hash (void)
{
    basehash=g_hash_table_new(g_str_hash,g_str_equal);
    g_hash_table_insert(basehash,"amp","&");
    g_hash_table_insert(basehash,"nbsp"," ");
    g_hash_table_insert(basehash,"quot","\"");
    g_hash_table_insert(basehash,"gt",">");
    g_hash_table_insert(basehash,"lt","<");

    accenthash=g_hash_table_new(g_str_hash,g_str_equal);
    g_hash_table_insert(accenthash,"acute","");
    g_hash_table_insert(accenthash,"grave","");
    g_hash_table_insert(accenthash,"circ","");
    g_hash_table_insert(accenthash,"ring","");
    g_hash_table_insert(accenthash,"tilde","");
    g_hash_table_insert(accenthash,"uml","");
    g_hash_table_insert(accenthash,"cedil","");
    g_hash_table_insert(accenthash,"slash","");
    hash_initialised = TRUE;
}

gchar *
decode_html (gchar *s)
{
    gchar *ret, *tmp, *cval, *tmp2, *tmp3;
    gchar **items1, **items2;
    gint i;

    if (!hash_initialised) {
	init_hash();
    }

    items1=g_strsplit(s,"&",0);
    i=0;
    ret=g_strdup("");
    while (items1[i]!=NULL){
	items2=g_strsplit(items1[i],";",1);
	if (items2[0]!=NULL){
	    if (index(items1[i],';')==NULL){
		tmp=ret;
		ret=g_strconcat(tmp,i==0?"":"&",items2[0],NULL);
		g_free(tmp);
	    } else {
		cval=g_hash_table_lookup(basehash,items2[0]);
		if (cval!=NULL){
		    tmp=ret;
		    ret=g_strconcat(tmp,cval,NULL);
		    g_free(tmp);
		}else{
		    tmp2=g_strndup(items2[0],1);
		    tmp3=g_malloc(strlen(items2[0]));
		    tmp3=strcpy(tmp3,items2[0]+1);
		    cval=g_hash_table_lookup(accenthash,tmp3);
		    if (cval!=NULL){
			tmp=ret;
			ret=g_strconcat(tmp,tmp2,NULL);
			g_free(tmp);
		    }
		}
	    }
	}
	if (items2[1]!=NULL){
	    tmp=ret;
	    ret=g_strconcat(tmp,items2[1],NULL);
	    g_free(tmp);
	}
	g_strfreev(items2);
	i++;
    }
    g_strfreev(items1);
    return (ret);    
}

gchar *
strip_tags (gchar *s)
{
    gchar *ret, *tmp;
    gchar **items1, **items2;

    gint i;
    items1=g_strsplit(s,"<",0);
    i=0;
    ret=g_strdup("");
    if (items1[0]!=NULL){
	if (items1[1]==NULL){
	    g_free(ret);
	    ret=g_strdup(s);
	}else{
	    while (items1[i]!=NULL){
		items2=g_strsplit(items1[i],">",1);
		if (items2[1]!=NULL){
		    tmp=ret;
		    ret=g_strconcat(tmp,items2[1],NULL);
	    	    g_free(tmp);
		}
		g_strfreev(items2);
		i++;
	    }
	}
    }
    g_strfreev(items1);
    return (ret);    
}
