/*
 * gnews.c - gnews applet main source
 * Copyright 2000-2002, Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <config.h>
#include <applet-widget.h>
#include <libgnomeui/gnome-window-icon.h>
#include <string.h>
#include <ghttp.h>
#include <sys/timeb.h>
#include <pthread.h>
#include <gnome-xml/parser.h>
#include "gnews.h"
#include "../include/gnewslib.h"
#include "properties.h"
#include "plugins.h"

#define DEF_WIDTH 240
#define DEF_MAX_FRAME 4
#define DEF_SCROLLTIME 100
#define DEF_REFRESH 15
#define WARN_SOUND "generic.wav"
#define DEF_EDGEWAIT 15
#define DEF_MIN_EDGEWAIT 0
#define DEF_MAX_EDGEWAIT 60
#define DEF_SCROLLTYPE 2
#define DEF_MIN_SCROLLTYPE 1
#define DEF_MAX_SCROLLTYPE 2
#define JUMPTO_DIR "jumpto/"

/* global widgets */
GtkWidget *applet, *frame, *vp, *mainhbox, *mainsw, *mainfixed, *metaheadline, *tmphbox, **morehboxes = NULL;
GtkTooltips *tooltips;


gint timer = 0, timeru = 0;
gfloat where = 0;
gint firstwidth;
gint mulneeded;
gint dir = 1;

gint leftbtn = 0;
gint border = 4;
gint jumper = -1;
gfloat savex;
FILE *f;
gchar id[6], t[32], h[32], li[102], sz[202];
gchar id2[6], t2[102];
gint refreshneeded = 0;
gint edgewaitremain = 0;
gboolean sound_needed;

gint config_width;
gint config_scrolltimeout;
gint config_refreshtimeout;
gint config_frametype;
gboolean config_show_titles;
gboolean config_show_hints;
gboolean config_play_sound;
gboolean config_separator_pixmap;
gboolean config_separator_own;
gboolean config_unique_colors;
gboolean config_use_proxy;
gint config_scrolltype;
gint config_edgewait = 0;
gchar *config_proxy_url;
gchar *config_proxy_user;
gchar *config_proxy_passwd;
gchar *config_requestednews;

static gchar **requestedlist;
gint requesteddb;

GSList *jumptos = NULL;
GSList *plugins;
GSList *news;

gint headlines_max = 0;
gint dummy0 = 0, dummy1 = 1;


/*
 * compare function for get_plugin_by_name
 */

static gint
plugin_compare (gconstpointer a, gconstpointer b)
{
  const gchar *name;
  const plugindef *pd;

  pd = a;
  name = b;

  return (strcmp (name, g_basename (g_module_name (pd->module))));
}


/*
 * find a plugin by its filename
 */

static plugindef *
get_plugin_by_name (GSList * pluginlist, char *name)
{
  GSList *foundsite;
  plugindef *pd = NULL;

  foundsite = g_slist_find_custom (pluginlist, name, (GCompareFunc) plugin_compare);

  if (foundsite != NULL) {
    pd = foundsite->data;
  }
  return (pd);
}


/*
 * toggle the scrolling direction
 */

static void
toggle_dir (AppletWidget * applet, gpointer data)
{
  dir *= -1;
  applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					 "toggledirection",
					 (dir ==
					  1 ? GNOME_STOCK_MENU_FORWARD :
					  GNOME_STOCK_MENU_BACK), _("Toggle direction"), toggle_dir, NULL);
}


/*
 * this makes the headlines scroll
 */

static void
move (gpointer data)
{
  GtkAdjustment *ha;
  gint i;

  if (!isemptystr (config_requestednews)) {
    if (leftbtn == 0) {
      ha = gtk_viewport_get_hadjustment (GTK_VIEWPORT (vp));
      if (jumper > -1) {
	gtk_adjustment_set_value (ha, jumper);
	jumper = -1;
      } else {
	if (dir > 0) {		/* scrolling left */
	  if (ha->value + dir <= ha->upper - config_width + border) {
	    gtk_adjustment_set_value (ha, ha->value + dir);
	  } else {
	    if (config_scrolltype == 2) {
	      if (edgewaitremain > 0) {
		edgewaitremain--;
	      } else {
		edgewaitremain = config_edgewait;
		dir *= -1;
		applet_widget_register_stock_callback (APPLET_WIDGET
						       (applet),
						       "toggledirection",
						       (dir ==
							1 ?
							GNOME_STOCK_MENU_FORWARD
							:
							GNOME_STOCK_MENU_BACK),
						       _("Toggle direction"), toggle_dir, NULL);
	      }
	    } else {
	      tmphbox = morehboxes[0];
	      for (i = 0; i < mulneeded - 1; i++) {
		morehboxes[i] = morehboxes[i + 1];
	      }
	      morehboxes[mulneeded - 1] = tmphbox;
	      gtk_box_reorder_child (GTK_BOX (mainhbox), morehboxes[mulneeded - 1], mulneeded - 1);
	      gtk_adjustment_set_value (ha, ha->value - firstwidth);
	    }
	  }
	} else {		/* scrolling right */
	  if (ha->value + dir > 0) {
	    gtk_adjustment_set_value (ha, ha->value + dir);
	  } else {
	    if (config_scrolltype == 2) {
	      if (edgewaitremain > 0) {
		edgewaitremain--;
	      } else {
		edgewaitremain = config_edgewait;
		dir *= -1;
		applet_widget_register_stock_callback (APPLET_WIDGET
						       (applet),
						       "toggledirection",
						       (dir ==
							1 ?
							GNOME_STOCK_MENU_FORWARD
							:
							GNOME_STOCK_MENU_BACK),
						       _("Toggle direction"), toggle_dir, NULL);
	      }
	    } else {
	      tmphbox = morehboxes[mulneeded - 1];
	      for (i = 0; i < mulneeded - 1; i++) {
		morehboxes[i + 1] = morehboxes[i];
	      }
	      morehboxes[0] = tmphbox;
	      gtk_box_reorder_child (GTK_BOX (mainhbox), morehboxes[0], 0);
	      gtk_adjustment_set_value (ha, ha->value + firstwidth);
	    }
	  }
	}
      }
      //    gtk_adjustment_set_value (ha, ha->value);
      gtk_viewport_set_hadjustment (GTK_VIEWPORT (vp), ha);
    }
  }
}


/*
 * mouse button pressed on the headlines
 */

static gboolean
button_press (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
{
  gchar *url;

  if (event->type == GDK_2BUTTON_PRESS) {
    if (event->button == 1) {
      url = gtk_object_get_data (GTK_OBJECT (widget), "url");
      if (url != NULL) {
	gnome_url_show (url);
      }
    }
  } else {
    if (event->button == 1) {
      leftbtn = 1;
      savex = event->x;
      if (timer != 0) {
        gtk_timeout_remove (timer);
        timer = 0;
      }
    } else {
      leftbtn = 0;
    }
  }
  return (FALSE);
}


/*
 * mouse button released on the headlines
 */

static gboolean
button_release (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
{

  leftbtn = 0;
  if (timer == 0) {
    timer = gtk_timeout_add (config_scrolltimeout, (GtkFunction) move, NULL);
  }
  return (FALSE);
}


/*
 * mouse movement on the headlines
 */

static gboolean
motion_notify (GtkWidget * widget, GdkEventMotion * event, gpointer user_data)
{
  GtkAdjustment *ha;
  gint difx;


  if (leftbtn == 1) {
    ha = gtk_viewport_get_hadjustment (GTK_VIEWPORT (vp));
    difx = savex - event->x;
    if (difx != 0) {
      if (difx > 0) {
	if (ha->value + difx <= ha->upper - config_width + border) {
	  gtk_adjustment_set_value (ha, ha->value + difx);
	} else {
	  gtk_adjustment_set_value (ha, ha->upper - config_width + border);
	}
	dir = 1;
	applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					       "toggledirection",
					       (dir ==
						1 ?
						GNOME_STOCK_MENU_FORWARD
						:
						GNOME_STOCK_MENU_BACK),
					       _("Toggle direction"), toggle_dir, NULL);
      } else if (difx < 0) {
	if (ha->value + difx > 0) {
	  gtk_adjustment_set_value (ha, ha->value + difx);
	} else {
	  gtk_adjustment_set_value (ha, 0);
	}
	dir = -1;
	applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					       "toggledirection",
					       (dir ==
						1 ?
						GNOME_STOCK_MENU_FORWARD
						:
						GNOME_STOCK_MENU_BACK),
					       _("Toggle direction"), toggle_dir, NULL);
      }
      savex = event->x + difx;
      gtk_adjustment_set_value (ha, ha->value);
      gtk_viewport_set_hadjustment (GTK_VIEWPORT (vp), ha);
    }
  }
  return (FALSE);
}


/*
 * destroy the information headline
 */

static void
destroymetaheadline (void)
{
  gtk_container_remove (GTK_CONTAINER (vp), metaheadline);
//  gtk_widget_destroy(metaheadline);
  metaheadline = NULL;
}


/*
 * creates an information headline
 */

static void
createmetaheadline (gchar * title)
{
  if (metaheadline == NULL) {
    metaheadline = gtk_label_new (title);
    gtk_widget_show (metaheadline);
    gtk_container_add (GTK_CONTAINER (vp), metaheadline);
  } else {
    gtk_label_set_text (GTK_LABEL (metaheadline), title);
  }
}


/*
 * create a GtkStyle object from fontname and background and foreground colors
 */

static GtkStyle *
make_style (gchar * font, gint b, gint f)
{
  GtkStyle *style;
  gint i;

  style = gtk_style_new ();
  if (font != NULL) {
    style->font = gdk_font_load (font);
  }
  for (i = 0; i < 5; i++) {
    style->bg[i].red = getnumfield (b, 2);
    style->bg[i].green = getnumfield (b, 1);
    style->bg[i].blue = getnumfield (b, 0);
    style->fg[i].red = getnumfield (f, 2);
    style->fg[i].green = getnumfield (f, 1);
    style->fg[i].blue = getnumfield (f, 0);
  }
  return (style);
}


/*
 * create one headline item
 */

static GtkWidget *
createnewsitem (gchar * title, gchar * hint, gchar * link, gchar * szoveg,
		GtkStyle * st1, GtkStyle * st2, gboolean showline)
{
  GtkWidget *tit;
  GtkWidget *eb, *ebb;
  GtkWidget *text;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *vline;
  GtkWidget *lineeventbox;
  GtkWidget *linelabel;
  gchar *ujszoveg;

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);

  if (showline) {
/*    vline = gtk_vseparator_new ();
    gtk_widget_show (vline);
    gtk_widget_set_usize (GTK_WIDGET (vline), 2, 48 - border);
    gtk_box_pack_start (GTK_BOX (hbox), vline, FALSE, TRUE, 0);

    gtk_signal_connect (GTK_OBJECT (vline), "button_press_event", GTK_SIGNAL_FUNC (button_press), NULL);
    gtk_signal_connect (GTK_OBJECT (vline), "button_release_event", GTK_SIGNAL_FUNC (button_release), NULL);
    gtk_signal_connect (GTK_OBJECT (vline), "motion_notify_event", GTK_SIGNAL_FUNC (motion_notify), NULL);*/
    lineeventbox = gtk_event_box_new ();
    gtk_widget_show (lineeventbox);
    gtk_box_pack_start (GTK_BOX (hbox), lineeventbox, FALSE, TRUE, 0);
    gtk_widget_set_style (GTK_WIDGET (lineeventbox), st1);
    linelabel = gtk_label_new (NULL);
    gtk_widget_show (linelabel);
    gtk_container_add (GTK_CONTAINER (lineeventbox), linelabel);
    gtk_widget_set_usize (linelabel, 1, -2);
  }

  vbox = gtk_vbox_new (FALSE, 0);

  gtk_widget_show (vbox);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);

  if (config_show_titles || (!isemptystr (title))) {
    ujszoveg =
      wrapstring (szoveg,
		  (strlen ((isemptystr (title)) ? hint : title) >
		   strlen (szoveg) / 3) ? (strlen ((isemptystr (title)) ? hint : title))
		  : (strlen (szoveg) / 3), "\n", 0);

    eb = gtk_event_box_new ();
    gtk_object_set_data (GTK_OBJECT (eb), "url", link);
    gtk_widget_show (eb);
    gtk_box_pack_start (GTK_BOX (vbox), eb, FALSE, FALSE, 0);
    gtk_widget_set_style (GTK_WIDGET (eb), st1);
    tit = gtk_label_new ((isemptystr (title)) ? hint : title);
    gtk_widget_set_style (GTK_WIDGET (tit), st1);
    gtk_widget_show (tit);
    gtk_label_set_justify (GTK_LABEL (tit), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (tit), 0.01, 0.5);
    gtk_container_add (GTK_CONTAINER (eb), tit);
    if (config_show_hints) {
      gtk_tooltips_set_tip (tooltips, eb, hint, NULL);
    }

    gtk_signal_connect (GTK_OBJECT (eb), "button_press_event", GTK_SIGNAL_FUNC (button_press), NULL);
    gtk_signal_connect (GTK_OBJECT (eb), "button_release_event", GTK_SIGNAL_FUNC (button_release), NULL);
    gtk_signal_connect (GTK_OBJECT (eb), "motion_notify_event", GTK_SIGNAL_FUNC (motion_notify), NULL);
  } else {
    ujszoveg = wrapstring (szoveg, strlen (szoveg) / 4, "\n", 0);
  }

  ebb = gtk_event_box_new ();
  gtk_object_set_data (GTK_OBJECT (ebb), "url", link);
  gtk_widget_show (ebb);
  gtk_box_pack_start (GTK_BOX (vbox), ebb, TRUE, TRUE, 0);
  gtk_widget_set_style (GTK_WIDGET (ebb), st2);
  text = gtk_label_new (ujszoveg);
  gtk_widget_set_style (GTK_WIDGET (text), st2);
  gtk_widget_show (text);
  gtk_label_set_justify (GTK_LABEL (text), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (text), TRUE);
  gtk_misc_set_alignment (GTK_MISC (text), 0.01, 0.01);
  gtk_misc_set_padding (GTK_MISC (text), 1, 1);
  gtk_container_add (GTK_CONTAINER (ebb), text);
  if (config_show_hints) {
    gtk_tooltips_set_tip (tooltips, ebb, hint, NULL);
  }

  gtk_signal_connect (GTK_OBJECT (ebb), "button_press_event", GTK_SIGNAL_FUNC (button_press), NULL);
  gtk_signal_connect (GTK_OBJECT (ebb), "button_release_event", GTK_SIGNAL_FUNC (button_release), NULL);
  gtk_signal_connect (GTK_OBJECT (ebb), "motion_notify_event", GTK_SIGNAL_FUNC (motion_notify), NULL);

  g_free (ujszoveg);

  return (hbox);
}


/*
 * play the gnome warning sound or beep if cannot play sound
 */

static void
playsound (void)
{
  gchar *sfile;

  sfile = gnome_sound_file (WARN_SOUND);
  if (sfile != NULL) {
    gnome_sound_play (sfile);
    g_free (sfile);
  } else {
    gdk_beep ();
  }
}


/*
 * creates a rounded site separator
 */

static GtkWidget *
createseparator (gint type, GtkStyle * st)
{
  GtkWidget *align, *eb, *sep;
  gchar *pixname = NULL;

  switch (type) {
  case 1:
    pixname = gnome_pixmap_file ("gnews/separator1.png");
    break;
  case 2:
    pixname = gnome_pixmap_file ("gnews/separator2.png");
    break;
  }
  eb = gtk_event_box_new ();
  gtk_widget_show (eb);
  gtk_widget_set_style (GTK_WIDGET (eb), st);
  align = gtk_alignment_new (0, 0, 0, 0);
  gtk_widget_show (align);
  gtk_container_add (GTK_CONTAINER (eb), align);
  sep = gtk_type_new (gnome_pixmap_get_type ());
  gnome_pixmap_load_file (GNOME_PIXMAP (sep), pixname);
  gtk_widget_show (sep);
  gtk_container_add (GTK_CONTAINER (align), sep);
  g_free (pixname);

  gtk_signal_connect (GTK_OBJECT (eb), "button_press_event", GTK_SIGNAL_FUNC (button_press), NULL);
  gtk_signal_connect (GTK_OBJECT (eb), "button_release_event", GTK_SIGNAL_FUNC (button_release), NULL);
  gtk_signal_connect (GTK_OBJECT (eb), "motion_notify_event", GTK_SIGNAL_FUNC (motion_notify), NULL);

  return (eb);
}


/*
 * creates a separator of a white line
 */

static GtkWidget *
createwhiteseparator ()
{
  GtkWidget *align, *sep;
  gchar *pixname;

  pixname = gnome_pixmap_file ("gnews/separator.png");
  align = gtk_alignment_new (0, 0, 0, 0);
  gtk_widget_show (align);
  sep = gtk_type_new (gnome_pixmap_get_type ());
  gnome_pixmap_load_file (GNOME_PIXMAP (sep), pixname);
  gtk_widget_show (sep);
  gtk_container_add (GTK_CONTAINER (align), sep);
  g_free (pixname);

  gtk_signal_connect (GTK_OBJECT (sep), "button_press_event", GTK_SIGNAL_FUNC (button_press), NULL);
  gtk_signal_connect (GTK_OBJECT (sep), "button_release_event", GTK_SIGNAL_FUNC (button_release), NULL);
  gtk_signal_connect (GTK_OBJECT (sep), "motion_notify_event", GTK_SIGNAL_FUNC (motion_notify), NULL);

  return (align);
}


/*
 * jump to a specific site
 */

static void
jump (AppletWidget * applet, gpointer data)
{
  jumptodata *jto;

  jto = data;
  jumper = jto->pos;
}


/*
 * add a site to the jump menu
 */

static void
addtojumpmenu (gchar * title, gint pos)
{
  jumptodata *jto;

  jto = g_malloc (sizeof (jumptodata));

  jto->id = g_malloc (7 + strlen (title) + 1);
  sprintf (jto->id, "jumpto/%s", title);

  jto->pos = pos;

  applet_widget_register_callback (APPLET_WIDGET (applet), jto->id, title, jump, jto);
  jumptos = g_slist_append (jumptos, jto);
}


/*
 * clear the jump menu
 */

static void
jumptos_free_each (gpointer data, gpointer user_data)
{
  jumptodata *jto;

  jto = data;
  applet_widget_unregister_callback (APPLET_WIDGET (applet), jto->id);
  g_free (jto->id);
  g_free (jto);
}


/*
 * create each headlines
 */

static void
create_headlines (gpointer data, gpointer user_data)
{
  rdfitem *hl;
  gboolean showline = FALSE;
  headlineinfo *hi;

  hl = data;
  hi = user_data;

  /* this is not the first headline in a site or we don't use pixmap separators */
  if ((hi->number > 0) || (!config_separator_pixmap)) {
    showline = TRUE;
  }

  gtk_box_pack_start (GTK_BOX (tmphbox),
		      createnewsitem (hl->title, hi->name, hl->link,
				      hl->description, hi->st1, hi->st2, showline), FALSE, FALSE, 0);
  hi->number++;

}


/*
 * create a site
 */

static void
create_sites (gpointer data, gpointer user_data)
{
  gint *menu;
  sitedata *sd;
  headlineinfo hi;
  GtkAdjustment *ha;

  sd = data;
  menu = user_data;

  hi.name = sd->name;
  hi.number = 0;

  if (sd->has_new) {
    sound_needed = TRUE;
  }

  if (config_unique_colors) {
    hi.st1 = make_style (_("5x8"), sd->titlebg, sd->titlefg);
    hi.st2 = make_style (_("6x10"), sd->descriptionbg, sd->descriptionfg);
  } else {
    hi.st1 = make_style (_("5x8"), 0x000000, 0xFFFFFF);
    hi.st2 = make_style (_("6x10"), 0xFFFFFF, 0x000000);
  }

  if (*menu == 1) {
    gtk_container_check_resize (GTK_CONTAINER (mainsw));
    ha = gtk_viewport_get_hadjustment (GTK_VIEWPORT (vp));
    addtojumpmenu (sd->name, ha->upper);
  }
  if (config_separator_pixmap) {
    gtk_box_pack_start (GTK_BOX (tmphbox), createwhiteseparator (), FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (tmphbox), createseparator (1, hi.st1), FALSE, FALSE, 0);
  }

  /* create the headlines of the site */
  g_slist_foreach (sd->headlines, create_headlines, &hi);

  if (config_separator_pixmap) {
    gtk_box_pack_start (GTK_BOX (tmphbox), createseparator (2, hi.st1), FALSE, FALSE, 0);
  }
}

static void
createnews (GSList * sitelist)
{
  gfloat onewidth;
  GtkAdjustment *ha;
  gint i;

  mainfixed = gtk_fixed_new ();
  gtk_widget_show (mainfixed);
  gtk_container_add (GTK_CONTAINER (vp), mainfixed);

  mainhbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (mainhbox);
  gtk_fixed_put (GTK_FIXED (mainfixed), mainhbox, 0, 0);
  gtk_widget_set_uposition (mainhbox, 0, 0);

  tmphbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (tmphbox);
  gtk_box_pack_start (GTK_BOX (mainhbox), tmphbox, FALSE, FALSE, 0);

  if (jumptos != NULL) {
    g_slist_foreach (jumptos, jumptos_free_each, NULL);
    g_slist_free (jumptos);
    jumptos = NULL;
  }

  /* walk through the sites */
  g_slist_foreach (sitelist, create_sites, &dummy1);

  /* continous scroll stuff */
  if (config_scrolltype == 1) {

    if (morehboxes != NULL) {
      g_free (morehboxes);
      morehboxes = NULL;
    }

    gtk_container_check_resize (GTK_CONTAINER (mainsw));
    ha = gtk_viewport_get_hadjustment (GTK_VIEWPORT (vp));
    onewidth = ha->upper;
    firstwidth = onewidth;
    mulneeded = config_width / onewidth;
    mulneeded += (mulneeded == 0 ? 2 : 1);

    if (mulneeded > 1) {
      morehboxes = g_malloc (sizeof (GtkWidget) * mulneeded);
      morehboxes[0] = tmphbox;
    }
    for (i = 1; i <= mulneeded; i++) {

      morehboxes[i] = gtk_hbox_new (FALSE, 0);
      gtk_widget_show (morehboxes[i]);
      gtk_box_pack_start (GTK_BOX (mainhbox), morehboxes[i], FALSE, FALSE, 0);
      tmphbox = morehboxes[i];

      g_slist_foreach (sitelist, create_sites, &dummy0);
    }
  }

  if (sound_needed && config_play_sound) {
    playsound ();
    sound_needed = FALSE;
  }

  timer = gtk_timeout_add (config_scrolltimeout, (GtkFunction) move, NULL);
}

/*
 * clear headlines
 */

static void
headlines_free (gpointer data, gpointer user_data)
{
  rdfitem *rdf;

  rdf = data;
  g_free (rdf->title);
  g_free (rdf->link);
  g_free (rdf->description);
  g_free (rdf);
}

static void
sites_free (gpointer data, gpointer user_data)
{
  sitedata *sd;

  sd = data;
  g_slist_foreach (sd->headlines, headlines_free, NULL);
  g_slist_free (sd->headlines);
  g_free (sd->name);
  g_free (sd);
}

static void
news_free ()
{
  g_slist_foreach (news, sites_free, NULL);
  g_slist_free (news);
  news = NULL;
}

static void
destroynews (void)
{
/*  gtk_container_remove (GTK_CONTAINER (vp), mainfixed);*/
  if (mainfixed != NULL) {
    gtk_widget_destroy (mainfixed);
    mainfixed = NULL;
    news_free ();
  }
}

/*
 * fetch headlines from a plugin
 */

static void
get_headlines_each (gpointer data, gpointer user_data)
{
  sitedata *site;
  plugindef *pd;

  pd = data;

  site = pd->get_headlines ();
  news = g_slist_append (news, site);
}

/*
 * fetch headlines from plugins
 */

static void
createnewslist (GSList * plugs)
{
  g_slist_foreach (plugs, get_headlines_each, NULL);
}

static void
createrequestedlist (gchar * rl)
{
  gint i, db;

  if ((rl != NULL) && (rl[0] != 0)) {
    g_strfreev (requestedlist);
    requestedlist = NULL;
    db = 0;
    if (!isemptystr (rl)) {
      for (i = 0; i < strlen (rl); i++) {
	if (rl[i] == '/') {
	  db++;
	}
      }
      db++;
      requestedlist = g_strsplit (rl, "/", db);
    }
    requesteddb = db;
  }
}

static void
about (AppletWidget * applet, gpointer data)
{
  static const char *authors[] = { "Krisztian Pifko <monsta@users.sourceforge.net>", NULL };
  static GtkWidget *about_box = NULL;

  if (about_box != NULL) {
    gdk_window_show (about_box->window);
    gdk_window_raise (about_box->window);
    return;
  }
  about_box =
    gnome_about_new (_("gnews applet"), VERSION, _("Copyright (C) 2000-2002 Krisztian Pifko"),
		     authors,
		     _
		     ("A scrolling news ticker applet for the gnome panel.\nVisit http://gnews.sourceforge.net for more information.\nReleased under GNU General Public Licence."),
		     NULL);

  gtk_signal_connect (GTK_OBJECT (about_box), "destroy", GTK_SIGNAL_FUNC (gtk_widget_destroyed), &about_box);
  gtk_widget_show (about_box);
  applet = NULL;
  data = NULL;
  return;
}

static void
help_cb (AppletWidget * applet, gpointer data)
{
  GnomeHelpMenuEntry help_entry = { "gnews_applet", "index.html" };
  gnome_help_display (NULL, &help_entry);
}

static void
destroybaseframes ()
{
  if (mainsw != NULL) {
    gtk_widget_destroy (GTK_WIDGET (mainsw));
    mainsw = NULL;
  }
}

static void
createbaseframes ()
{
  if (mainsw == NULL) {
    mainsw = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (mainsw);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (mainsw), GTK_POLICY_NEVER, GTK_POLICY_NEVER);
    gtk_container_add (GTK_CONTAINER (frame), mainsw);

    vp = gtk_viewport_new (NULL, NULL);
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (vp), GTK_SHADOW_NONE);
    gtk_widget_show (vp);
    gtk_container_add (GTK_CONTAINER (mainsw), vp);
  }
}

static void
refresh_news (AppletWidget * applet, gpointer data)
{
  if (timer != 0) {
    gtk_timeout_remove (timer);
    timer = 0;
  }
  dir = 1;
  if (metaheadline != NULL) {
    destroymetaheadline ();
  } else {
    destroynews ();
  }

  destroybaseframes ();
  createbaseframes ();

  if (!isemptystr (config_requestednews)) {
    createmetaheadline ("updating...");
    createnewslist (plugins);
    destroymetaheadline ();
    if (news == NULL) {
      createmetaheadline ("update failed...");
    } else {
      createnews (news);
      dir = 1;
      applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					     "toggledirection",
					     (dir == 1 ? GNOME_STOCK_MENU_FORWARD : GNOME_STOCK_MENU_BACK),
					     _("Toggle direction"), toggle_dir, NULL);
    }
  } else {
    createmetaheadline ("no site is selected...");
  }
}

static void
refresh (gpointer data)
{
  refresh_news (APPLET_WIDGET (applet), data);
}


/*
 * session save signal handler
 */

static gint
applet_save_session (GtkWidget * w, const char *privcfgpath, const char *globcfgpath)
{
  gnome_config_push_prefix (APPLET_WIDGET (applet)->privcfgpath);

  gnome_config_set_int ("gnews/width", config_width);
  gnome_config_set_int ("gnews/frametype", config_frametype);
  gnome_config_set_int ("gnews/scrolltimeout", config_scrolltimeout);
  gnome_config_set_int ("gnews/refreshtimeout", config_refreshtimeout);
  gnome_config_set_string ("gnews/requestedplugins", config_requestednews);
  gnome_config_set_bool ("gnews/titles", config_show_titles);
  gnome_config_set_bool ("gnews/hints", config_show_hints);
  gnome_config_set_bool ("gnews/sound", config_play_sound);
  gnome_config_set_bool ("gnews/seppixmap", config_separator_pixmap);
  gnome_config_set_bool ("gnews/sepown", config_separator_own);
  gnome_config_set_bool ("gnews/colors", config_unique_colors);
  gnome_config_set_bool ("gnews/proxy", config_use_proxy);
  gnome_config_set_string ("gnews/proxy_url", config_proxy_url);
  gnome_config_set_string ("gnews/proxy_user", config_proxy_user);
  gnome_config_set_string ("gnews/proxy_passwd", config_proxy_passwd);
  gnome_config_set_int ("gnews/edgewait", config_edgewait);
  gnome_config_set_int ("gnews/scrolltype", config_scrolltype);

  gnome_config_pop_prefix ();
  gnome_config_sync ();
  gnome_config_drop_all ();

  return (FALSE);
}

static void
fillrequestedlist (void)
{
  gint i, appended;
  plugindef *pd;
  gchar *name;

  if (requestedlist != NULL) {
    gtk_clist_freeze (GTK_CLIST (prop_news_clist_selected));
    gtk_clist_clear (GTK_CLIST (prop_news_clist_selected));

    for (i = 0; (requestedlist[i] != NULL) && (i < requesteddb); i++) {
      pd = get_plugin_by_name (plugins, requestedlist[i]);
      if (pd != NULL) {
	name = pd->get_name ();
	appended = gtk_clist_append (GTK_CLIST (prop_news_clist_selected), &name);
	gtk_clist_set_row_data (GTK_CLIST (prop_news_clist_selected), appended, pd);
      }
    }
    gtk_clist_thaw (GTK_CLIST (prop_news_clist_selected));
  }
}

static void
property_apply_cb (GtkWidget * widget, void *data)
{
  gint i;
  gchar *idstr;
  plugindef *pd;

  /* recreate the list of requested sites */
  g_free (config_requestednews);
  config_requestednews = g_strdup ("");
  for (i = 0; i < requesteddb; i++) {
    pd = gtk_clist_get_row_data (GTK_CLIST (prop_news_clist_selected), i);
    idstr = g_strdup (g_basename (g_module_name (pd->module)));
    config_requestednews = g_strconcat (config_requestednews, idstr, "/", NULL);
    g_free (idstr);
  }
  if (config_requestednews[strlen (config_requestednews) - 1] == '/') {
    config_requestednews[strlen (config_requestednews) - 1] = 0;
  }

  /* generate list of requested sites */
  createrequestedlist (config_requestednews);

  /* fill the clist with the requested items */
  fillrequestedlist ();

  g_free (config_proxy_url);
  config_proxy_url = g_strdup (gtk_entry_get_text (GTK_ENTRY (prop_http_entry_proxyurl)));
  g_free (config_proxy_user);
  config_proxy_user = g_strdup (gtk_entry_get_text (GTK_ENTRY (prop_http_entry_proxyuser)));
  g_free (config_proxy_passwd);
  config_proxy_passwd = g_strdup (gtk_entry_get_text (GTK_ENTRY (prop_http_entry_proxypasswd)));

  set_http_options (config_use_proxy, config_proxy_url, config_proxy_user, config_proxy_passwd);

  config_width = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (prop_lay_spin_width));
  gtk_widget_set_usize (frame, config_width, 48);

  gtk_frame_set_shadow_type (GTK_FRAME (frame), config_frametype);

  /* reset scroll timer */
  config_scrolltimeout = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (prop_lay_spin_scroll));

/*  if (timer != 0) {
    gtk_timeout_remove (timer);
    timer = 0;
  }
  timer = gtk_timeout_add (config_scrolltimeout, (GtkFunction) move, NULL);*/

  config_refreshtimeout = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (prop_lay_spin_upd));

  config_edgewait = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (prop_beha_scroll_spin));
  edgewaitremain = config_edgewait;

  config_scrolltype = (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (prop_beha_scroll_radio1)) ? 1 : 2);

  /* reset refresh timer */
  if (timeru != 0) {
    gtk_timeout_remove (timeru);
    timeru = 0;
  }
  timeru = gtk_timeout_add (config_refreshtimeout * 60 * 1000, (GtkFunction) refresh, NULL);

//  applet_widget_sync_config(APPLET_WIDGET(applet));
  applet_save_session (NULL, NULL, NULL);
}

static void
phelp_cb (GtkWidget * w, gint tab, gpointer data)
{
  GnomeHelpMenuEntry help_entry = { "gnews_applet", "index.html#GNEWSAPPLET-PREFS" };
  gnome_help_display (NULL, &help_entry);
}

static gint
property_destroy_cb (GtkWidget * widget, void *data)
{
  propwindow = NULL;
  unload_plugins (plugins);
  plugins = load_some_plugins (requestedlist);

  timer = gtk_timeout_add (config_scrolltimeout, (GtkFunction) move, NULL);

  if (refreshneeded == 1) {
    refresh_news (APPLET_WIDGET (applet), NULL);
    refreshneeded = 0;
  }
  return FALSE;
}

static gint
compfunc (gconstpointer a, gconstpointer b)
{
  const ctreedata *ctd;
  const gchar *categ;

  ctd = a;
  categ = b;

  return (strcmp (categ, ctd->name));
}

static void
siteslist_foreach_tree (gpointer data, gpointer user_data)
{
  plugindef *pd;
  GtkWidget *ctree;
  GtkCTreeNode *node, *parent;
  gchar *categ, *name;
  ctreedata *ctd;

  pd = data;
  ctree = user_data;

  categ = pd->get_category ();
  name = pd->get_name ();
  parent = gtk_ctree_find_by_row_data_custom (GTK_CTREE (ctree), NULL, categ, compfunc);
  if (parent == NULL) {
    parent =
      gtk_ctree_insert_node (GTK_CTREE (ctree), NULL, NULL, &categ, 0, NULL, NULL, NULL, NULL, FALSE, FALSE);

    ctd = g_malloc (sizeof (ctreedata));
    ctd->name = categ;
    ctd->data = NULL;
    gtk_ctree_node_set_row_data (GTK_CTREE (ctree), parent, ctd);
  } else {
    g_free (categ);
  }
  node =
    gtk_ctree_insert_node (GTK_CTREE (ctree), parent, NULL, &name, 0, NULL, NULL, NULL, NULL, FALSE, FALSE);
  ctd = g_malloc (sizeof (ctreedata));
  ctd->name = name;
  ctd->data = pd;
  gtk_ctree_node_set_row_data (GTK_CTREE (ctree), node, ctd);
}

static void
fillavailable (GtkWidget * ctree)
{

  if (plugins != NULL) {
    gtk_clist_freeze (GTK_CLIST (ctree));
    gtk_clist_clear (GTK_CLIST (ctree));

    g_slist_foreach (plugins, siteslist_foreach_tree, (gpointer) ctree);

    gtk_ctree_sort_recursive (GTK_CTREE (ctree), NULL);
    gtk_clist_thaw (GTK_CLIST (ctree));
  }
}

static void
open_properties (AppletWidget * applet, gpointer data)
{

  if (propwindow) {
    gdk_window_raise (propwindow->window);
    return;
  }

  if (timer != 0) {
    gtk_timeout_remove (timer);
    timer = 0;
  }
  dir = 1;

  propwindow = gnome_property_box_new ();
  gtk_window_set_title (GTK_WINDOW (&GNOME_PROPERTY_BOX (propwindow)->dialog.window), _("Gnews Settings"));

  properties_layout_create ();
  properties_behaviour_create ();
  properties_http_create ();

  properties_news_create ();

  unload_plugins (plugins);
  plugins = load_all_plugins ();

  fillavailable (prop_news_ctree_available);

  createrequestedlist (config_requestednews);

  fillrequestedlist ();

  gtk_signal_connect (GTK_OBJECT (propwindow), "apply", GTK_SIGNAL_FUNC (property_apply_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (propwindow), "destroy", GTK_SIGNAL_FUNC (property_destroy_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (propwindow), "help", GTK_SIGNAL_FUNC (phelp_cb), NULL);
  gtk_widget_show_all (propwindow);
}


/* 
 * this is when the panel orientation changes
 */

static void
applet_change_orient (GtkWidget * w, PanelOrientType o, gpointer data)
{
  gint ww = 0;

  switch (o) {
  case ORIENT_UP:
  case ORIENT_DOWN:
    ww = config_width;
    break;
  case ORIENT_LEFT:
  case ORIENT_RIGHT:
    ww = 48;
    break;
  }
  gtk_widget_set_usize (frame, ww, 48);
}

#ifdef HAVE_PANEL_PIXEL_SIZE

/*
static void
applet_change_pixel_size(GtkWidget *w, int size, gpointer data)
{
}
*/

#endif


int
main (int argc, char **argv)
{
  /* Initialize the i18n stuff */
/*  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);*/

  applet_widget_init ("gnews_applet", NULL, argc, argv, NULL, 0, NULL);

  applet = applet_widget_new ("gnews_applet");
  if (!applet)
    g_error ("Can't create applet!\n");

  /* read config */
  gnome_config_push_prefix (APPLET_WIDGET (applet)->privcfgpath);

  config_width = gnome_config_get_int ("gnews/width");
  if (config_width == 0)
    config_width = DEF_WIDTH;

  config_frametype = gnome_config_get_int ("gnews/frametype");
  if (config_frametype > DEF_MAX_FRAME)
    config_frametype = DEF_MAX_FRAME;

  config_scrolltimeout = gnome_config_get_int ("gnews/scrolltimeout");
  if (config_scrolltimeout == 0)
    config_scrolltimeout = DEF_SCROLLTIME;

  config_refreshtimeout = gnome_config_get_int ("gnews/refreshtimeout");
  if (config_refreshtimeout < DEF_REFRESH)
    config_refreshtimeout = DEF_REFRESH;

  config_requestednews = gnome_config_get_string ("gnews/requestedplugins");

  config_show_titles = gnome_config_get_bool ("gnews/titles=true");
  config_show_hints = gnome_config_get_bool ("gnews/hints=true");
  config_play_sound = gnome_config_get_bool ("gnews/sound=true");
  config_separator_pixmap = gnome_config_get_bool ("gnews/seppixmap=true");
  config_separator_own = gnome_config_get_bool ("gnews/sepown=true");
  config_unique_colors = gnome_config_get_bool ("gnews/colors=true");

  config_use_proxy = gnome_config_get_bool ("gnews/proxy=true");
  config_proxy_url = gnome_config_get_string ("gnews/proxy_url");
  config_proxy_user = gnome_config_get_string ("gnews/proxy_user");
  config_proxy_passwd = gnome_config_get_string ("gnews/proxy_passwd");

  set_http_options (config_use_proxy, config_proxy_url, config_proxy_user, config_proxy_passwd);

  config_edgewait = gnome_config_get_int ("gnews/edgewait");
  if ((config_edgewait < DEF_MIN_EDGEWAIT)
      || (config_edgewait > DEF_MAX_EDGEWAIT))
    config_edgewait = DEF_EDGEWAIT;
  edgewaitremain = config_edgewait;

  config_scrolltype = gnome_config_get_int ("gnews/scrolltype");
  if ((config_scrolltype < DEF_MIN_SCROLLTYPE)
      || (config_scrolltype > DEF_MAX_SCROLLTYPE))
    config_scrolltype = DEF_SCROLLTYPE;

  gnome_config_pop_prefix ();

  createrequestedlist (config_requestednews);

  plugins = load_some_plugins (requestedlist);

  /* create the widget we are going to put on the applet */

#ifdef HAVE_PANEL_PIXEL_SIZE
/*  gtk_signal_connect(GTK_OBJECT(applet),"change_pixel_size",
		     GTK_SIGNAL_FUNC(applet_change_pixel_size),
		     NULL);*/
#endif

  gtk_signal_connect (GTK_OBJECT (applet), "change_orient", GTK_SIGNAL_FUNC (applet_change_orient), NULL);

  gtk_signal_connect (GTK_OBJECT (applet), "save_session", GTK_SIGNAL_FUNC (applet_save_session), NULL);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  applet_widget_add (APPLET_WIDGET (applet), frame);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), config_frametype);
  gtk_widget_set_usize (frame, config_width, 48);

  createbaseframes ();

  tooltips = gtk_tooltips_new ();

  if (!isemptystr (config_requestednews)) {
    refresh (NULL);
  }

  gtk_widget_show (applet);

  timeru = gtk_timeout_add (config_refreshtimeout * 60 * 1000, (GtkFunction) refresh, NULL);

  applet_widget_register_stock_callback_dir (APPLET_WIDGET (applet),
					     JUMPTO_DIR, GNOME_STOCK_MENU_JUMP_TO, _("Jump to..."));
  applet_widget_register_stock_callback (APPLET_WIDGET (applet), "properties",
					 GNOME_STOCK_MENU_PROP, _("Properties..."), open_properties, NULL);
  applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					 "toggledirection",
					 GNOME_STOCK_MENU_FORWARD, _("Toggle direction"), toggle_dir, NULL);
  applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					 "refreshnews",
					 GNOME_STOCK_MENU_REFRESH, _("Update"), refresh_news, NULL);
  applet_widget_register_stock_callback (APPLET_WIDGET (applet), "help",
					 GNOME_STOCK_PIXMAP_HELP, _("Help"), help_cb, NULL);
  applet_widget_register_stock_callback (APPLET_WIDGET (applet), "about",
					 GNOME_STOCK_MENU_ABOUT, _("About..."), about, NULL);

  applet_widget_gtk_main ();

  unload_plugins (plugins);

  return 0;
}
