------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUN-TIME LIBRARY (GNARL) COMPONENTS              --
--                                                                          --
--                        S Y S T E M . V X W O R K S                       --
--                                                                          --
--                                   S p e c                                --
--                                                                          --
--                             $Revision: 1.1 $                             --
--                                                                          --
--               Copyright (C) 1998 Free Software Foundation                --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is the M68K and MIPS VxWorks version of this package.

with Interfaces.C;

package System.VxWorks is
   pragma Preelaborate (System.VxWorks);

   package IC renames Interfaces.C;

   --  Define enough of a Wind Task Control Block in order to
   --  obtain the inherited priority.  When porting this to
   --  different versions of VxWorks (this is based on 5.3[.1]),
   --  be sure to look at the definition for WIND_TCB located
   --  in $WIND_BASE/target/h/taskLib.h

   type Wind_Fill_1 is array (0 .. 16#3F#) of IC.unsigned_char;
   type Wind_Fill_2 is array (16#48# .. 16#107#) of IC.unsigned_char;

   type Wind_TCB is record
      Fill_1          : Wind_Fill_1; -- 0x00 - 0x3f
      Priority        : IC.int;  -- 0x40 - 0x43, current (inherited) priority
      Normal_Priority : IC.int;  -- 0x44 - 0x47, base priority
      Fill_2          : Wind_Fill_2; -- 0x48 - 0x107
      spare1          : Address;  -- 0x108 - 0x10b
      spare2          : Address;  -- 0x10c - 0x10f
      spare3          : Address;  -- 0x110 - 0x113
      spare4          : Address;  -- 0x114 - 0x117
   end record;
   type Wind_TCB_Ptr is access Wind_TCB;

end System.VxWorks;
