#!../../standalone_obj/test_parse
SHELL cp c.ads1 c.ads
SHELL cp b.ads1 b.ads
SHELL gcc -c c.ads
SHELL gcc -c b.ads

--  We should already know after this that T has a child in T2
PARSE b.ads
DUMP
--  refs= b:1 t2:2 t:3 c:2

--  We should still have T with a child in T2
DUMP_ENTITY t:c.ads:2:8

--  After a refresh, the information that T2 is a child of T is lost.
--  Since we are recreating the definition of T, we just consider anything we
--  know about it to be false. That's isn't a problem when searching for child
--  types, since we will automatically reparse other files anyway
TOUCH c.ads
--  after mark_and_isolate: refs= b:1 t2:1 t:3 c:2 integer:1
PARSE c.ads
--  adding reference c:c.ads:3:5  refs=b:1 t2:1 t:4 c:2 integer:2
DUMP
--  at end refs= b:1 t2:1 t:4 c:2 integer:2

--  Let's remove the definition of T. The entity must still appear in the
--  database, since t2 still has it for a parent. Check all_entities as well
--  However, T is reported as no longer valid, and b.ads:depended_on should
--  contain c.ads, since we still have references to T in b.ads
PAUSE 1
SHELL cp c.ads2 c.ads
SHELL gcc -c c.ads
PARSE c.ads
--  after mark_and_isolate: refs= b:1 t2:1 t:3 c:2 integer:1
DUMP
--  at end: refs= b:1 t2:1 t:3 c:2 integer:1    t not Valid

--  Now b no longer depends on T. T should be removed from the database
PAUSE 1
SHELL cp b.ads2 b.ads
SHELL gcc -c b.ads
PARSE b.ads
--  after mark_and_isole: refs= b:1 t2:1 t:2 c:2 integer:1  t not Valid
--  then we reparse b.ads: refs= b:1 t2:2 t:0 c:2 integer:2
DUMP

