#include <stdio.h>

#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>

#include "gnapster.h"
#include "callbacks.h"
#include "ui.h"
#include "upload.h"
#include "network.h"
#include "commands.h"
#include "download.h"
#include "queue.h"
#include "utils.h"
#include "themes.h"

#include "chan.h"
#include "text.h"
#include "xtext.h"
#include "debug.h"


extern GnapsterMain *gmain;

extern UserInfo user_info;

extern GList *hooks;

char xtext_buf[2048 + 1];
int xtext_pos = 0;

/* Some of this code was taken from XChat with the authors permission, it was 
 * then hacked into Gnapster's system of text display. */

GdkColor colors[] = {
   { 0, 0,      0,      0 },      /* 0 */
   { 0, 0x9e00, 0x1800, 0x2800 }, /* 1 */
   { 0, 0x9500, 0xb700, 0x4900 }, /* 2 */
   { 0, 0x9600, 0x8a00, 0x3800 }, /* 3 */
   { 0, 0x4100, 0x6100, 0xa000 }, /* 4 */
   { 0, 0x9b00, 0x7600, 0x8e00 }, /* 5 */
   { 0, 0x4100, 0x9100, 0x8900 }, /* 6 */
   { 0, 0xbe00, 0xbe00, 0xbe00 }, /* 7 */
   { 0, 0x6600, 0x6600, 0x6600 }, /* 8 */
   { 0, 0xcf00, 0x6100, 0x7100 }, /* 9 */
   { 0, 0xc500, 0xf700, 0x7900 }, /* 10 */
   { 0, 0xff00, 0xf700, 0x9600 }, /* 11 */
   { 0, 0x4100, 0x8600, 0xbe00 }, /* 12 */
   { 0, 0xcf00, 0x9e00, 0xbe00 }, /* 13 */
   { 0, 0x7100, 0xbe00, 0xbe00 }, /* 14 */
   { 0, 0xdd00, 0xdd00, 0xdd00 }, /* 15 */
   { 0, 0xbe00, 0xbe00, 0xbe00 }, /* 16 selection background*/
   { 0, 0,      0,      0 },      /* 17 selection foreground */
   { 0, 0xbe00, 0xbe00, 0xbe00 }, /* 18 default text */
   { 0, 0,      0,      0 },      /* 19 background */
};

/*GdkColor colors[] = {
   { 0, 0,      0,      0 },
   { 0, 0xcccc, 0xcccc, 0xcccc },
   { 0, 0,      0,      0xcccc },
   { 0, 0,      0xcccc, 0 },
   { 0, 0xcccc, 0,      0 },
   { 0, 0xbbbb, 0xbbbb, 0 },
   { 0, 0xbbbb, 0,      0xbbbb }, 
   { 0, 0xffff, 0xaaaa, 0 },      
   { 0, 0xffff, 0xffff, 0 },      
   { 0, 0,      0xffff, 0 },      
   { 0, 0,      0xcccc, 0xcccc }, 
   { 0, 0,      0xffff, 0xffff }, 
   { 0, 0,      0,      0xffff }, 
   { 0, 0xffff, 0,      0xffff }, 
   { 0, 0x7777, 0x7777, 0x7777 }, 
   { 0, 0x9999, 0x9999, 0x9999 }, 
   { 0, 0,      0,      0xcccc }, 
   { 0, 0xeeee, 0xeeee, 0xeeee }, 
   { 0, 0xcccc, 0xcccc, 0xcccc }, 
   { 0, 0,      0,      0 },
};*/

GdkFont *load_font() {
   GdkFont *font;
   char *fontname;

   fontname = user_info.default_font;

   font = gdk_font_load(fontname);
   if (!font)
     font = gdk_font_load("fixed");
   
   return font;
}

void generate_colors(GtkWidget *widget) {
   int i;
   
   if (!colors[0].pixel)
     for(i=0; i<20; i++) {
	colors[i].pixel = (unsigned long)((colors[i].red & 0xff00) * 256 +
					  (colors[i].green & 0xff00) +
					  (colors[i].blue & 0xff00) / 256);
	gdk_color_alloc(gtk_widget_get_colormap(widget), &colors[i]);
     }
}

char *text_insert_next_val(char *s, char **next, int *col) {
   char *ptr, *str;
   
   if (!s || !*s)
     return NULL;
   
   ptr = s;
   str = ptr;
   while(*str) {
      if (*str >= 1 && *str <= 2) {
	 *col = *str;
	 break;
      }
      str++;
   }
   
   if (*str)
     *str++ = 0;
   
   if (next)
     *next = str;
   
   return ptr;
}

char *real_text_insert(GtkWidget *text, char *fmt) {
   char *ret = NULL, *fmtptr, *ptr = NULL;
   int col = -1, next_col = 1;
   char buf[1024] = { 0 }, b_str[2048] = { 0 };
   
   fmtptr = fmt;
   while(ptr || col == -1) {
      if (col == -1)
	ret = fmt;
      col = next_col;
      ptr = text_insert_next_val(fmtptr, &fmtptr, &next_col);
      if (!ptr)
	break;

      if (col == 2) 
	g_snprintf(buf, sizeof(buf), "\003%i%s", col + 8, ptr);
      else
	g_snprintf(buf, sizeof(buf), "\017%s", ptr);
      if (strlen(buf) + strlen(b_str) < 2048)
	strcat(b_str, buf);
   }
   
   gtk_xtext_append(GTK_XTEXT(text), b_str, strlen(b_str));
   
   return ret;
}

void hook_text_insert(STab *stab, int val, char *prefix, char *hook, char *fmt, ...) {
   char *str, *hook_text;
   va_list args;
   
   va_start(args, fmt);
   str = d_strdup_vprintf(fmt, args);
   va_end(args);
   
   d_strexp(&str, "%s\4", str);
   
   hook_text = hook_replace(hook, str);
   d_free(str);
   
   if (!hook_text)
     return;
   
   console_log(hook, hook_text);

   gnapster_text_insert(stab, val, prefix, "%s", hook_text);
   d_free(hook_text);
}

void gnapster_text_insert(STab *stab, int val, char *prefix, char *fmt, ...) {
   GtkWidget *text, *vbox, *parent;
   char *str;
   char *fmtptr, *format_str;
   int i;
   va_list args;

   if (val == CURR)
     val = gnapster_get_pagenum(stab);
   
   if (val < 0)
     return;
   
   va_start(args, fmt);
   format_str = d_strdup_vprintf(fmt, args);
   va_end(args);
   
   if (!format_str)
     return;
   
   parent = stab->ct->notebook;
   switch(val) {
    case CONSOLE:
    case MOTD:
      text = stab->ct->text;
      vbox = stab->ct->vbox;
      break;
/*    case MOTD:
      parent = stab->notebook;
      text = stab->mt->text;
      vbox = stab->mt->vbox;
      return;
      break;*/
    default:
	{
	   ChannelInfo *chan;
	   
	   chan = g_list_nth_data(stab->ct->channel_list, (val - 2));
	   if (!chan)
	     return;

	   text = chan->text;
	   vbox = chan->vbox;
	}
      break;
   }
   
   if (!strncmp(prefix, "system", 6)) {
      char *out;
      
      out = NULL;
      
      if (!strcmp(prefix, "system"))
	out = lookup_hook("prefix", hooks);
      else if (!strcmp(prefix, "system_positive"))
	out = lookup_hook("prefix_positive", hooks);
      else if (!strcmp(prefix, "system_negative"))
	out = lookup_hook("prefix_negative", hooks);
      
      if (out)
	d_msprintf(&str, "%s%s", next_arg_full(out, NULL, '\n'), format_str);
      else
	str = d_strdup(format_str);
			 
      d_free(format_str);
      format_str = str;
   }

   if (user_info.conf[TIMESTAMP_EV]) {
      char buf[16];
      time_t t;
      
      t = time(NULL);
      
      strftime(buf, sizeof(buf) - 1, "%I:%M%p", localtime(&t));
      
      d_msprintf(&format_str, "\00308[%s]\017 %s", buf, format_str);
   }
   
   for(i=0;format_str[i];i++) {
      if (format_str[i] == '\n') {
	 xtext_buf[xtext_pos] = 0;
	 xtext_pos = 0;
	 
	 fmtptr = real_text_insert(text, xtext_buf);
      } else
	xtext_buf[xtext_pos++] = format_str[i];
   }
   
   d_free(format_str);
   
   if (xtext_pos)
     return;
   
   highlight(parent, vbox);
}
