#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>

#include "gnapster.h"
#include "upload.h"
#include "commands.h"
#include "download.h"
#include "queue.h"

#include "debug.h"

extern UserInfo user_info;
extern GnapsterMain *gmain;

int remote_queue_check(void *data) {
   Transfer *download;
   int row;
   
   d_assert_return(data != NULL, 0);
   
   download = data;
   
   download->status = 0;
   
   TIMEOUT_REMOVE(download->timeout_tag);
   
   row = gtk_clist_find_row_from_data(GTK_CLIST(gmain->dt->clist), download);

   gtk_clist_set_text(GTK_CLIST(gmain->dt->clist), row, 4, "Retrying...");
   fprintf(stderr, "retrying download %s\n", download->file);
   
   napster_send(download->st->ci->sock, NAPSTER_GET, "%s \"%s\"",
		download->user, download->file);
   
   return 0;
}

Transfer *find_valid_queue(int *row) {
   Transfer *download;
   int peruser, r = -1;
   GList *ptr;
   
   for(ptr=GTK_CLIST(gmain->dt->queue_clist)->row_list; ptr; ptr=ptr->next) {
      download = GTK_CLIST_ROW(ptr)->data;
      if (!download)
	break;
      
      r++;
      
      if (user_info.conf[MAX_PERUSER_DOWNLOADS_SWITCH]) {
	 peruser = peruser_downloads(download->user);
	 if (peruser >= user_info.conf[MAX_PERUSER_DOWNLOADS])
	   continue;
      }
      
      *row = r;
      
      return download;
   }
   
   return NULL;
}

void queue_check() {
   int downloads, queue, row = -1;
   Transfer *q, *dup;
   
   queue = GTK_CLIST(gmain->dt->queue_clist)->rows;
   if (!queue)
     return;
   
   downloads = GTK_CLIST(gmain->dt->clist)->rows;
   if (user_info.conf[MAX_DOWNLOADS_SWITCH] &&
       downloads >= user_info.conf[MAX_DOWNLOADS])
     return;
   
   q = find_valid_queue(&row);
   if (!q)
     return;
   
   dup = download_dup(q);
   handle_download(dup, DOWNLOAD_NORMAL);

   gtk_clist_remove(GTK_CLIST(gmain->dt->queue_clist), row);
}

void add_queue(Transfer *data) {
   char *tme, *kbps;
   int seconds = 0, row;
   
   if (!data)
     return;
   
   if (data->kbps > 0)
     seconds = (data->size / ((data->kbps * 1000) / 8));
   
   d_msprintf(&tme, "%i:%02i",
	      data->num / 60, data->num % 60);
   d_msprintf(&kbps, "%i", data->kbps);
   
   row = gnapster_clist_append(gmain->dt->queue_clist, gmain->dt->vbox, data,
			       data->trunc_file, napster_conn_as_str(data->connection),
			       data->user, simplify_size(data->size), tme, 
			       kbps, NULL);
   
   set_clist_server(gmain->dt->queue_clist, data->st, row);
   
   d_free(tme);
   d_free(kbps);
}

void cancel_movequeue_cb() {
   Transfer *temp, *dup;
   GtkWidget *clist;
   GList *sel, *selptr = NULL;
   
   clist = gmain->dt->clist;
   
   for(sel=GTK_CLIST(clist)->selection; sel; sel=sel->next) {
      temp = gtk_clist_get_row_data(GTK_CLIST(clist), INT(sel->data));
      if (!temp)
	continue;
      
      selptr = g_list_append(selptr, temp);
   }
   
   for(sel=selptr; sel; sel=sel->next) {
      temp = sel->data;
      if (!temp)
	continue;
      
      dup = download_dup(temp);
      download_close(temp, TRANSFER_CANCEL);
      
      dup->size = dup->total;
      
      d_free(dup->resume_path);
      dup->resume_path = NULL;
      
      add_queue(dup);
   }
}

void cancel_queue_cb() {
   Transfer *temp;
   GtkWidget *clist;
   GList *selection, *selptr = NULL;
   
   clist = gmain->dt->queue_clist;

   selection = GTK_CLIST(clist)->selection;
   if (!selection)
     return;

   while(selection) {
      temp = gtk_clist_get_row_data(GTK_CLIST(clist), INT(selection->data));
      
      if (temp)
	selptr = g_list_append(selptr, temp);

      selection = selection->next;
   }

   selection = selptr;
   while(selection) {
      temp = selection->data;
      
      gtk_clist_remove(GTK_CLIST(clist),
		       gtk_clist_find_row_from_data(GTK_CLIST(clist), temp));
      
      selection = selection->next;
   }
}

void force_queue_cb(GtkWidget *w, gpointer data) {
   download_true_cb(gmain->dt->queue_clist, NULL);
}
