-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/cfg/prep.adb,v $
--  Description     : GNADE Preprocessor and configuration tool
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>
--  Created On      : 22-Mar-2004
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2004/05/09 10:00:19 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2004 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                       use Ada.Text_IO;
with Ada.Strings.Unbounded;             use Ada.Strings.Unbounded;
with Ada.Strings;                       use Ada.Strings;
with Ada.Strings.Fixed;                 use Ada.Strings.Fixed;
with Ada.Command_Line;                  use Ada.Command_Line;

with String_Builder;                    use String_Builder;
with CFG;                               use CFG;

with Tables;

procedure Prep is

   Version : constant String := "$Id: prep.adb,v 1.5 2004/05/09 10:00:19 merdmann Exp $";

   SB            : String_Builder.Object;
   Argc          : Natural := 1;
   In_File_Name  : Unbounded_String := Null_Unbounded_String ;
   Out_File_Name : Unbounded_String := Null_Unbounded_String ;
   CFG_DB_Path   : Unbounded_String := Null_Unbounded_String ;
   CR_Shown      : Boolean := False;
   Opt_Silent    : Boolean := False;
   ----------
   -- Help --
   -----------
   procedure Help is
   begin
      Put_Line("usage:" );
      Put_Line("   prep [options] in-file out-file" );
      Put_Line("" );
      Put_Line("options:");
      Put_Line("   <name>'='<value>      Define a substitution value");
      Put_Line("   -f <name>             Load definitions from a given file");
      Put_Line("");
   end Help;

   ---------------
   -- Copyrigth --
   ---------------
   procedure Copyrigth is
   begin
      If not CR_Shown and not Opt_Silent then
         Put_Line("GNADE Preprocessor Version 1.0" );
         Put_Line("Copyright (C) 2004 Michael Erdmann " );
      end if;

      CR_Shown := True;
   end Copyrigth;

   ------------------
   -- Process_Line --
   ------------------
   function Process_Line(
      S      : in String ) return String is
      Attrib : String( 1..256 ) := (others =>' ');
      Length : Natural := 0;
   begin
      Clear( SB );
      for i in S'Range loop
         if S(i) = '@' then
            if Length = 0 then
               Length := Attrib'First;
            else
               Insert( SB, CFG.Get( Attrib( 1..Length-1 ) ) );
               Length := 0;
            end if;
         else
            if Length > 0 then
               Attrib(Length) := S(i);
               Length := Length + 1;
            else
               Insert( SB, S(i) );
            end if;
         end if;
      end loop;

      return To_String( SB );
   end Process_Line;

   -------------
   -- Process --
   -------------
   procedure Process_File(
      Input  : in String;
      Output : in String ) is
      -- process a single file
      Line   : String( 1..1024 );
      Length : Natural := 0;
      Inp    : File_Type ;
      Outp   : File_Type ;
      LineNo : Natural   := 0;
   begin
      Open(   File => Inp,  Name => Input,  Mode => In_File );
      Create( File => Outp, Name => Output, Mode => Out_File );

      while not End_Of_File( Inp ) loop
         begin
            Get_Line( Inp, Line, Length );
            LineNO := LineNo + 1;
            Put_Line( Outp, Process_Line( Line(1..Length ) ) );
         end ;
      end loop ;

      Close(inp);
      Close(Outp);

   exception
      when Others =>
         Put_Line("Error while processing line" & Natural'Image(LineNo) &
                  " of " & Input );
   end Process_File;

begin
   if Argument_Count < 1 then
      Help;
      return;
   end if;

   while Argc in 1..Argument_Count loop
      if Argument(Argc) = "-f" then
         Argc := Argc + 1;
         Load_CFG( Argument( Argc ) );
         Argc := Argc + 1;
      elsif Argument(Argc) = "-s" then
         Opt_Silent := True;
         CFG.Opt_Silent := Opt_Silent;
         Argc := Argc + 1;
      elsif Index( Argument(Argc), "=" ) > 0 then
         CFG.Add( Argument( Argc ) );
         Argc := Argc + 1;
      else
         if In_File_Name = Null_Unbounded_String then
            In_File_name := To_Unbounded_String( Argument( Argc ) );
         elsif Out_File_Name = Null_Unbounded_String then
            Out_File_name := To_Unbounded_String( Argument( Argc ) );
         end if;

         Argc := Argc + 1;

         if Out_File_Name /= Null_Unbounded_String  and
            In_File_Name  /= null_Unbounded_String
         then
            Copyrigth;

            Process_File(
               To_String( In_File_Name ),
               To_String( Out_File_Name ) );
         end if;
      end if;
   end loop;

   Finalize( SB );
end Prep;
