-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_window.adb,v $
--  Description     : GUI for the data base client
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/09/22 20:09:33 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;

-- GTK Support packages (gtkada package)

with Glib;                     use Glib;

with Gdk;
with Gdk.Drawable;             use Gdk.Drawable;
with Gdk.Bitmap;               use Gdk.Bitmap;
with Gdk.Event;                use Gdk.Event;
with Gdk.Font;                 use Gdk.Font;

with Gdk.GC;                   use Gdk.GC;
with Gdk.Pixmap;               use Gdk.Pixmap;
with Gdk.Rectangle;            use Gdk.Rectangle;
with Gdk.Types;                use Gdk.Types;
with Gdk.Window;               use Gdk.Window;

with Gtk.Rc;
with Gtk;                      use Gtk;
with Gtk.Arguments;            use Gtk.Arguments;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Frame;                use Gtk.Frame;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Main;                 use Gtk.Main;

with Gtk.Pixmap;               use Gtk.Pixmap;
with Gtkada.Handlers;          use Gtkada.Handlers;

with Gtk.Window;               use Gtk.Window;
with Gtk.Widget;               use Gtk.Widget;

-- gsql components
with Preferences;              use Preferences;
with Datasource_Handler;       use Datasource_Handler;

with GUI_Preferences;          use GUI_Preferences;
with GUI;                      use GUI;

package body GUI_Window is

   Module_Version : constant String := "$Id: gui_window.adb,v 1.4 2001/09/22 20:09:33 me Exp $";

   --- *************************************************************************** --
   --- ***                    L O C A L   D A T A    TYPES                     *** --
   --- *************************************************************************** --

   Title   : constant String := "ODBC Explorer Version " & Version;

   -----------------
   -- GTK Objects --
   -----------------
   Window  : Gtk_Window;
   Wbox    : Gtk_Box;

   ----------------------
   -- Support Packages --
   ----------------------
   package Destroyed is new Gtk.Handlers.Callback (
      Widget_Type => Gtk_Window_Record);

   ---------
   -- Bye --
   ---------
   procedure Bye (
      Window : access Gtk.Window.Gtk_Window_Record'Class) is
      pragma Warnings (Off, Window);
   begin
      Gtk.Main.Main_Quit;
   end Bye;

   --- *************************************************************************** --
   --- ***    G E N E R A L   W I N D O W  M A N  A G E M E N T   PROCEDURES   *** --
   --- *************************************************************************** --

   ------------------
   -- Window_Title --
   ------------------
   procedure Window_Title(
      Text : in String ) is
   begin
      Set_Title (Window, Preference( Prf_Project ) & " : " & Text);
   end Window_Title;

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize is
   begin
      Gtk.Main.Init;
      Gtk.Rc.Parse ("testgtkrc");
      -- create the top level window
      Gtk_New (Window, Window_Toplevel);

      Destroyed.Connect (
         Window,
         "destroy",
         Destroyed.To_Marshaller (Bye'Access));

      -- create a vbox which contains all elements
      Gtk_New_Vbox( WBox, Homogeneous => False, Spacing =>0);
      Set_USize( WBox, 950, 850 );

      GUI.Initialize( Wbox );

      Add( Window, Wbox );

      Window_Title("");
      Show_All (Window);
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize is
   begin
      GUI_Preferences.Copy_To_Projectfile;
      GUI.Finalize( Wbox );
   end Finalize;

   ----------
   -- Main --
   ----------
   procedure Main is
   begin
      Gtk.Main.Main;
   end Main;

end GUI_Window;

