;
; $Id: gnade.iss,v 1.5 2001/06/05 16:05:11 sf Exp $
;
[Setup]

AppName=GNU Ada Database Development Environment
AppVerName=GNU Ada Database Development Environment version 1.1.3
AppPublisher=GNADE project
AppPublisherURL=http://gnade.sourceforge.net
AppSupportURL=http://gnade.sourceforge.net
AppUpdatesURL=http://gnade.sourceforge.net
DefaultDirName={reg:HKLM\Software\Ada Core Technologies\GNAT,ROOT|{pf}}\adaodbc
; Use gnat installation directory as base for gnade
DefaultGroupName=GNADE
AllowNoIcons=yes
InfoBeforeFile=info_before.txt
AlwaysCreateUninstallIcon=yes
OutputBaseFilename=gnade-1.1.3
; uncomment the following line if you want your installation to run on NT 3.51 too.
; MinVersion=4,3.51

[Dirs]
Name: "{app}\bin"
Name: "{app}\doc"
Name: "{app}\lib"

[Files]
Source: "readme.txt";            DestDir: "{app}\doc"; CopyMode: alwaysoverwrite; Flags: isreadme
Source: "info_before.txt";       DestDir: "{app}\doc"; CopyMode: alwaysoverwrite
Source: "..\..\doc\html\*.htm*"; DestDir: "{app}\doc"; CopyMode: alwaysoverwrite
Source: "..\..\doc\releasenotes\note_1.1.3.html"; DestDir: "{app}\doc"; CopyMode: alwaysoverwrite
Source: "..\..\doc\gnade.pdf";   DestDir: "{app}\doc"; CopyMode: alwaysoverwrite
Source: "..\gesql.exe";          DestDir: "{app}\bin"; CopyMode: alwaysoverwrite
; Place a copy also in the gnat bin directory
Source: "..\gesql.exe";               DestDir: "{app}\..\bin"; CopyMode: alwaysoverwrite

Source: "rebuild.bat";                DestDir: "{app}\bin"; CopyMode: alwaysoverwrite
Source: "..\..\adaodbc\*.ad?";        DestDir: "{app}\lib"; CopyMode: alwaysoverwrite
Source: "..\..\adaodbc\*.ali";        DestDir: "{app}\lib"; CopyMode: alwaysoverwrite; Attribs: readonly;  Flags: overwritereadonly
Source: "..\..\adaodbc\libadaodbc.a"; DestDir: "{app}\lib"; CopyMode: alwaysoverwrite

[Icons]
Name: "{group}\GNADE Documentation (HTML)"; Filename: "{app}\doc\gnade.html"
Name: "{group}\GNADE Documentation (PDF)";  Filename: "{app}\doc\gnade.pdf"
Name: "{group}\Release Notes";        Filename: "{app}\doc\note_1.1.3.html"
Name: "{group}\Readme";               Filename: "{app}\doc\readme.txt"
Name: "{group}\Install Information";  Filename: "{app}\doc\info_before.txt"
Name: "{group}\Rebuild libadaodbc.a"; Filename: "{app}\bin\rebuild.bat"; WorkingDir: "{app}\lib"

[Registry]
Root: HKLM; Subkey: "Software\Ada Core Technologies\GNAT\Standard Libraries"; ValueType: string; ValueName: "gnade"; ValueData: "{app}\lib"; Flags: uninsdeletevalue;

[UninstallRun]
Filename: "attrib.exe"; Parameters: "-r *.ali"; WorkingDir: "{app}\lib"; Flags: runminimized


