/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2004-2008 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using GLib;

public class CharBox : Gtk.EventBox
{
  public string letter { get; set; default = "?"; }
  public Gtk.ShadowType border { get; set; default = Gtk.ShadowType.NONE; }
  public int points { get; set; }
  
  private Gtk.StateType _highlight;
  public Gtk.StateType highlight {
    get {return _highlight;}
    set {
      _highlight = value;
      queue_draw ();
    }
    default = Gtk.StateType.NORMAL;
  }
  
  /* Private methods & members */
  private Gtk.DrawingArea area;
  
  private bool exposed (Gtk.DrawingArea da, Gdk.EventExpose event)
  {
    var w = da.allocation.width;
    var h = da.allocation.height;
    var style = get_style ();
    
    if (border != Gtk.ShadowType.NONE)
      Gtk.paint_box (style, da.window, highlight, border, null, null, null,
                            0, 0, w, h);
    
    var ctx = Gdk.cairo_create (da.window);
    
    // Letter
    Gdk.Color fg_color = style.fg[(int)highlight];
    ctx.set_source_rgb (fg_color.red/65535.0,
                        fg_color.green/65535.0,
                        fg_color.blue/65535.0);

    ctx.set_font_size (points);
    
    Cairo.TextExtents te = Cairo.TextExtents();
    ctx.text_extents (_(letter), out te);
    
    Cairo.FontExtents fe = Cairo.FontExtents();
    ctx.font_extents (out fe);
    
    ctx.move_to ( w/2 - te.x_bearing - te.width / 2,
                  h/2 - fe.descent + fe.height / 2);
    ctx.show_text (_(letter));
    
    return true;
  }
  
  /* Constructor */
  public CharBox (string letter, Gtk.ShadowType border)
  {
    this.letter = letter;
    this.border = border;
  }
  
  construct
  {
    area = new Gtk.DrawingArea ();
    area.expose_event += exposed;
    add (area);
  }
}

