.TH GMTDEFAULTS l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
gmtdefaults \- To list current \fBGMT\fP defaults
.SH SYNOPSIS
\fBgmtdefaults\fP \fB\-D\fP[\fBu\fP|\fBs\fP] | \fB\-L\fP
.SH DESCRIPTION
\fBgmtdefaults\fP lists the 
\fBGMT\fP parameter defaults if the option \fB\-D\fP is used.  There are three ways to change some of the settings:
(1) Use the command \fBgmtset\fP, (2) use any texteditor to edit the file \.gmtdefaults4 in your home
or current directory (if you do not have this file, run 
\fBgmtdefaults\fP -D > ~/.gmtdefaults4 to get one with the system default settings), or (3) overrid any parameter
by specifying one or more \fB\-\-PARAMETER=VALUE\fP statements on the commandline of any \fBGMT\fP command
(\fBPARAMETER\fP and \fBVALUE\fP are any combination listed below).  The
first two options are permanent changes until explicitly changed back, while the last option is emphemeral
and only applies to the single \fBGMT\fP command that received the override.
\fBGMT\fP can provide default values in US or SI units.  This choice is determined by the contents of the
gmt.conf file in \fBGMT\fP's share directory.\"'
.TP
.B \-D
Print the system \fBGMT\fP defaults to standard output.  Append \fBu\fP for US
defaults or \fBs\fP for SI defaults. [\fB\-D\fP alone gives current choice in gmt.conf].
.TP
.B \-L
Print the user's currently active defaults to standard output.\"'
.br
.sp
Your currently active defaults come from the \.gmtdefaults4 file in the 
current working directory, if present; else from the \.gmtdefaults4 file 
in your home directory, if present; else from the
system defaults set at the time \fBGMT\fP was compiled.
.SH \fBGMT\fP PARAMETERS
The following is a list of the parameters that are user-definable in \fBGMT\fP.  The
parameter names are always given in UPPER CASE.  The parameter values are
case-insensitive unless otherwise noted.  The
system defaults are given in brackets [ for SI (and US) ].  Those marked \fB*\fP can be set on the command
line as well (the corresponding option is given in parentheses).  Note that default distances and
lengths below are given in both cm or inch; the chosen default depends on your choice of default
unit (see \fBMEASURE_UNIT\fP).  You can explicitly specify the unit used for distances and
lengths by appending \fBc\fP (cm), \fBi\fP (inch), \fBm\fP (meter), or \fBp\fP (points).
When no unit is indicated the value will be assumed to be in the unit set by \fBMEASURE_UNIT\fP.
Note that the printer resolution \fBDOTS_PR_INCH\fP is always the number of dots or pixels per inch.
Several parameters take only TRUE or FALSE.
.TP
.B ANNOT_MIN_ANGLE
If the angle between the map boundary and the annotation baseline is less than this minimum value (in degrees), the
annotation is not plotted (this may occur for certain oblique projections.)  Give a value in the
range 0\-90. [20]
.TP
.B ANNOT_MIN_SPACING
If an annotation would be plotted less than this minimum distance from its closest neighbor, the
annotation is not plotted (this may occur for certain oblique projections.) [0]
.TP
.B ANNOT_FONT_PRIMARY
Font used for upper annotations, etc. [Helvetica].  Specify either the font number or
the font name (case sensitive!).  The 35 available fonts are:
.br
	0  Helvetica
.br
	1  Helvetica-Bold
.br
	2  Helvetica-Oblique
.br
	3  Helvetica-BoldOblique
.br
	4  Times-Roman
.br
	5  Times-Bold
.br
	6  Times-Italic
.br
	7  Times-BoldItalic
.br
	8  Courier
.br
	9  Courier-Bold
.br
	10 Courier-Oblique
.br
	11 Courier-BoldOblique
.br
	12 Symbol
.br
	13 AvantGarde-Book
.br
	14 AvantGarde-BookOblique
.br
	15 AvantGarde-Demi
.br
	16 AvantGarde-DemiOblique
.br
	17 Bookman-Demi
.br
	18 Bookman-DemiItalic
.br
	19 Bookman-Light
.br
	20 Bookman-LightItalic
.br
	21 Helvetica-Narrow
.br
	22 Helvetica-Narrow-Bold
.br
	23 Helvetica-Narrow-Oblique
.br
	24 Helvetica-Narrow-BoldOblique
.br
	25 NewCenturySchlbk-Roman
.br
	26 NewCenturySchlbk-Italic
.br
	27 NewCenturySchlbk-Bold
.br
	28 NewCenturySchlbk-BoldItalic
.br
	29 Palatino-Roman
.br
	30 Palatino-Italic
.br
	31 Palatino-Bold
.br
	32 Palatino-BoldItalic
.br
	33 ZapfChancery-MediumItalic
.br
	34 ZapfDingbats
.TP
.B ANNOT_FONT_SIZE_PRIMARY
Font size (> 0) in points for map annotations.  [14]
.TP
.B ANNOT_FONT_SECONDARY
Font to use for time axis secondary annotations.  See \fBANNOT_FONT_PRIMARY\fP for available fonts  [Helvetica].
.TP
.B ANNOT_FONT_SIZE_SECONDARY
Font size (> 0) for time axis secondary annotations in points  [16].
.TP
.B ANNOT_OFFSET_PRIMARY
Distance from end of tickmark to start of annotation [0.2\fBc\fP (or 0.075\fBi\fP)].  A negative
offset will place the annotation inside the map border.
.TP
.B ANNOT_OFFSET_SECONDARY
Distance from base of primary annotation to the top of the secondary annotation [0.2\fBc\fP (or 0.075\fBi\fP)] (Only
applies to time axes with both primary and secondary annotations).
.TP
.B BASEMAP_AXES
Sets which axes to draw and annotate.  Case sensitive: Upper case means both draw and annotate, lower case
means draw axis only.  [WESN].
.TP
.B BASEMAP_FRAME_RGB
Color used to draw map boundaries and annotations.
Give a red/green/blue triplet, with each element in the 0\-255 range.
Prepend '+' to replicate this color to the tick-, grid-, and frame-pens.
[0/0/0] (black).
.TP
.B BASEMAP_TYPE
Choose between plain and fancy (thick boundary, alternating black/white frame; append + for rounded corners)  [fancy].
For some map projections (e.g., Oblique Mercator), plain is the only option even if fancy is set as default.
In general, fancy only applies to situations where the projected x and y directions parallel the lon and lat
directions (e.g., rectangular projections, polar projections).
.TP
.B CHAR_ENCODING
Names the eight bit character set being used for text in files and in command line parameters. This allows \fBGMT\fP
to ensure that the \fIPostScript\fP output generates the correct characters on the plot..  Choose from Standard, Standard+, ISOLatin1, ISOLatin1+,
and ISO-8859-x (where x is in the ranges 1-10 or 13-15).  See Appendix F for details [ISOLatin1+ (or Standard+)].
.TP
.B COLOR_BACKGROUND
Color used for the background of images (i.e., when z < lowest colortable entry).
Give a red/green/blue triplet, with each element in the 0\-255 range. [0/0/0] (black)
.TP
.B COLOR_FOREGROUND
Color used for the foreground of images (i.e., when z > highest colortable entry).
Give a red/green/blue triplet, with each element in the 0\-255 range. [255/255/255] (white)
.TP
.B COLOR_IMAGE
Selects which operator to use when rendering bit-mapped color images.  Due to the
lack of the colorimage operator in some \fIPostScript\fP implementations, \fBGMT\fP offers 2 different
options:
.br
.sp
	adobe (Adobe's colorimage definition)  [Default].\"'
.br
	tiles (Plot image as many individual rectangles).
.br
.TP
.B COLOR_MODEL
Selects if color palette files contain RGB values (r,g,b in 0-255 range), HSV values
(h in 0-360, s,v in 0-1 range), or CMYK values (c,m,y,k in 0-100% range).  A \fBCOLOR_MODEL\fP setting in the color palette file
will override this setting.  Internally, color interpolation takes place directly
on the rgb values which can give unexpected hues, whereas interpolation directly on the
hsv values better preserves the hues.  Prepend the prefix "+" to force interpolation in
the selected color system (does not apply to the CMYK system)  [rgb].
.TP
.B COLOR_NAN
Color used for the non-defined areas of images (i.e., where z == NaN).
Give a red/green/blue triplet, with each element in the 0\-255 range. [128/128/128] (gray)
.TP
.B D_FORMAT
Output format (C language printf syntax) to be used when printing double precision floating point numbers.
For geographic coordinates, see \fBOUTPUT_DEGREE_FORMAT\fP. [%lg].
.TP
.B DEGREE_SYMBOL
Determines what symbol is used to plot the degree symbol on geographic map annotations.  Choose between
ring, degree, colon, or none [ring].
.TP
.B DOTS_PR_INCH
Resolution of the plotting device (dpi).  Note that in order to be as compact as possible,
\fBGMT\fP \fIPostScript\fP output uses integer formats only so the resolution should be
set depending on what output device you are using.  E.g, using 300 and sending the output to
a Linotype 300 phototypesetter (2470 dpi) will not take advantage of the extra resolution (i.e.,
positioning on the page and line thicknesses are still only done in steps of 1/300 inch; of course, text will look smoother)  [300].
.TP
.B ELLIPSOID
The (case sensitive) name of the ellipsoid used for the map projections  [WGS-84].  Choose among
.br
.sp
WGS-84	1984	World Geodetic System [Default]
.br
OSU91A	1991	Ohio State University
.br
OSU86F	1986	Ohio State University
.br
Engelis	1985	Goodard Earth Models
.br
SGS-85	1985	Soviet Geodetic System
.br
MERIT-83	1983	United States Naval Observatory
.br
GRS-80	1980	International Geodetic Reference System
.br
Lerch	1979	For geoid modelling
.br
ATS77	1977	Average Terrestrial System, Canada Maritime provinces
.br
IAG-75	1975	International Association of Geodesy
.br
Indonesian	1974	Applies to Indonesia
.br
WGS-72	1972	World Geodetic System
.br
NWL-10D	1972	Naval Weapons Lab (Same as WGS-72)
.br
South-American	1969	Applies to South America
.br
Fischer-1968	1968	Used by NASA for Mercury program
.br
Modified-Mercury-1968	1968	Same as Fischer-1968
.br
GRS-67	1967	International Geodetic Reference System
.br
International-1967	1967	Worldwide use
.br
WGS-66	1966	World Geodetic System
.br
NWL-9D	1966	Naval Weapons Lab (Same as WGS-66)
.br
Australian	1965	Applies to Australia
.br
APL4.9	1965	Appl. Physics
.br
Kaula	1961	From satellite tracking
.br
Hough	1960	Applies to the Marshall Islands
.br
WGS-60	1960	World Geodetic System
.br
Fischer-1960	1960	Used by NASA for Mercury program
.br
Mercury-1960	1960	Same as Fischer-1960
.br
Modified-Fischer-1960	1960	Applies to Singapore
.br
Fischer-1960-SouthAsia	1960	Same as Modified-Fischer-1960
.br
Krassovsky	1940	Used in the (now former) Soviet Union
.br
War-Office	1926	Developed by G. T. McCaw
.br
International-1924	1924	Worldwide use
.br
Hayford-1909	1909	Same as the International 1924
.br
Helmert-1906	1906	Applies to Egypt
.br
Clarke-1880	1880	Applies to most of Africa, France
.br
Clarke-1880-Arc1950	1880	Modified Clarke-1880 for Arc 1950
.br
Clarke-1880-IGN	1880	Modified Clarke-1880 for IGN
.br
Clarke-1880-Jamaica	1880	Modified Clarke-1880 for Jamaica
.br
Clarke-1880-Merchich	1880	Modified Clarke-1880 for Merchich
.br
Clarke-1880-Palestine	1880	Modified Clarke-1880 for Palestine
.br
Andrae	1876	Applies to Denmark and Iceland
.br
Clarke-1866	1866	Applies to North America, the Philippines
.br
Clarke-1866-Michigan	1866	Modified Clarke-1866 for Michigan
.br
Struve	1860	Friedrich Georg Wilhelm Struve
.br
Clarke-1858	1858	Clarke's early ellipsoid
.br
Airy	1830	Applies to Great Britain
.br
Airy-Ireland	1830	Applies to Ireland in 1965
.br
Modified-Airy	1830	Same as Airy-Ireland
.br
Bessel	1841	Applies to Central Europe, Chile, Indonesia
.br
Bessel-Schwazeck	1841	Applies to Namibia
.br
Bessel-Namibia	1841	Same as Bessel-Schwazeck
.br
Bessel-NGO1948	1841	Modified Bessel for NGO 1948
.br
Everest-1830	1830	India, Burma, Pakistan, Afghanistan, Thailand
.br
Everest-1830-Kalianpur	1830	Modified Everest for Kalianpur (1956)
.br
Everest-1830-Kertau	1830	Modified Everest for Kertau, Malaysia & Singapore
.br
Everest-1830-Timbalai	1830	Modified Everest for Timbalai, Sabah Sarawak
.br
Everest-1830-Pakistan	1830	Modified Everest for Pakistan
.br
Walbeck	1819	First least squares solution by Finnish astronomer
.br
Plessis	1817	Old ellipsoid used in France
.br
Delambre	1810	Applies to Belgium
.br
CPM	1799	Comm. des Poids et Mesures, France
.br
Maupertius	1738	Really old ellipsoid used in France
.br
Sphere	1980	The mean radius in GRS-80 (for spherical/plate tectonics applications)
.br
.sp
Note that for some global projections, \fBGMT\fP may default to GRS-80 Sphere regardless
of ellipsoid actually chosen.  A warning will be given when this happens.  If a different
ellipsoid name than those mentioned here is given, \fBGMT\fP will attempt to open
a file with that name in the current directory, and read a single record that contains
the ellipsoid name, year, major-axis (in m), minor-axis (in m), and flattening (f) from
the first record, where the fields must be separated by white-space (not commas).  This way a
custom ellipsoid (e.g., those used for other planets) may be used.  A negative flattening means
\fBGMT\fP will recalculate flattening from the two radii.
.TP
.B FIELD_DELIMITER
This setting determines what character will separate ASCII output data columns written by \fBGMT\fP.  Choose
from tab, space, comma, and none [tab].
.TP
.B FRAME_PEN
Thickness of pen used to draw plain map frame in dpi units or points (append p)  [1.25p].
.TP
.B FRAME_WIDTH
Width (> 0) of map borders for fancy map frame [0.2\fBc\fP (or 0.075\fBi\fP)].
.TP
.B GLOBAL_X_SCALE
Global x-scale (> 0) to apply to plot-coordinates before plotting.  Normally used to shrink
the entire output down to fit a specific height/width  [1.0].
.TP
.B GLOBAL_Y_SCALE
Same, but for y-coordinates  [1.0].
.TP
.B GRID_CROSS_SIZE_PRIMARY
Size (>= 0) of grid cross at lon-lat intersections.  0 means draw continuous gridlines
instead [0].
.TP
.B GRID_PEN_PRIMARY
Pen thickness used to draw grid lines in dpi units or points (append p) [0.25p].
.TP
.B GRID_CROSS_SIZE_SECONDARY
Size (>= 0) of grid cross at secondary lon-lat intersections.  0 means draw continuous gridlines
instead [0].
.TP
.B GRID_FORMAT
Default file format for grids, with optional scale, offset and invalid value, written as
ff/scale/offset/invalid. The 2-letter format indicator can be one of [bcnsr][bsifd]. The first
letter indicates native \fBGMT\fP binary, old format NetCDF, COARDS-compliant NetCDF, Surfer format or Sun
Raster format. The second letter stands for byte, short, int, float and double, respectively. When
/invalid is omitted the appropriate value for the given format is used (NaN or largest negative).
When /scale/offset is omitted, /1.0/0.0 is used. [nf].
.TP
.B GRID_PEN_SECONDARY
Pen thickness used to draw grid lines in dpi units or points (append p) [0.5p].
.TP
.B GRIDFILE_SHORTHAND
If TRUE, all gridfile names are examined to see if they use the file extension
shorthand discussed in Section 4.17 of the \fBGMT\fP Technical Reference and Cookbook.
If FALSE, no filename expansion is done [FALSE].
.TP
.B HEADER_FONT
Font to use when plotting headers.  See \fBANNOT_FONT_PRIMARY\fP for available fonts  [Helvetica].
.TP
.B HEADER_FONT_SIZE
Font size (> 0) for header in points  [36].
.TP
.B HEADER_OFFSET
Distance from top of axis annotations (or axis label, if present) to base of plot header [0.5\fBc\fP (or 0.1875\fBi\fP)].
.TP
.B HISTORY
If TRUE, passes the history of past common command options via the hidden .gmtcommands4 file [TRUE].
.TP
.B HSV_MIN_SATURATION
Minimum saturation (0\-1) assigned for most negative intensity value [1.0].
.TP
.B HSV_MAX_SATURATION
Maximum saturation (0\-1) assigned for most positive intensity value [0.1].
.TP
.B HSV_MIN_VALUE
Minimum value (0\-1) assigned for most negative intensity value [0.3].
.TP
.B HSV_MAX_VALUE
Maximum value (0\-1) assigned for most positive intensity value [1.0].
.TP
.B INPUT_CLOCK_FORMAT
Formatting template that indicates how an input clock string is formatted.  This template
is then used to guide the reading of clock strings in data fields.  To properly decode
12-hour clocks, append am or pm (or upper case) to match your data records. As examples,
try hh:mm, hh:mm:ssAM, etc. [hh:mm:ss].
.TP
.B INPUT_DATE_FORMAT
Formatting template that indicates how an input date string is formatted.  This template
is then used to guide the reading of date strings in data fields.  You may specify either
Gregorian calendar format or ISO week calendar format.  Gregorian calendar: Use any
combination of yyyy (or yy for 2-digit years; if so see \fBY2K_OFFSET_YEAR\fP), mm (or o
for abbreviated month name in the current time language),
and dd, with or without delimiters.  For day-of-year data, use jjj instead of mm and/or dd.
Examples can be ddmmyyyy, yy-mm-dd, dd-o-yyyy, yyyy/dd/mm, yyyy-jjj, etc.
ISO Calendar:  Expected template is yyyy[-]W[-]ww[-]d, where ww is ISO week and d is ISO week
day.  Either template must be consistent, e.g., you cannot specify months if you don't specify\"'
years.  Examples are yyyyWwwd, yyyy-Www, etc. [yyyy-mm-dd].
.TP
.B INTERPOLANT
Determines if linear (linear), Akima's spline (akima), or natural cubic spline (cubic) should\"'
be used for 1-D interpolations in various programs [akima].
.TP
.B IO_HEADER
(\fB* \-H\fP) Specifies whether input/output ASCII files have header record(s) or not  [FALSE].
.TP
.B N_HEADER_RECS
Specifies how many header records to expect if \fB\-H\fP is turned on  [1].
.TP
.B LABEL_FONT
Font to use when plotting labels below axes.  See \fBANNOT_FONT_PRIMARY\fP for available fonts  [Helvetica].
.TP
.B LABEL_FONT_SIZE
Font size (> 0) for labels in points  [24].
.TP
.B LABEL_OFFSET
Distance from base of axis annotations to the top of the axis label [0.3\fBc\fP (or 0.1125\fBi\fP)].
.TP
.B LINE_STEP
Determines the maximum length (> 0) of individual straight line-segments when drawing arcuate lines  [0.025\fBc\fP (or 0.01\fBi\fP)]
.TP
.B MAP_SCALE_FACTOR
Changes the default map scale factor used for the Polar Stereographic [0.9996], UTM [0.9996], and Transverse Mercator [1] projections
in order to minimize areal distortion.  Provide a new scale-factor or leave as default.
.TP
.B MAP_SCALE_HEIGHT
Sets the height (> 0) on the map of the map scale bars drawn by various programs [0.2\fBc\fP (or 0.075\fBi\fP)].
.TP
.B MEASURE_UNIT
Sets the unit length.  Choose between cm, inch, m, and point.  [cm].  Note
that, in \fBGMT\fP, one point is defined as 1/72 inch (the \fIPostScript\fP definition), while it
is often defined as 1/72.27 inch in the typesetting industry.  There is no
universal definition.
.TP
.B N_COPIES
(\fB* \-c\fP) Number of plot copies to make  [1].
.TP
.B OBLIQUE_ANNOTATION
This integer is a sum of 6 bit flags (most of which only are relevant for oblique projections):
If bit 1 is set (1), annotations will occur wherever a gridline crosses the
map boundaries, else longitudes will be annotated on the lower and upper boundaries only, and latitudes will be
annotated on the left and right boundaries only.  If bit 2 is set (2), then longitude annotations will
be plotted horizontally.  If bit 3 is set (4), then latitude annotations will be plotted horizontally.
If bit 4 is set (8), then oblique tickmarks are extended to give a projection equal to the specified tick_length.
If bit 5 is set (16), tickmarks will be drawn normal to the border regardless of gridline angle.
If bit 6 is set (32), then latitude annotations will be plotted parallel to the border.
To set a combination of these, add up the values in parentheses. [1].
.TP
.B OUTPUT_CLOCK_FORMAT
Formatting template that indicates how an output clock string is to be formatted.  This template
is then used to guide the writing of clock strings in data fields.  To use a floating point
format for the smallest unit (e.g. seconds), append .xxx, where the number of x indicates
the desired precision.  If no floating point is indicated then the smallest specified unit
will be rounded off to nearest integer.  For 12-hour clocks, append am, AM, a.m., or A.M. (\fBGMT\fP
will replace a|A with p|P for pm).  If your template starts with a leading hyphen (-) then each integer item (y,m,d) will be
printed without leading zeros (default uses fixed width formats).  As examples, try
hh:mm, hh.mm.ss, hh:mm:ss.xxxx, hha.m., etc. [hh:mm:ss].
.TP
.B OUTPUT_DATE_FORMAT
Formatting template that indicates how an output date string is to be formatted.  This template
is then used to guide the writing of date strings in data fields.  You may specify either
Gregorian calendar format or ISO week calendar format.  Gregorian calendar: Use any
combination of yyyy (or yy for 2-digit years; if so see \fBY2K_OFFSET_YEAR\fP), mm (or o for
abbreviated month name in the current time language),
and dd, with or without delimiters.  For day-of-year data, use jjj instead of mm and/or dd.
As examples, try yy/mm/dd, yyyy=jjj, dd-o-yyyy, dd-mm-yy, yy-mm, etc.
ISO Calendar:  Expected template is yyyy[-]W[-]ww[-]d, where ww is ISO week and d is ISO week
day.  Either template must be consistant, e.g., you cannot specify months if you don't specify\"'
years.  As examples, try yyyyWww, yy-W-ww-d, etc. If your template starts with a leading hyphen (-) then each integer item (y,m,d) will be
printed without leading zeros (default uses fixed width formats) [yyyy-mm-dd].
.TP
.B OUTPUT_DEGREE_FORMAT
Formatting template that indicates how an output geographical coordinate is to be formatted.  This template
is then used to guide the writing of geographical coordinates in data fields.  The template is in
general of the form [+|-]D or [+|-]ddd[:mm[:ss]][.xxx][F].  The various terms have the following purpose:
.sp
.br
+	means output longitude in the 0 to 360 range [-180/+180]
.br
-	means output longitude in the -360 to 0 range [-180/+180]
.br
D	Use \fBD_FORMAT\fP for floating point degrees.
.br
ddd	Fixed format integer degrees
.br
:	delimiter used
.br
mm	Fixed format integer arc minutes
.br
ss	Fixed format integer arc seconds
.br
.xxx	Floating fraction of previous integer field, fixed width.
.br
F	Encode sign using WESN suffix
.br
.sp
The default is +D.
.TP
.B PAGE_COLOR
Sets the color of the imaging background, i.e., the paper.
Give a red/green/blue triplet, with each element in the 0\-255 range. [255/255/255] (white).
.TP
.B PAGE_ORIENTATION
(\fB* \-P\fP) Sets the orientation of the page.  Choose portrait or landscape  [landscape].
.TP
.B PAPER_MEDIA
Sets the physical format of the current plot paper [A4].  The following
formats (and their widths and heights in points) are recognized (Additional
site-specific formats may be specified in
the gmtmedia.d file in \fB$GMTHOME\fP/share; see that file for details):
.br
.sp
Media	width	height
.br
A0	2380	3368
.br
A1	1684	2380
.br
A2	1190	1684
.br
A3	842	1190
.br
A4	595	842
.br
A5	421	595
.br
A6	297	421
.br
A7	210	297
.br
A8	148	210
.br
A9	105	148
.br
A10	74	105
.br
B0	2836	4008
.br
B1	2004	2836
.br
B2	1418	2004
.br
B3	1002	1418
.br
B4	709	1002
.br
B5	501	709
.br
archA	648	864
.br
archB	864	1296
.br
archC	1296	1728
.br
archD	1728	2592
.br
archE	2592	3456
.br
flsa	612	936
.br
halfletter	396	612
.br
note	540	720
.br
letter	612	792
.br
legal	612	1008
.br
11x17	792	1224
.br
ledger	1224	792
.br
.sp
For a completely custom format (e.g., for large format plotters) you may also
specify Custom_WxH, where W and H are in points.
To force the printer to request a manual paper feed, append '-' to the media
name, e.g., A3- will require the user to insert a A3 paper into the printer's\"'
manual feed slot.  To indicate you are making an EPS file, append '+' to the
media name.  Then, \fBGMT\fP will attempt to issue a tight bounding box [Default 
Bounding Box is the paper dimension].
.TP
.B PLOT_CLOCK_FORMAT
Formatting template that indicates how an output clock string is to be plotted.  This template
is then used to guide the formatting of clock strings in plot annotations.  See \fBOUTPUT_CLOCK_FORMAT\fP
for details. [hh:mm:ss].
.TP
.B PLOT_DATE_FORMAT
Formatting template that indicates how an output date string is to be plotted.  This template
is then used to guide the plotting of date strings in data fields.  See \fBOUTPUT_DATE_FORMAT\fP
for details.  In addition, you may use a single o instead of mm (to plot month name) and
u instead of W[-]ww to plot "Week ##".  Both of these text strings will be affected by
the \fBTIME_LANGUAGE\fP setting.  [yyyy-mm-dd].
.TP
.B PLOT_DEGREE_FORMAT
Formatting template that indicates how an output geographical coordinate is to be plotted.  This template
is then used to guide the plotting of geographical coordinates in data fields.  See 
\fBOUTPUT_DEGREE_FORMAT\fP for details.  In addition, you can append A which plots the absolute value of 
the coordinate.  The default is +ddd:mm:ss.  Not all items may be plotted as this depends on the annotation 
interval.
.TP
.B POLAR_CAP
Controls the appearance of gridlines near the poles for all azimuthal projections and a few others in which
the geographic poles are plotted as points (Lambert Conic, Hammer, Mollweide, Sinusoidal, and van der Grinten).  Specify either none (in which
case there is no special handling) or \fIpc_lat\fP/\fIpc_dlon\fP.  In that case, normal gridlines are only drawn between
the latitudes -\fIpc_lat\fP/+\fIpc_lat\fP, and above those latitudes the gridlines are spaced at the (presumably coarser)
\fIpc_dlon\fP interval; the two domains are separated by a small circle drawn at the \fIpc_lat\fP latitude [85/90].
.TP
.B PS_COLOR
Determines whether PostScript output should use RGB, HSV, or CMYK when specifying color [RGB].
Note if HSV is selected it does not apply to images which in that case uses RGB.
.TP
.B PS_IMAGE_COMPRESS
Determines if PostScript images are compressed using the Run-Length Encoding scheme (rle),
LZW compression (lzw), or not at all (none) [none].
.TP
.B PS_IMAGE_FORMAT
Determines whether images created in PostScript should use ASCII
or binary format.  The latter takes up less space and executes faster but may choke
some printers, especially those off serial ports.  Select ascii or bin [ascii].
.TP
.B PS_LINE_CAP
Determines how the ends of a line segment will be drawn.  Choose among a \fIbutt\fP cap (default)
where there is no projection beyond the end of the path, a \fIround\fP cap where a
semicircular arc with diameter equal to the linewidth is drawn around the end points,
and \fIsquare\fP cap where a half square of size equal to the linewidth extends beyond
the end of the path [butt].
.TP
.B PS_LINE_JOIN
Determines what happens at kinks in line segments.  Choose among a \fImiter\fP join
where the outer edges of the strokes for the two segments are extended until they
meet at an angle (as in a picture frame; if the angle is too acute, a bevel join is used
instead, with threshold set by \fBPS_MITER_LIMIT\fP), \fIround\fP join where a
circular arc is used to fill in the cracks at the kinks, and \fIbevel\fP join which
is a miter join that is cut off so kinks are triangular in shape [miter].
.TP
.B PS_MITER_LIMIT
Sets the threshold angle (integer in 0-180 range) used for mitered joins.  0 and 180
are special flag values that imply the PostScript default [11] and always bevels,
respectively.  Other values sets the acute angle used to decide between mitered and bevelled.
.TP
.B PS_VERBOSE
If TRUE we will issue comments in the \fIPostScript\fP file that explain the logic of operations.
These are useful if you need to edit the file and make changes; otherwise you can set it to
FALSE which yields a somewhat slimmer \fIPostScript\fP file [FALSE].
.TP
.B TICK_LENGTH
The length of a tickmark.  Normally, tickmarks are drawn on the outside of
the map boundaries.  To select interior tickmarks, use a negative tick_length [0.2\fBc\fP (or 0.075\fBi\fP)].
.TP
.B TICK_PEN
The pen thickness to be used for tickmarks in dpi units or points (append p) [0.5p].
.TP
.B TIME_FORMAT_PRIMARY
Controls how primary month-, week-, and weekday-names are formatted.  Choose among full, abbreviated, and
character.  If the leading f, a, or c are replaced with F, A, and C the entire annotation will be in upper case. 
.TP
.B TIME_FORMAT_SECONDARY
Controls how secondary month-, week-, and weekday-names are formatted.  Choose among full, abbreviated, and
character.  If the leading f, a, or c are replaced with F, A, and C the entire annotation will be in upper case. 
.TP
.B TIME_EPOCH
Specifying this parameter also sets \fBTIME_SYSTEM\fP to OTHER.  It is a string
of the form yyyy-mm-ddT[hh:mm:ss] (Gregorian) or yyyy-Www-ddT[hh:mm:ss] (ISO) indicating
the value of the calendar and clock at the origin (zero point) of relative time units (see \fBTIME_UNIT\fP).
.TP
.B TIME_IS_INTERVAL
Used when input calendar data should be truncated and adjusted to the middle of the relevant interval.
In the following discussion, the unit \fBu\fP can be one of these time units: (\fBy\fP year, \fBo\fP month,
\fBu\fP ISO week, \fBd\fP day, \fBh\fP hour, \fBm\fP minute, and \fBc\fP second).  \fBTIME_IS_INTERVAL\fP
can have any of the following three values: (1) OFF [Default].  No adjustment, time is decoded as given.
(2) +\fIn\fP\fBu\fP.  Activate interval adjustment for input by truncate to previous whole number of \fIn\fP
units and then center time on the following interval.  (3) -\fIn\fP\fBu\fP.  Same, but center time on the
previous interval.  For example, with \fBTIME_IS_INTERVAL\fP = +1o, an input data string like 1999-12 will
be interpreted to mean 1999-12-15T12:00:00.0 (exactly middle of December), while if \fBTIME_IS_INTERVAL\fP = OFF
then that date is interpreted to mean 1999-12-1T00:00:00.0 (start of December).
.TP
.B TIME_INTERVAL_FRACTION
Determines if partial intervals at the start and end of an axis should be annotated.  If the range of the partial
interval exceeds the specified fraction of the normal interval stride we will place the annotation centered on the
partial interval [0.5].
.TP
.B TIME_LANGUAGE
Language to use when plotting calendar items such as months and days.  Select from:
.br
BR	Brazilian Portuguese
.br
CN1	Simplified Chinese
.br
CN2	Traditional Chinese
.br
DE	German
.br
DK	Danish
.br
EH	Basque
.br
ES	Spanish
.br
FI	Finnish
.br
FR	French
.br
GR	Greek
.br
HU	Hungarian
.br
IE	Irish
.br
IL	Hebrew
.br
IS	Icelandic
.br
IT	Italian
.br
JP	Japanese
.br
NL	Dutch
.br
NO	Norwegian
.br
PL	Polish
.br
PT	Portuguese
.br
RU	Russian
.br
SE	Swedish
.br
SG	Scottish Gaelic
.br
TO	Tongan
.br
TR	Turkish
.br
UK	British English
.br
US	US English
.br
.sp
If your language is not supported, please examine the \fB$GMTHOME\fP/share/time/us.d file and
make a similar file.  Please submit it to the \fBGMT\fP Developers for official inclusion. 
.TP
.B TIME_SYSTEM
Determines which time epoch the relative time refers to and what the units are.  Choose from one of the preset systems below
(epoch and units are indicated):
.br
JD	Julian Date, -4713-11-25T12:00:00 d
.br
MJD	Modified Julian Date, 1858-11-27T00:00:00 d
.br
J2000	2000-01-01T00:00:00 d
.br
S1985	1985-01-01T00:00:00 c
.br
UNIX	1970-01-01T00:00:00 c
.br
RD0001	0001-01-01T00:00:00 c
.br
RATA	0000-12-31T00:00:00 d
.br
or specify OTHER and supply your own \fBTIME_EPOCH\fP and \fBTIME_UNIT\fP settings [J2000].
.TP
.B TIME_UNIT
This parameter is active only when \fBTIME_SYSTEM\fP is set to OTHER, and specifies the
units of relative time data.  Choose y (year - assumes all years are 365.2425 days), o (month - assumes
all months are of equal length y/12), d (day), h (hour), m (minute), or c (second).
.TP
.B TIME_WEEK_START
When weeks are indicated on time axes, this parameter determines the first day of the week
for Gregorian calendars.  (The ISO weekly calendar always begins weeks with Monday.)
[Monday (or Sunday)].
.TP
.B UNIX_TIME
(\fB* \-U\fP) Specifies if a UNIX system time stamp should be plotted
at the lower left corner of the plot  [FALSE].
.TP
.B UNIX_TIME_POS
(\fB* \-U\fP) Sets the position of the UNIX time stamp relative to the current plots lower left corner [-2\fBc\fP/-2\fBc\fP (or -0.75\fBi\fP/-0.75\fBi\fP)].
.TP
.B VECTOR_SHAPE
Determines the shape of the head of a vector.   Normally (i.e., for vector_shape = 0),
the head will be triangular, but can be changed to an arrow (1) or an open V (2).
Intermediate settings give something in between. Negative values (up to -2) are allowed as well  [0].
.TP
.B VERBOSE
(\fB* \-V\fP) Determines if \fBGMT\fP programs should display run-time information or run silently  [FALSE].
.TP
.B X_AXIS_LENGTH
Sets the default length (> 0) of the x-axis [25\fBc\fP (or 9\fBi\fP)].
.TP
.B Y_AXIS_LENGTH
Sets the default length (> 0) of the y-axis [15\fBc\fP (or 6\fBi\fP)].
.TP
.B X_ORIGIN
(\fB* \-X\fP) Sets the x-coordinate of the origin on the paper for a new plot [2.5\fBc\fP (or 1\fBi\fP)].
For an overlay, the default offset is 0.
.TP
.B Y_ORIGIN
(\fB* \-Y\fP) Sets the y-coordinate of the origin on the paper for a new plot [2.5\fBc\fP (or 1\fBi\fP)].
For an overlay, the default offset is 0.
.TP
.B Y2K_OFFSET_YEAR
When 2-digit years are used to represent 4-digit years (see various \fBDATE_FORMAT\fPs), \fBY2K_OFFSET_YEAR\fP 
gives the first year in a 100-year sequence.  For example, if \fBY2K_OFFSET_YEAR\fP is 1729, then numbers 
29 through 99 correspond to 1729 through 1799, while numbers 00 through 28 correspond to 1800 through 
1828. [1950].
.TP
.B XY_TOGGLE
(\fB* \-:\fP) Set if the first two columns of input and output files contain (latitude,longitude) or (y,x) rather than the expected
(longitude,latitude) or (x,y).  FALSE means we have (x,y) both on input and output.  TRUE means both input and output
should be (y,x).  IN means only input has (y,x), while OUT means only output should be (y,x).  [FALSE].
.TP
.B Y_AXIS_TYPE
Determines if the annotations for a y-axis (for linear projections) should be plotted horizontally (hor_text)
or vertically (ver_text)  [hor_text].
.SH EXAMPLES
To get a copy of the \fBGMT\fP parameter defaults in your home directory, run
.br
.sp
\fBgmtdefaults\fP \fB\-D\fP > ~/.gmtdefaults4
.br
.sp
You may now change the settings by editing this file using a text editor of your choice, or
use \fBgmtset\fP to change specified parameters on the command line.
.SH BUGS
If you have typographical errors in your \.gmtdefaults4 file(s), a warning message will be
issued, and the \fBGMT\fP defaults for the affected parameters will be used.
.SH "SEE ALSO"
.IR GMT (l),
.IR gmtset (l)
