.TH GRDLANDMASK l "18 Apr 2001"
.SH NAME
grdlandmask \- Create "wet-dry" mask grdfile from shoreline data base.
.SH SYNOPSIS
\fBgrdlandmask\fP \fB\-G\fP\fImask_grd_file\fP] \fB\-I\fP\fIxinc\fP[\fBm|c\fP][/\fIyinc\fP[\fBm|c\fP]]
\fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] [ \fB\-A\fP\fImin_area\fP[/\fImin_level/max_level\fP] ] [ \fB\-D\fP\fIresolution\fP ] [ \fB\-F\fP ] [ \fB\-N\fP\fImaskvalues\fP[\fBo\fP] ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdlandmask\fP reads the selected shoreline database and uses that information to decide which
nodes in the specified grid are over land or over water. The nodes defined by
the selected region and lattice spacing will be set according to one of two criteria:
(1) Lands vs water, or (2) the more detailed (hierarchial) ocean vs land vs lake vs island vs pond. The
resulting mask grdfile may be used in subsequent operations involving \fBgrdmath\fP to mask out
data from land [or water] areas.
.TP
.B \-G
Name of resulting output mask grd file.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest. To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.TP
.B \-A
Features with an area smaller than \fImin_area\fP in km^2 or of hierarchical level that is lower than \fImin_level\fP or higher than \fImax_level\fP
will be ignored [Default is 0/4 (all features)]. See DATABASE INFORMATION in the \fBpscoast\fP man-pages for more details.
.TP
.B \-D
Selects the resolution of the data set to use ((\fBf\fP)ull, (\fBh\fP)igh, (\fBi\fP)ntermediate, (\fBl\fP)ow, or (\fBc\fP)rude). The
resolution drops off by ~80% between data sets. [Default is \fBl\fP]. Note that because the coastlines differ in details a
node in a mask file using one resolution is not guaranteed to remain inside [or outside] when a different resolution is selected.
.TP
.B \-F
Force pixel registration. [Default is grid registration].
.TP
.B \-N
Sets the values that will be assigned to nodes. Values can be any number, including the
textstring NaN. Append \fBo\fP to let nodes exactly on feature boundaries be considered outside [Default is inside].
Specify this information using 1 of 2 formats:
.br
        \fB\-N\fP\fIwet/dry\fP.
.br
        \fB\-N\fP\fIocean/land/lake/island/pond\fP.
.br
[Default is 0/1/0/1/0 (i.e., 0/1)].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To set all nodes on land to NaN, and nodes over water to 1, using the high resolution data set, do
.br
.sp
grdlandmask \fB\-R\fP-60/-40/-40/-30 \fB\-Dh \-I\fP5\fBm \-N\fP1/NaN \fB\-G\fPland_mask.grd \fB\-V\fP
.br
.sp
To make a 1x1 degree global grid with the hierarchical levels of the nodes based on the low resolution data, try
.br
.sp
grdlandmask \fB\-R\fP0/360/-90/90 \fB\-Dl \-I\fP1 \fB\-N\fP0/1/2/3/4 \fB\-G\fPlevels.grd \fB\-V\fP
.br
.SH "SEE ALSO"
.IR gmt (l),
.IR grdmath (l),
.IR grdclip (l),
.IR psmask (l),
.IR psclip (l),
.IR pscoast (l)
