/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <string.h>

#include "config.h"
#include "window.h"
#include "dialog.h"

void return_value(GtkWidget *but, GtkWidget **ret) {
    *ret = but;
}

int gm_dialog_popup(const char *title, const char *text, 
                    int buttons, int modal) {
    char *button_names[] = {_("Ok"), _("Yes"), _("No"), _("Cancel"),
                            _("Done"), _("Abort"), _("Retry"), _("Ignore")};
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *tmp;
    GtkWidget *hbuttonbox;
    int i;

    if(debug) printf("Openeing popup dialog\n");

    window = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_window_set_transient_for(GTK_WINDOW(window),
				 GTK_WINDOW(gm_window_get_window()));
    gtk_object_set_data (GTK_OBJECT (window), "window", window);
    gtk_window_set_title (GTK_WINDOW (window), title);
    gtk_window_set_modal(GTK_WINDOW(window), modal);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event",
                       GTK_SIGNAL_FUNC(gtk_true), NULL);

    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
    gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
    gtk_window_set_wmclass (GTK_WINDOW (window), "gmoo_popup_dialog", "gmoo");
    gtk_window_set_default_size(GTK_WINDOW(window), -1, 200);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    
    tmp = gtk_label_new(text);
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.5, 0.5);
    gtk_misc_set_padding(GTK_MISC(tmp), 5, 5);
    gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 0);

    tmp = gtk_hseparator_new ();
    gtk_widget_show (tmp);
    gtk_box_pack_start (GTK_BOX (vbox), tmp, FALSE, FALSE, 5);
    
    hbuttonbox = gtk_hbutton_box_new ();
    gtk_widget_show (hbuttonbox);
    gtk_container_set_border_width(GTK_CONTAINER(hbuttonbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbuttonbox, FALSE, FALSE, 0);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), 
                               GTK_BUTTONBOX_SPREAD);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox), 0);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox), 0, 0);
    
    
    for(i = 0; i < B_COUNT; i++) {
        if(buttons & (1 << i)) {
            tmp = gtk_button_new_with_label(button_names[i]);
            gtk_widget_show (tmp);
            gtk_container_add (GTK_CONTAINER (hbuttonbox), tmp);
            GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
            gtk_widget_grab_default(tmp);
            gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
                               GTK_SIGNAL_FUNC(return_value), &tmp);
        }
    }
    tmp = NULL;

    if(debug) printf("Done opening\n");

    gtk_widget_show(window);
    while(tmp == NULL) {
        gtk_main_iteration_do(TRUE);
    }
    gtk_widget_hide(window);

    if(debug) printf("Closing now...\n");

    for(i = 0; i < B_COUNT; i++) {
        if(strcmp(button_names[i], GTK_LABEL(GTK_BIN(tmp)->child)->label) == 0)
            break;
    }

    gtk_widget_destroy(window);
    if(debug) printf("Selected button \"%s\" (i << %d == %d)\n", 
                     button_names[i], i, 1 << i);
    return 1 << i;
}

void set_to_true (GtkWidget *w, int *var) { *var = TRUE;  }
void set_to_false(GtkWidget *w, int *var) { *var = FALSE; }

char *gm_dialog_text(const char *title, const char *text, const char *def,
		     int modal) {
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *vbox2;
    GtkWidget *tmp;
    GtkWidget *entry;
    GtkWidget *hbuttonbox;
    char *ret;
    int button;

    if(debug) printf("Openeing text dialog\n");

    window = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_window_set_transient_for(GTK_WINDOW(window),
				 GTK_WINDOW(gm_window_get_window()));
    gtk_object_set_data (GTK_OBJECT (window), "window", window);
    gtk_window_set_title (GTK_WINDOW (window), title);
    gtk_window_set_modal(GTK_WINDOW(window), modal);

    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
    gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
    gtk_window_set_wmclass (GTK_WINDOW (window), "gmoo_popup_dialog", "gmoo");
    gtk_window_set_default_size(GTK_WINDOW(window), -1, 200);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		       GTK_SIGNAL_FUNC(gtk_true), NULL);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    
    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox2);
    gtk_container_add (GTK_CONTAINER (vbox), vbox2);
    gtk_container_border_width(GTK_CONTAINER(vbox2), 5);
    
    tmp = gtk_label_new(text);
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.5, 0.5);
    gtk_misc_set_padding(GTK_MISC(tmp), 5, 5);
    gtk_box_pack_start(GTK_BOX(vbox2), tmp, FALSE, FALSE, 0);

    entry = gtk_entry_new();
    gtk_widget_show(entry);
    if(def) gtk_entry_set_text(GTK_ENTRY(entry), def);
    gtk_box_pack_start(GTK_BOX(vbox2), entry, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(entry), "activate",
		       GTK_SIGNAL_FUNC(set_to_true), &button);

    tmp = gtk_hseparator_new ();
    gtk_widget_show (tmp);
    gtk_box_pack_start (GTK_BOX (vbox), tmp, FALSE, FALSE, 5);
    
    hbuttonbox = gtk_hbutton_box_new ();
    gtk_widget_show (hbuttonbox);
    gtk_container_set_border_width(GTK_CONTAINER(hbuttonbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbuttonbox, FALSE, FALSE, 0);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), 
			       GTK_BUTTONBOX_SPREAD);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox), 0);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox), 0, 0);
    
    tmp = gtk_button_new_with_label(_("Ok"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(tmp);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(set_to_true), &button);

    tmp = gtk_button_new_with_label(_("Cancel"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(set_to_false), &button);

    gtk_widget_grab_focus(entry);

    gtk_widget_show(window);
    
    button = -1;
    while(button == -1) {
	gtk_main_iteration_do(TRUE);
    }
    if(button)
	ret = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
    else
	ret = NULL;

    gtk_widget_destroy(window);
    if(debug) printf("Selected text \"%s\"\n", ret == NULL ? "(nothing)" : ret);

    return ret;
}

void destroy_toplevel(GtkWidget *w) {
    gtk_widget_destroy(gtk_widget_get_toplevel(w));
}

void gm_dialog_popup_only(const char *title, const char *text, 
			  int modal) {
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *tmp;
    GtkWidget *hbuttonbox;

    if(debug) printf("Openeing popup_only dialog\n");

    window = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_window_set_transient_for(GTK_WINDOW(window),
				 GTK_WINDOW(gm_window_get_window()));
    gtk_object_set_data (GTK_OBJECT (window), "window", window);
    gtk_window_set_title (GTK_WINDOW (window), title);
    gtk_window_set_modal(GTK_WINDOW(window), modal);

    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
    gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
    gtk_window_set_wmclass (GTK_WINDOW (window), "gmoo_popup_dialog", "gmoo");
    gtk_window_set_default_size(GTK_WINDOW(window), -1, 200);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		       GTK_SIGNAL_FUNC(gtk_true), NULL);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    
    tmp = gtk_label_new(text);
    gtk_widget_show(tmp);
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.5, 0.5);
    gtk_misc_set_padding(GTK_MISC(tmp), 5, 5);
    gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 0);

    tmp = gtk_hseparator_new ();
    gtk_widget_show (tmp);
    gtk_box_pack_start (GTK_BOX (vbox), tmp, FALSE, FALSE, 5);
    
    hbuttonbox = gtk_hbutton_box_new ();
    gtk_widget_show (hbuttonbox);
    gtk_container_set_border_width(GTK_CONTAINER(hbuttonbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbuttonbox, FALSE, FALSE, 0);
    gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox), 
			       GTK_BUTTONBOX_SPREAD);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox), 0);
    gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox), 0, 0);
    
    tmp = gtk_button_new_with_label(_("OK"));
    gtk_widget_show (tmp);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), tmp);
    GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(tmp);
    gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
		       GTK_SIGNAL_FUNC(destroy_toplevel), NULL);

    gtk_widget_show(window);
}
