/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_CONFIGDB_H
#define GM_CONFIGDB_H

#include <glib.h>

#define _NULL "(null)"

struct _ConfigDBNode {
    char *key;
    char *value;
};

typedef GList                ConfigDB;
typedef struct _ConfigDBNode ConfigDBNode;



ConfigDB *configdb_load(const char *filename, int secure);
void      configdb_free(ConfigDB *db);
void      configdb_store(ConfigDB *db, const char *filename, int secure);


int   configdb_get_int(ConfigDB *db, const char *key, int default_value);
char *configdb_get_string(ConfigDB *db, const char *key,
			   const char *default_value);
void  configdb_get_rgb(ConfigDB *db, const char *key, 
		       const char *default_value,
		       gushort *r, gushort *g, gushort *b);

ConfigDB *configdb_set_int  (ConfigDB *db, const char *key, int value);
ConfigDB *configdb_set_string(ConfigDB *db, const char *key, 
			      const char *value);
ConfigDB *configdb_set_rgb(ConfigDB *db, const char *key, 
			   gushort r, gushort g, gushort b);

ConfigDB *configdb_delete(ConfigDB *db, const char *key);

#endif /* GM_CONFIGDB_H */
