#ifndef	_VITERBI_H
#define	_VITERBI_H

#define	PATHMEM		128
#define	TRACECHUNK	8

struct viterbi {
	long cmetric[64];
	long nmetric[64];
	unsigned long paths[2 * PATHMEM];
	int mets[4];
	unsigned int pi;
	unsigned int first;
	int mettab[2][256];

	/* returned values */
	unsigned char data[TRACECHUNK / 8];
	int datalen;
	long int metric;
};

/* in viterbi27.c */
extern struct viterbi *init_viterbi27(void);
extern void viterbi27(struct viterbi *v, unsigned char symbols[4]);

/* in encode27.c */
extern int encode27(unsigned int *encstate, int data);

/* parity table in tab.c */
extern unsigned char Partab[];

#endif
