
/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 * 
 * DO NOT EDIT: this file has been generated automatically by MetaDOM
 */

#ifndef __GdomeSmartDOMElement_hh__
#define __GdomeSmartDOMElement_hh__


#include "GdomeSmartDOMNode.hh"


namespace GdomeSmartDOM {

class Element
: public Node
{
public:
  Element(GdomeElement*);
  Element(const Element&);
  Element(const Node&);
  
  ~Element();

  Element& operator=(const Element&);
  bool operator==(const Element&) const;
  bool operator!=(const Element& obj) const { return !(*this == obj); }
  
  

  // Attributes
  
  class DOMString get_tagName(void) const;
  
  // Methods
  class DOMString getAttribute(const class DOMString&) const;
  void setAttribute(const class DOMString&, const class DOMString&) const;
  void removeAttribute(const class DOMString&) const;
  class Attr getAttributeNode(const class DOMString&) const;
  class Attr setAttributeNode(const class Attr&) const;
  class Attr removeAttributeNode(const class Attr&) const;
  class NodeList getElementsByTagName(const class DOMString&) const;
  class DOMString getAttributeNS(const class DOMString&, const class DOMString&) const;
  void setAttributeNS(const class DOMString&, const class DOMString&, const class DOMString&) const;
  void removeAttributeNS(const class DOMString&, const class DOMString&) const;
  class Attr getAttributeNodeNS(const class DOMString&, const class DOMString&) const;
  class Attr setAttributeNodeNS(const class Attr&) const;
  class NodeList getElementsByTagNameNS(const class DOMString&, const class DOMString&) const;
  bool hasAttribute(const class DOMString&) const;
  bool hasAttributeNS(const class DOMString&, const class DOMString&) const;
  

  // Friend classes
  
  friend class Document;
  
  friend class Attr;
    
};

}

#endif // __GdomeSmartDOMElement_hh__

