/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 */

#ifndef __GdomeSmartDOMDOMString_hh__
#define __GdomeSmartDOMDOMString_hh__

#include "GdomeSmartDOMChar.hh"

namespace GdomeSmartDOM {

class DOMString
{
public:
  DOMString(void);
  DOMString(const DOMString&);
  DOMString(const char*);
  DOMString(const char*, unsigned);
  ~DOMString();

  bool       isNull(void) const { return ptr == 0; }
  bool       isEmpty(void) const;
  bool       operator==(const DOMString&) const;
  bool       operator==(const char*) const;
  bool       operator!=(const DOMString& s) const { return !(*this == s); }
  bool       operator!=(const char* s) const { return !(*this == s); }
  DOMString& operator=(const DOMString&);
  DOMString& operator=(const char*);
  DOMString& operator+=(const DOMString&);
  DOMString& operator+=(const char*);
  DOMString  operator+(const DOMString&) const;
  DOMString  operator+(const char*) const;

  DOMString  substr(unsigned, unsigned) const;
  DOMString  clone(void) const;

  unsigned length(void) const;

  Char16 at(unsigned) const;
  Char16& operator[](unsigned);

  void fromC(const char*);
  void fromC(const char*, unsigned);
  void fromUTF8(const Char8*, unsigned);
  void fromUTF16(const Char16*, unsigned);
  void fromUnicode(const Char32*, unsigned);

  char*   toC(void) const;
  Char8*  toUTF8(unsigned&) const;
  Char16* toUTF16(unsigned&) const;
  Char32* toUnicode(unsigned&) const;

  class NullString { };
  class IndexOutOfRange { };

private:
  class DOMStringBuffer* ptr;
};

}

#endif // __GdomeSmartDOMDOMString_hh__

