#ifndef TEXTURE_MAP_H
#define TEXTURE_MAP_H

#include "gliv.h"

/* Infos that can be freed once the map is created. */
typedef struct {
    gint width;
    gint height;
    gint x_tiles;
    gint y_tiles;
    GdkPixbuf *pixbuf;
} loading_data;

/* A rectangle in a map. */
typedef struct {
    gfloat x0;
    gfloat y0;
    gfloat x1;
    gfloat y1;
} tile_dim;

/* A map in a texture. */
typedef struct {
    gint nb_tiles;
    tile_dim *tiles;
    guint *tex_ids;
    guint list;
    loading_data *map_init;
} texture_map;

#endif
