#include <stdlib.h>             /* srandom() */

/*** G_GNUC_PURE ***/

/* Taken from <glib-2.0/glib/gmacros.h> */
#if    __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 96)
#define G_GNUC_PURE                            \
  __attribute__((pure))
#else
#define G_GNUC_PURE
#endif

/*** GRand ***/

typedef void GRand;

GRand *g_rand_new_with_seed(guint32 seed);
#define g_rand_free(rand) G_STMT_START {} G_STMT_END
#define g_rand_int_range(rand, begin, end) (random()%(end-begin))

/*** g_path_get_dirname() ***/

#define g_path_get_dirname g_dirname

/*** g_path_get_basename() ***/

#define g_path_get_basename g_basename

/*** g_build_filename() ***/

gchar *g_build_filename(const gchar * str1, const gchar * str2, gchar * unused);

/*** g_file_test() ***/

#define G_FILE_TEST_EXISTS R_OK

gboolean g_file_test(const gchar * filename, gint test);

/*** Pango ***/

typedef void PangoFontDescription;

#define pango_font_description_from_string(str) NULL
void gtk_widget_modify_font(GtkWidget * widget,
                            PangoFontDescription * font_desc);

/*** GtkWindow ***/

void gtk_window_resize(GtkWindow * window, gint width, gint height);
#define gtk_window_set_decorated(window, setting) G_STMT_START {} G_STMT_END

/*** Stock buttons ***/

#define GTK_STOCK_OK     N_("OK")
#define GTK_STOCK_CANCEL N_("Cancel")

#define gtk_button_new_from_stock gtk_button_new_with_label

/*** GtkColorSelection ***/

#define gtk_color_selection_set_has_opacity_control \
    gtk_color_selection_set_opacity

void gtk_color_selection_get_current_color(GtkColorSelection * colorsel,
                                           GdkColor * color);
void gtk_color_selection_set_current_color(GtkColorSelection * colorsel,
                                           GdkColor * color);

/*** GtkContainer ***/

#define gtk_container_get_children gtk_container_children

/*** Mnemonics ***/

#define gtk_menu_item_new_with_mnemonic gtk_menu_item_new_with_label
#define gtk_check_button_new_with_mnemonic gtk_check_button_new_with_label
#define gtk_radio_button_new_with_mnemonic_from_widget \
    gtk_radio_button_new_with_label_from_widget

/*** GtkFileSelection ***/

void gtk_file_selection_set_select_multiple(GtkFileSelection * filesel,
                                            gboolean select_multiple);
gchar **gtk_file_selection_get_selections(GtkFileSelection * filesel);

/*** GtkAdjustment ***/

gdouble gtk_adjustment_get_value(GtkAdjustment * adjustment);

/*** Signals ***/

typedef GtkSignalFunc GCallback;

#define g_signal_connect(instance, signal, handler, data) \
    gtk_signal_connect(GTK_OBJECT(instance), signal, handler, data)

#define g_signal_connect_after(instance, signal, handler, data) \
    gtk_signal_connect_after(GTK_OBJECT(instance), signal, handler, data)

#define g_signal_connect_swapped(instance, signal, handler, object)  \
    gtk_signal_connect_object(GTK_OBJECT(instance), signal, handler, \
			     (GtkObject *) object)

#define g_signal_handlers_disconnect_by_func gtk_signal_disconnect_by_func
#define G_CALLBACK GTK_SIGNAL_FUNC

/*** Idle priority ***/

#define GDK_PRIORITY_REDRAW GTK_PRIORITY_RESIZE

/*** GdkWindow ***/

void gdk_window_process_all_updates(void);
