/*  Glimmer - gdseditor.h
 *  Copyright 2000 by Chris Phelps
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GDS_EDITOR_H_
#define _GDS_EDITOR_H_
#ifdef __cplusplus
extern "C" {
#endif

#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#include "../gtkextext/gtkextext.h"

#define GDS_TYPE_EDITOR (gds_editor_get_type())
#define GDS_EDITOR(obj) (GTK_CHECK_CAST((obj), GDS_TYPE_EDITOR, GdsEditor))
#define GDS_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GDS_TYPE_EDITOR, GdsEditorClass))
#define GDS_IS_EDITOR(obj) (GTK_CHECK_TYPE((obj), GDS_TYPE_EDITOR))
#define GDS_IS_EDITOR_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDS_TYPE_EDITOR))

typedef struct _GdsEditor GdsEditor;
typedef struct _GdsEditorClass GdsEditorClass;

struct _GdsEditor
{
   GtkExText text;
   gint changed;
};

struct _GdsEditorClass {
   GtkExTextClass parent_class;
};

GtkType gds_editor_get_type(void);
GtkWidget *gds_editor_new(void);
void gds_editor_set_changed(GdsEditor *gds_editor, gpointer data);
gboolean gds_editor_changed(GdsEditor *gds_editor);
void gds_editor_set_style(GdsEditor *gds_editor, GtkStyle *style);

void gds_editor_insert_text(GdsEditor   *editor,
                            const gchar *new_text,
                            gint         new_text_length,
                            gint        *position);

void gds_editor_delete_text(GdsEditor *editor,
                            gint       start_pos,
                            gint       end_pos);

gchar *gds_editor_get_chars(GdsEditor *editor,
                            gint       start_pos,
                            gint       end_pos);

void gds_editor_set_editable(GdsEditor *editor, gboolean editable);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
