/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.deployment.xml;
 
/** 
 * The XML tag names for the ejb-jar dtd
 * @author Danny Coward
 */

public interface EjbTagNames extends TagNames {

    public final static String SESSION = "session";
    public final static String ENTITY = "entity";
    public final static String SESSION_TYPE = "session-type";
    public final static String MESSAGE_DRIVEN = "message-driven";
    
    public final static String EJB_NAME = "ejb-name";
    public final static String HOME = "home";
    public final static String REMOTE = "remote";
    public final static String LOCAL_HOME = "local-home";
    public final static String LOCAL = "local";
    public final static String BUSINESS_LOCAL = "business-local";
    public final static String BUSINESS_REMOTE = "business-remote";
    public final static String EJB_CLASS = "ejb-class";
    public final static String SERVICE_ENDPOINT_INTERFACE = "service-endpoint";
    public final static String ROLE_REFERENCES = "security-role-refs";
    
    // entity
    public final static String PERSISTENCE_TYPE = "persistence-type";
    public final static String PRIMARY_KEY_CLASS = "prim-key-class";
    public final static String PRIMARY_KEY_FIELD = "primkey-field";
    public final static String REENTRANT = "reentrant";
    public final static String PERSISTENT_FIELDS = "persistent-fields";
    public final static String CMP_FIELD = "cmp-field";
    public final static String CMP_VERSION = "cmp-version";
    public final static String CMP_2_VERSION = "2.x";
    public final static String CMP_1_VERSION = "1.x";
    public final static String FIELD_NAME = "field-name";
    public final static String ABSTRACT_SCHEMA_NAME = "abstract-schema-name";

    // relationships
    public final static String RELATIONSHIPS = "relationships";
    public final static String EJB_RELATION = "ejb-relation";
    public final static String EJB_RELATION_NAME = "ejb-relation-name";
    public final static String EJB_RELATIONSHIP_ROLE = "ejb-relationship-role";
    public final static String EJB_RELATIONSHIP_ROLE_NAME = "ejb-relationship-role-name";
    public final static String MULTIPLICITY = "multiplicity";
    public final static String RELATIONSHIP_ROLE_SOURCE = "relationship-role-source";
    public final static String CMR_FIELD = "cmr-field";
    public final static String CMR_FIELD_NAME = "cmr-field-name";
    public final static String CMR_FIELD_TYPE = "cmr-field-type";
    public final static String CASCADE_DELETE = "cascade-delete";

    // application exceptions
    public final static String APPLICATION_EXCEPTION = "application-exception";
    public final static String APP_EXCEPTION_CLASS = "exception-class";
    public final static String APP_EXCEPTION_ROLLBACK = "rollback";

    // ejb-entity-ref
    public final static String REMOTE_EJB_NAME = "remote-ejb-name";

    // query
    public final static String QUERY = "query";
    public final static String QUERY_METHOD = "query-method";
    public final static String EJB_QL = "ejb-ql";
    public final static String QUERY_RESULT_TYPE_MAPPING = "result-type-mapping";
    public final static String QUERY_REMOTE_TYPE_MAPPING = "Remote";
    public final static String QUERY_LOCAL_TYPE_MAPPING = "Local";

    // session
    public final static String TRANSACTION_TYPE = "transaction-type";
    public final static String TRANSACTION_SCOPE = "transaction-scope";

    // message-driven 
    public final static String ACTIVATION_CONFIG = "activation-config";
    public final static String ACTIVATION_CONFIG_PROPERTY = 
        "activation-config-property";
    public final static String ACTIVATION_CONFIG_PROPERTY_NAME = 
        "activation-config-property-name";
    public final static String ACTIVATION_CONFIG_PROPERTY_VALUE = 
        "activation-config-property-value";
    public final static String MESSAGING_TYPE = "messaging-type";
    public final static String MSG_SELECTOR = "message-selector";
    public final static String JMS_ACKNOWLEDGE_MODE = "acknowledge-mode";
    public final static String MESSAGE_DRIVEN_DEST = "message-driven-destination";
    public final static String JMS_SUBSCRIPTION_DURABILITY = "subscription-durability";
    public final static String JMS_SUBSCRIPTION_IS_DURABLE = "Durable";
    public final static String JMS_SUBSCRIPTION_NOT_DURABLE = "NonDurable";
    public final static String JMS_AUTO_ACK_MODE = "Auto-acknowledge";
    public final static String JMS_DUPS_OK_ACK_MODE  = "Dups-ok-acknowledge";
    public final static String JMS_DEST_TYPE = "destination-type";

    public final static String JNDI_NAME = "jndi-name";
    
    public final static String EJB_BUNDLE_TAG = "ejb-jar";
    public final static String EJBS = "enterprise-beans";
    public final static String ASSEMBLY_DESCRIPTOR = "assembly-descriptor";
    public final static String METHOD_PERMISSION = "method-permission";
    public final static String UNCHECKED = "unchecked";
    public final static String EXCLUDE_LIST = "exclude-list";
    public final static String METHOD = "method";
    public final static String METHOD_NAME = "method-name";
    public final static String METHOD_INTF = "method-intf";
    public final static String METHOD_PARAMS = "method-params";
    public final static String METHOD_PARAM = "method-param";
    public final static String CONTAINER_TRANSACTION = "container-transaction";
    public final static String TRANSACTION_ATTRIBUTE = "trans-attribute";
    
    public final static String EJB_CLIENT_JAR = "ejb-client-jar";

    // security-identity
    public final static String SECURITY_IDENTITY = "security-identity";
    public final static String USE_CALLER_IDENTITY = "use-caller-identity";

    // interceptors
    public final static String INTERCEPTOR = "interceptor";
    public final static String INTERCEPTORS = "interceptors";
    public final static String INTERCEPTOR_BINDING = "interceptor-binding";
    public final static String INTERCEPTOR_CLASS = "interceptor-class";
    public final static String INTERCEPTOR_ORDER = "interceptor-order";
    public final static String INTERCEPTOR_BUSINESS_METHOD = "method";
    public final static String EXCLUDE_DEFAULT_INTERCEPTORS = 
        "exclude-default-interceptors";
    public final static String EXCLUDE_CLASS_INTERCEPTORS = 
        "exclude-class-interceptors";
    public final static String AROUND_INVOKE_METHOD = "around-invoke";

    // around-invoke
    public static final String AROUND_INVOKE_CLASS_NAME = "class";
    public static final String AROUND_INVOKE_METHOD_NAME = "method-name";

    // stateful session callbacks
    public final static String POST_ACTIVATE_METHOD = "post-activate";
    public final static String PRE_PASSIVATE_METHOD = "pre-passivate";
    
    // stateful session methods
    public final static String INIT_METHOD = "init-method";
    public final static String INIT_CREATE_METHOD = "create-method";
    public final static String INIT_BEAN_METHOD = "bean-method";
    public final static String REMOVE_METHOD = "remove-method";
    public final static String REMOVE_BEAN_METHOD = "bean-method";
    public final static String REMOVE_RETAIN_IF_EXCEPTION = "retain-if-exception";

    // timeout method
    public final static String TIMEOUT_METHOD = "timeout-method";


}

